/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.filechooser.FileChooserListener;
import com.alee.extended.filechooser.FilesToChoose;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filechooser.SelectionMode;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.filefilter.GroupType;
import com.alee.extended.filefilter.GroupedFileFilter;
import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileViewType;
import com.alee.extended.list.WebFileList;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.GlobalConstants;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.editor.ListEditAdapter;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class WebFileChooserPanel
extends WebPanel {
    private static final ImageIcon BACKWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/backward.png"));
    private static final ImageIcon FORWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/forward.png"));
    private static final ImageIcon FOLDER_UP_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_up.png"));
    private static final ImageIcon FOLDER_HOME_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_home.png"));
    private static final ImageIcon FOLDER_NEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_new.png"));
    private static final ImageIcon REFRESH_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/refresh.png"));
    private static final ImageIcon REMOVE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/remove.png"));
    private static final ImageIcon VIEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/view.png"));
    private static final ImageIcon VIEW_ICONS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/icons.png"));
    private static final ImageIcon VIEW_TILES_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/tiles.png"));
    private static final ImageIcon SETTINGS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/settings.png"));
    private static final ImageIcon OK_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/ok.png"));
    private static final ImageIcon CANCEL_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/cancel.png"));
    private static final File nonexisting = new File("nonexisting");
    private List<FileChooserListener> chooserListeners = new ArrayList<FileChooserListener>();
    private List<DefaultFileFilter> availableFilters;
    private DefaultFileFilter previewFilter;
    private DefaultFileFilter chooseFilter;
    private FilesToChoose filesToChoose;
    private File currentFolder = nonexisting;
    private List<File> navigationHistory = new ArrayList<File>();
    private int currentHistoryIndex = -1;
    private SelectionMode selectionMode = SelectionMode.SINGLE_SELECTION;
    private FileViewType fileViewType = FileViewType.tiles;
    private WebPathField pathField;
    private WebFileTree fileTree;
    private TreeSelectionListener fileTreeListener;
    private WebFileList fileList;
    private WebButton backward;
    private WebButton forward;
    private WebButton folderUp;
    private WebButton folderHome;
    private WebButton folderNew;
    private WebButton refresh;
    private WebButton remove;
    private WebButton view;
    private WebFileChooserField selectedFiles;
    private WebComboBox fileFilters;
    private WebButton ok;
    private ActionListener okListener;
    private WebButton cancel;
    private ActionListener cancelListener;

    public WebFileChooserPanel(boolean bl) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.filesToChoose = FilesToChoose.filesOnly;
        this.availableFilters = GlobalConstants.DEFAULT_FILTERS;
        this.previewFilter = this.availableFilters.get(0);
        this.chooseFilter = this.availableFilters.get(0);
        WebToolBar webToolBar = new WebToolBar(0);
        webToolBar.setToolbarStyle(ToolbarStyle.attached);
        webToolBar.setSpacing(0);
        webToolBar.setFloatable(false);
        this.add((Component)webToolBar, (Object)"North");
        this.pathField = new WebPathField();
        this.pathField.setFileFilter(this.previewFilter, false);
        this.pathField.addWebPathFieldListener(new PathFieldListener(){

            @Override
            public void directoryChanged(File file) {
                WebFileChooserPanel.this.updateShownFolder(file, false, true, true);
            }
        });
        this.backward = new WebButton(BACKWARD_ICON);
        this.backward.setLanguage("weblaf.filechooser.back", new Object[0]);
        this.backward.addHotkey(this, Hotkey.BACKSPACE).setHotkeyDisplayWay(TooltipWay.down);
        this.backward.addHotkey(this, Hotkey.ALT_LEFT).setHotkeyDisplayWay(TooltipWay.down);
        this.backward.setRolloverDecoratedOnly(true);
        this.backward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.currentHistoryIndex -= 1;
                WebFileChooserPanel.this.updateShownFolder((File)WebFileChooserPanel.this.navigationHistory.get(WebFileChooserPanel.this.currentHistoryIndex), true, true, true, false);
            }
        });
        this.forward = new WebButton(FORWARD_ICON);
        this.forward.setLanguage("weblaf.filechooser.forward", new Object[0]);
        this.forward.addHotkey(this, Hotkey.ALT_RIGHT).setHotkeyDisplayWay(TooltipWay.trailing);
        this.forward.setRolloverDecoratedOnly(true);
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.currentHistoryIndex += 1;
                WebFileChooserPanel.this.updateShownFolder((File)WebFileChooserPanel.this.navigationHistory.get(WebFileChooserPanel.this.currentHistoryIndex), true, true, true, false);
            }
        });
        this.folderUp = new WebButton(FOLDER_UP_ICON);
        this.folderUp.setLanguage("weblaf.filechooser.folderup", new Object[0]);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.setRolloverDecoratedOnly(true);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebFileChooserPanel.this.currentFolder != null) {
                    WebFileChooserPanel.this.updateShownFolder(WebFileChooserPanel.this.currentFolder.getParentFile(), true, true, true);
                }
            }
        });
        this.folderHome = new WebButton(FOLDER_HOME_ICON);
        this.folderHome.setLanguage("weblaf.filechooser.home", new Object[0]);
        this.folderHome.addHotkey(this, Hotkey.ALT_HOME).setHotkeyDisplayWay(TooltipWay.down);
        this.folderHome.setRolloverDecoratedOnly(true);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.updateShownFolder(FileUtils.getUserHome(), true, true, true);
            }
        });
        this.refresh = new WebButton(REFRESH_ICON);
        this.refresh.setLanguage("weblaf.filechooser.refresh", new Object[0]);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.down);
        this.refresh.setRolloverDecoratedOnly(true);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.updateCurrentFolderView();
            }
        });
        this.folderNew = new WebButton(FOLDER_NEW_ICON);
        this.folderNew.setLanguage("weblaf.filechooser.newfolder", new Object[0]);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.setRolloverDecoratedOnly(true);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebFileChooserPanel.this.currentFolder != null) {
                    String string = LanguageManager.get("weblaf.filechooser.newfolder.name");
                    String string2 = FileUtils.getAvailableName(WebFileChooserPanel.this.currentFolder, string);
                    File file = new File(WebFileChooserPanel.this.currentFolder, string2);
                    if (file.mkdir()) {
                        WebFileChooserPanel.this.fileList.getFileListModel().addElement(new FileElement(file));
                        WebFileChooserPanel.this.fileTree.addFile(WebFileChooserPanel.this.currentFolder, file);
                        WebFileChooserPanel.this.fileList.setSelectedValue(file, true);
                        WebFileChooserPanel.this.fileList.editSelectedCell();
                    } else {
                        String string3 = LanguageManager.get("weblaf.filechooser.newfolder.error.text");
                        String string4 = LanguageManager.get("weblaf.filechooser.newfolder.error.title");
                        WebOptionPane.showMessageDialog(WebFileChooserPanel.this, string3, string4, 0);
                    }
                }
            }
        });
        this.remove = new WebButton(REMOVE_ICON);
        this.remove.setLanguage("weblaf.filechooser.delete", new Object[0]);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.setRolloverDecoratedOnly(true);
        this.remove.setEnabled(false);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = WebFileChooserPanel.this.fileList.getSelectedValues();
                WebPanel webPanel = new WebPanel(new BorderLayout(0, 0));
                webPanel.add((Component)new WebLabel(LanguageManager.get("weblaf.filechooser.delete.confirm.text")), (Object)"North");
                WebPanel webPanel2 = new WebPanel(new VerticalFlowLayout(0, true, false));
                for (Object object : objectArray) {
                    File file = (File)object;
                    webPanel2.add((Component)new WebLabel(((File)object).getName(), (Icon)FileUtils.getFileIcon(file), 2));
                }
                WebScrollPane webScrollPane = new WebScrollPane(webPanel2){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        dimension.width += 13;
                        dimension.height = Math.min(dimension.height, 100);
                        return dimension;
                    }
                };
                webPanel.add((Component)webScrollPane, (Object)"Center");
                String string = LanguageManager.get("weblaf.filechooser.delete.confirm.title");
                int n = WebOptionPane.showConfirmDialog(WebFileChooserPanel.this, webPanel, string, 0, 3);
                if (n == 0) {
                    FileUtils.deleteFiles(objectArray);
                    WebFileChooserPanel.this.fileTree.removeFiles(FileUtils.toFilesList(objectArray));
                    WebFileChooserPanel.this.updateCurrentFolderView();
                }
            }
        });
        this.view = new WebButton(VIEW_ICON);
        this.view.setLanguage("weblaf.filechooser.view", new Object[0]);
        this.view.setRolloverDecoratedOnly(true);
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebPopupMenu webPopupMenu = new WebPopupMenu();
                WebRadioButtonMenuItem webRadioButtonMenuItem = new WebRadioButtonMenuItem(VIEW_ICONS_ICON);
                webRadioButtonMenuItem.setLanguage("weblaf.filechooser.view.icons", new Object[0]);
                webRadioButtonMenuItem.setSelected(WebFileChooserPanel.this.getFileViewType().equals((Object)FileViewType.icons));
                webRadioButtonMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebFileChooserPanel.this.setFileViewType(FileViewType.icons);
                    }
                });
                webPopupMenu.add(webRadioButtonMenuItem);
                WebRadioButtonMenuItem webRadioButtonMenuItem2 = new WebRadioButtonMenuItem(VIEW_TILES_ICON);
                webRadioButtonMenuItem2.setLanguage("weblaf.filechooser.view.tiles", new Object[0]);
                webRadioButtonMenuItem2.setSelected(WebFileChooserPanel.this.getFileViewType().equals((Object)FileViewType.tiles));
                webRadioButtonMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebFileChooserPanel.this.setFileViewType(FileViewType.tiles);
                    }
                });
                webPopupMenu.add(webRadioButtonMenuItem2);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(webRadioButtonMenuItem);
                buttonGroup.add(webRadioButtonMenuItem2);
                if (WebFileChooserPanel.this.view.getComponentOrientation().isLeftToRight()) {
                    webPopupMenu.show(WebFileChooserPanel.this.view, WebFileChooserPanel.this.view.getWidth() - webPopupMenu.getPreferredSize().width, WebFileChooserPanel.this.view.getHeight());
                } else {
                    webPopupMenu.show(WebFileChooserPanel.this.view, 0, WebFileChooserPanel.this.view.getHeight());
                }
            }
        });
        webToolBar.add((Component)this.backward);
        webToolBar.add((Component)this.forward);
        webToolBar.addFill(this.pathField);
        webToolBar.addToEnd(this.folderUp);
        webToolBar.addToEnd(this.folderHome);
        webToolBar.addToEnd(this.refresh);
        webToolBar.addSeparatorToEnd();
        webToolBar.addToEnd(this.folderNew);
        webToolBar.addToEnd(this.remove);
        webToolBar.addSeparatorToEnd();
        webToolBar.addToEnd(this.view);
        this.fileTree = new WebFileTree();
        this.fileTree.setAutoExpandSelectedNode(false);
        this.fileTree.setFileFilter(new GroupedFileFilter(GroupType.AND, GlobalConstants.DIRECTORIES_FILTER, this.previewFilter));
        WebScrollPane webScrollPane = new WebScrollPane(this.fileTree, false);
        webScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, StyleConstants.darkBorderColor));
        webScrollPane.setPreferredSize(new Dimension(160, 1));
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (WebFileChooserPanel.this.fileTree.getSelectionCount() > 0) {
                    TreePath treePath = WebFileChooserPanel.this.fileTree.getSelectionPath();
                    Rectangle rectangle = WebFileChooserPanel.this.fileTree.getPathBounds(treePath);
                    if (rectangle != null) {
                        WebFileChooserPanel.this.fileTree.scrollRectToVisible(rectangle);
                    }
                    WebFileChooserPanel.this.updateShownFolder(((FileTreeNode)treePath.getLastPathComponent()).getFile(), true, true, false);
                }
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        this.fileList = new WebFileList();
        this.fileList.setFileFilter(this.previewFilter);
        this.fileList.setFileViewType(this.fileViewType);
        this.fileList.setGenerateThumbnails(true);
        this.fileList.setDropMode(DropMode.ON);
        this.fileList.setEditable(true);
        this.fileList.setTransferHandler(new FileDropHandler(){

            @Override
            protected boolean filesImported(List<File> list) {
                if (list.size() > 0) {
                    File file = list.get(0);
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateShownFolder(file, true, true, true);
                    } else {
                        WebFileChooserPanel.this.updateShownFolder(file.getParentFile(), true, true, true);
                        WebFileChooserPanel.this.fileList.setSelectedValue(file, true);
                    }
                    return true;
                }
                return false;
            }
        });
        this.fileList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openFolder");
        this.fileList.getActionMap().put("openFolder", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return WebFileChooserPanel.this.fileList.getSelectedIndex() != -1;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.updateShownFolder(((FileElement)WebFileChooserPanel.this.fileList.getSelectedValue()).getFile(), true, true, true);
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() % 2 == 0 && WebFileChooserPanel.this.fileList.getSelectedIndex() != -1) {
                    File file = ((FileElement)WebFileChooserPanel.this.fileList.getSelectedValue()).getFile();
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateShownFolder(file, true, true, true);
                    } else if (WebFileChooserPanel.this.getSelectedFiles().size() > 0) {
                        WebFileChooserPanel.this.selectFiles(new ActionEvent(mouseEvent, mouseEvent.getID(), "select files"));
                    }
                }
            }
        });
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WebFileChooserPanel.this.remove.setEnabled(WebFileChooserPanel.this.currentFolder != null && WebFileChooserPanel.this.fileList.getSelectedIndex() != -1 && !WebFileChooserPanel.this.currentFolder.equals(nonexisting));
            }
        });
        this.fileList.addListEditListener(new ListEditAdapter(){

            @Override
            public void editFinished(int n, Object object, Object object2) {
                WebFileChooserPanel.this.fileTree.removeFile((File)object);
                WebFileChooserPanel.this.fileTree.addFile(((File)object2).getParentFile(), (File)object2);
                WebFileChooserPanel.this.updateChosenFiles();
            }
        });
        this.updateShownFolder(null, true, true, true, true);
        WebScrollPane webScrollPane2 = new WebScrollPane(this.fileList, false);
        webScrollPane2.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, StyleConstants.darkBorderColor));
        webScrollPane2.setHorizontalScrollBarPolicy(31);
        webScrollPane2.setVerticalScrollBarPolicy(22);
        Dimension dimension = this.fileList.getCellBounds(0, 0).getSize();
        Insets insets = webScrollPane2.getInsets();
        webScrollPane2.setPreferredSize(new Dimension(dimension.width * (this.fileViewType.equals((Object)FileViewType.tiles) ? 3 : 8) + insets.left + insets.right + 13 + 1, dimension.height * 6 + insets.top + insets.bottom + 1));
        WebSplitPane webSplitPane = new WebSplitPane(1);
        webSplitPane.setOneTouchExpandable(true);
        webSplitPane.setLeftComponent(webScrollPane);
        webSplitPane.setRightComponent(webScrollPane2);
        webSplitPane.setDividerLocation(160);
        webSplitPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, StyleConstants.darkBorderColor));
        this.add((Component)webSplitPane, (Object)"Center");
        WebPanel webPanel = new WebPanel();
        webPanel.setLayout(new ToolbarLayout(4));
        webPanel.setOpaque(false);
        webPanel.setMargin(4, 4, 4, 4);
        this.add((Component)webPanel, (Object)"South");
        WebLabel webLabel = new WebLabel();
        webLabel.setLanguage("weblaf.filechooser.files.selected", new Object[0]);
        webLabel.setDrawShade(true);
        webLabel.setMargin(0, 4, 0, 0);
        webPanel.add((Component)webLabel);
        this.selectedFiles = new WebFileChooserField(false);
        this.selectedFiles.setShowRemoveButton(false);
        this.selectedFiles.setShowFileShortName(true);
        this.selectedFiles.setFilesDropEnabled(false);
        webPanel.add((Component)this.selectedFiles, (Object)"FILL");
        this.fileFilters = new WebComboBox(this.availableFilters.toArray());
        this.fileFilters.setSelectedIndex(0);
        this.fileFilters.setRenderer(new WebComboBoxCellRenderer(this.fileFilters){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultFileFilter defaultFileFilter = (DefaultFileFilter)object;
                WebLabel webLabel = (WebLabel)super.getListCellRendererComponent(jList, (Object)"", n, bl, bl2);
                webLabel.setIcon(defaultFileFilter.getIcon());
                webLabel.setText(defaultFileFilter.getDescription());
                return webLabel;
            }
        });
        this.fileFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.updateChooserFilters();
                WebFileChooserPanel.this.fileFilters.revalidate();
                ((JComponent)WebFileChooserPanel.this.fileFilters.getParent()).revalidate();
            }
        });
        this.ok = new WebButton("", OK_ICON);
        this.ok.setLanguage("weblaf.filechooser.choose", new Object[0]);
        this.ok.addHotkey(this, Hotkey.CTRL_ENTER).setHotkeyDisplayWay(TooltipWay.up);
        if (StyleConstants.highlightControlButtons) {
            this.ok.setShineColor(StyleConstants.greenHighlight);
        }
        this.ok.putClientProperty("fill.component.cell", true);
        this.ok.setEnabled(false);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooserPanel.this.selectFiles(actionEvent);
            }
        });
        this.cancel = new WebButton("", CANCEL_ICON);
        this.cancel.setLanguage("weblaf.filechooser.cancel", new Object[0]);
        this.cancel.addHotkey(this, Hotkey.ESCAPE).setHotkeyDisplayWay(TooltipWay.up);
        if (StyleConstants.highlightControlButtons) {
            this.cancel.setShineColor(StyleConstants.redHighlight);
        }
        this.cancel.putClientProperty("fill.component.cell", true);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebFileChooserPanel.this.cancelListener != null) {
                    WebFileChooserPanel.this.cancelListener.actionPerformed(actionEvent);
                }
            }
        });
        webPanel.add((Component)(bl ? new GroupPanel(4, this.fileFilters, this.ok, this.cancel) : this.fileFilters), (Object)"END");
        SwingUtils.equalizeComponentsSize(this.ok, this.cancel);
        this.setSelectionMode(this.selectionMode);
        this.updateChosenFiles();
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WebFileChooserPanel.this.updateChosenFiles();
            }
        });
    }

    public boolean allowHotkeys() {
        return !this.fileTree.isEditing() && !this.pathField.isEditing();
    }

    private void selectFiles(ActionEvent actionEvent) {
        if (this.okListener != null) {
            this.okListener.actionPerformed(actionEvent);
        }
    }

    public void setCurrentDirectory(String string) {
        this.setCurrentDirectory(string != null ? new File(string) : null);
    }

    public void setCurrentDirectory(File file) {
        this.updateShownFolder(file, true, true, true, true);
    }

    public File getCurrentDirectory() {
        return this.currentFolder;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.selectedFiles.setSelectionMode(selectionMode);
        this.fileList.setSelectionMode(selectionMode.equals((Object)SelectionMode.SINGLE_SELECTION) ? 0 : 2);
    }

    private void updateChooserFilters() {
        DefaultFileFilter defaultFileFilter = (DefaultFileFilter)this.fileFilters.getSelectedItem();
        this.setPreviewFilter(defaultFileFilter);
        this.setChooseFilter(this.getActualChooseFilter(defaultFileFilter));
    }

    private DefaultFileFilter getActualChooseFilter(DefaultFileFilter defaultFileFilter) {
        if (this.filesToChoose.equals((Object)FilesToChoose.filesOnly)) {
            return new GroupedFileFilter(GroupType.AND, GlobalConstants.FILES_FILTER, defaultFileFilter);
        }
        if (this.filesToChoose.equals((Object)FilesToChoose.foldersOnly)) {
            return new GroupedFileFilter(GroupType.AND, GlobalConstants.DIRECTORIES_FILTER, defaultFileFilter);
        }
        return defaultFileFilter;
    }

    private void updateChosenFiles() {
        if (this.fileList.getSelectedIndex() != -1) {
            List<File> list = this.getSelectedFiles();
            this.selectedFiles.setSelectedFiles(list);
            this.ok.setEnabled(list.size() > 0);
            this.fireFileSelectionChanged(list);
        } else {
            this.selectedFiles.setSelectedFile(null);
            this.ok.setEnabled(false);
            this.fireFileSelectionChanged(new ArrayList<File>());
        }
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object object : this.fileList.getSelectedValues()) {
            File file = (File)object;
            if (!this.chooseFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public List<DefaultFileFilter> getAvailableFilters() {
        return this.availableFilters;
    }

    public void setAvailableFilters(List<DefaultFileFilter> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.availableFilters = list;
        DefaultFileFilter defaultFileFilter = (DefaultFileFilter)this.fileFilters.getSelectedItem();
        this.fileFilters.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (this.fileFilters.isShowing()) {
            this.fileFilters.updateUI();
        }
        if (defaultFileFilter == null || !this.availableFilters.contains(defaultFileFilter)) {
            this.fileFilters.setSelectedIndex(0);
        } else {
            this.fileFilters.setSelectedItem(defaultFileFilter);
        }
    }

    public FilesToChoose getFilesToChoose() {
        return this.filesToChoose;
    }

    public void setFilesToChoose(FilesToChoose filesToChoose) {
        this.filesToChoose = filesToChoose;
        this.updateChooserFilters();
    }

    public ActionListener getOkListener() {
        return this.okListener;
    }

    public void setOkListener(ActionListener actionListener) {
        this.okListener = actionListener;
    }

    public ActionListener getCancelListener() {
        return this.cancelListener;
    }

    public void setCancelListener(ActionListener actionListener) {
        this.cancelListener = actionListener;
    }

    public DefaultFileFilter getPreviewFilter() {
        return this.previewFilter;
    }

    public void setPreviewFilter(DefaultFileFilter defaultFileFilter) {
        this.previewFilter = defaultFileFilter;
        this.updateCurrentFolderView();
    }

    public DefaultFileFilter getChooseFilter() {
        return this.chooseFilter;
    }

    public void setChooseFilter(DefaultFileFilter defaultFileFilter) {
        this.chooseFilter = defaultFileFilter;
        this.updateChosenFiles();
    }

    private void updateCurrentFolderView() {
        this.updateShownFolder(this.currentFolder, true, true, false);
    }

    private void updateShownFolder(File file, boolean bl, boolean bl2, boolean bl3) {
        this.updateShownFolder(file, bl, bl2, bl3, true);
    }

    private void updateShownFolder(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (file == null || file.isDirectory()) {
            if (file == null && !SystemUtils.isWindows()) {
                file = FileUtils.getDiskRoots()[0];
            }
            boolean bl5 = false;
            if (bl4 && !this.isSameFolder(file)) {
                if (this.currentHistoryIndex > -1) {
                    while (this.currentHistoryIndex + 1 < this.navigationHistory.size()) {
                        this.navigationHistory.remove(this.currentHistoryIndex + 1);
                    }
                }
                this.navigationHistory.add(file);
                this.currentHistoryIndex = this.navigationHistory.size() - 1;
                bl5 = true;
            }
            this.backward.setEnabled(this.currentHistoryIndex > 0);
            this.forward.setEnabled(this.currentHistoryIndex + 1 < this.navigationHistory.size());
            if (bl) {
                this.updatePath(file);
            }
            if (bl3) {
                this.updateTree(file);
            }
            if (bl2) {
                this.updateList(file);
            }
            this.currentFolder = file;
            this.folderNew.setEnabled(this.currentFolder != null);
            this.folderUp.setEnabled(SystemUtils.isWindows() ? this.currentFolder != null : this.currentFolder != null && this.currentFolder.getParentFile() != null);
            if (bl5) {
                this.fireDirectoryChanged(this.currentFolder);
            }
        }
    }

    private void updatePath(File file) {
        this.pathField.setSelectedPath(file);
    }

    private void updateTree(File file) {
        this.fileTree.removeTreeSelectionListener(this.fileTreeListener);
        this.fileTree.setSelectedFile(file);
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
    }

    private void updateList(File file) {
        this.fileList.setDisplayedDirectory(file);
    }

    private boolean isSameFolder(File file) {
        return FileUtils.equals(this.currentFolder, file);
    }

    public FileViewType getFileViewType() {
        return this.fileViewType;
    }

    public void setFileViewType(FileViewType fileViewType) {
        this.fileViewType = fileViewType;
        this.fileList.setFileViewType(fileViewType);
        this.updateList(this.currentFolder);
    }

    public boolean isGenerateImagePreviews() {
        return this.fileList.isGenerateThumbnails();
    }

    public void setGenerateImagePreviews(boolean bl) {
        this.fileList.setGenerateThumbnails(bl);
    }

    public WebFileTree getFileTree() {
        return this.fileTree;
    }

    public WebFileList getFileList() {
        return this.fileList;
    }

    public WebPathField getPathField() {
        return this.pathField;
    }

    public void addFileChooserListener(FileChooserListener fileChooserListener) {
        this.chooserListeners.add(fileChooserListener);
    }

    public void removeFileChooserListener(FileChooserListener fileChooserListener) {
        this.chooserListeners.remove(fileChooserListener);
    }

    private void fireDirectoryChanged(File file) {
        for (FileChooserListener fileChooserListener : CollectionUtils.copy(this.chooserListeners)) {
            fileChooserListener.directoryChanged(file);
        }
    }

    private void fireFileSelectionChanged(List<File> list) {
        for (FileChooserListener fileChooserListener : CollectionUtils.copy(this.chooserListeners)) {
            fileChooserListener.selectionChanged(list);
        }
    }
}

