/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.image.DisplayType;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebImage
extends JComponent
implements SwingConstants {
    private BufferedImage image;
    private BufferedImage disabledImage;
    private DisplayType displayType;
    private int horizontalAlignment;
    private int verticalAlignment;
    private float transparency;
    private Insets margin;
    private Dimension lastDimention = null;
    private BufferedImage lastPreviewImage = null;

    public WebImage() {
        this((Image)null);
    }

    public WebImage(String string) {
        this(ImageUtils.loadImage(string));
    }

    public WebImage(Class clazz, String string) {
        this(ImageUtils.loadImage(clazz, string));
    }

    public WebImage(URL uRL) {
        this(ImageUtils.loadImage(uRL));
    }

    public WebImage(Icon icon) {
        this(ImageUtils.getBufferedImage(icon));
    }

    public WebImage(ImageIcon imageIcon) {
        this(imageIcon.getImage());
    }

    public WebImage(Image image) {
        this(ImageUtils.getBufferedImage(image));
    }

    public WebImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.disabledImage = null;
        this.displayType = DisplayType.preferred;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.transparency = 1.0f;
        SwingUtils.setOrientation(this);
        this.setOpaque(false);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!WebImage.this.isEnabled()) {
                    WebImage.this.disabledImage = ImageUtils.createDisabledCopy(WebImage.this.image);
                    WebImage.this.lastPreviewImage = null;
                    WebImage.this.repaint();
                } else if (WebImage.this.disabledImage != null) {
                    WebImage.this.disabledImage.flush();
                    WebImage.this.disabledImage = null;
                    WebImage.this.lastPreviewImage = null;
                    WebImage.this.repaint();
                }
            }
        });
    }

    public int getImageWidth() {
        return this.image != null ? this.image.getWidth() : -1;
    }

    public int getImageHeight() {
        return this.image != null ? this.image.getHeight() : -1;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setIcon(Icon icon) {
        this.setImage(ImageUtils.getBufferedImage(icon));
    }

    public void setIcon(ImageIcon imageIcon) {
        this.setImage(imageIcon.getImage());
    }

    public void setImage(Image image) {
        this.setImage(ImageUtils.getBufferedImage(image));
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.revalidate();
        this.repaint();
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        this.updateView();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        this.updateView();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
        this.updateView();
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float f) {
        this.transparency = f;
        this.updateView();
    }

    private void updateView() {
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    private void updateBorder() {
        if (this.margin != null) {
            this.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
        } else {
            this.setBorder(null);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.transparency <= 0.0f) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, this.transparency, this.transparency < 1.0f);
        BufferedImage bufferedImage = this.getCurrentImage();
        if (bufferedImage != null) {
            Insets insets = this.getInsets();
            if (this.getSize().equals(this.getRequiredSize())) {
                graphics2D.drawImage((Image)bufferedImage, insets.left, insets.top, null);
            } else {
                switch (this.displayType) {
                    case preferred: {
                        int n;
                        int n2 = this.horizontalAlignment == 2 ? insets.left : (n = this.horizontalAlignment == 4 ? this.getWidth() - bufferedImage.getWidth() - insets.right : this.getCenterX(insets) - bufferedImage.getWidth() / 2);
                        int n3 = this.verticalAlignment == 1 ? insets.top : (this.verticalAlignment == 3 ? this.getHeight() - bufferedImage.getHeight() - insets.bottom : this.getCenterY(insets) - bufferedImage.getHeight() / 2);
                        graphics2D.drawImage((Image)bufferedImage, n, n3, null);
                        break;
                    }
                    case fitComponent: {
                        BufferedImage bufferedImage2 = this.getPreviewImage(insets);
                        graphics2D.drawImage((Image)bufferedImage2, this.getCenterX(insets) - bufferedImage2.getWidth() / 2, this.getCenterY(insets) - bufferedImage2.getHeight() / 2, null);
                        break;
                    }
                    case repeat: {
                        int n;
                        int n4 = this.horizontalAlignment == 2 ? insets.left : (n = this.horizontalAlignment == 4 ? this.getWidth() - bufferedImage.getWidth() - insets.right : this.getCenterX(insets) - bufferedImage.getWidth() / 2);
                        int n5 = this.verticalAlignment == 1 ? insets.top : (this.verticalAlignment == 3 ? this.getHeight() - bufferedImage.getHeight() - insets.bottom : this.getCenterY(insets) - bufferedImage.getHeight() / 2);
                        graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Double(n, n5, bufferedImage.getWidth(), bufferedImage.getHeight())));
                        graphics2D.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                        break;
                    }
                }
            }
        }
        LafUtils.restoreComposite(graphics2D, composite, this.transparency < 1.0f);
    }

    private int getCenterX(Insets insets) {
        return insets.left + (this.getWidth() - insets.left - insets.right) / 2;
    }

    private int getCenterY(Insets insets) {
        return insets.top + (this.getHeight() - insets.top - insets.bottom) / 2;
    }

    private BufferedImage getPreviewImage(Insets insets) {
        if (this.image.getWidth() > this.getWidth() || this.image.getHeight() > this.getHeight()) {
            Dimension dimension = this.getSize();
            dimension.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            if (this.lastPreviewImage == null || this.lastDimention != null && !this.lastDimention.equals(dimension)) {
                if (this.lastPreviewImage != null) {
                    this.lastPreviewImage.flush();
                    this.lastPreviewImage = null;
                }
                this.lastPreviewImage = ImageUtils.createPreviewImage(this.getCurrentImage(), dimension);
                this.lastDimention = this.getSize();
            }
            return this.lastPreviewImage;
        }
        return this.image;
    }

    private BufferedImage getCurrentImage() {
        return !this.isEnabled() && this.disabledImage != null ? this.disabledImage : this.image;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.getRequiredSize();
    }

    private Dimension getRequiredSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + (this.image != null ? this.image.getWidth() : 0) + insets.right, insets.top + (this.image != null ? this.image.getHeight() : 0) + insets.bottom);
    }
}

