/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.label.WebLabelStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class WebMultiLineLabelUI
extends BasicLabelUI
implements ComponentListener {
    public static final String PROPERTY_KEY = "WrappedText";
    protected static Rectangle paintIconR = new Rectangle();
    protected static Rectangle paintTextR = new Rectangle();
    protected static Rectangle paintViewR = new Rectangle();
    protected static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static int defaultSize = 4;
    private FontMetrics metrics;
    private boolean drawShade = WebLabelStyle.drawShade;
    private Color shadeColor = WebLabelStyle.shadeColor;

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebMultiLineLabelUI();
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        super.uninstallDefaults(jLabel);
        this.clearCache(jLabel);
    }

    @Override
    protected void installListeners(JLabel jLabel) {
        super.installListeners(jLabel);
        jLabel.addComponentListener(this);
    }

    @Override
    protected void uninstallListeners(JLabel jLabel) {
        super.uninstallListeners(jLabel);
        jLabel.removeComponentListener(this);
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean bl) {
        this.drawShade = bl;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color color) {
        this.shadeColor = color;
    }

    protected void clearCache(JLabel jLabel) {
        jLabel.putClientProperty(PROPERTY_KEY, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("text") || "font".equals(string)) {
            this.clearCache((JLabel)propertyChangeEvent.getSource());
        }
    }

    protected void updateLayout(JLabel jLabel, FontMetrics fontMetrics, int n, int n2) {
        if (fontMetrics == null) {
            fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        }
        this.metrics = fontMetrics;
        String string = jLabel.getText();
        Icon icon = jLabel.getIcon();
        Insets insets = jLabel.getInsets(paintViewInsets);
        WebMultiLineLabelUI.paintViewR.x = insets.left;
        WebMultiLineLabelUI.paintViewR.y = insets.top;
        WebMultiLineLabelUI.paintViewR.width = n - (insets.left + insets.right);
        WebMultiLineLabelUI.paintViewR.height = n2 - (insets.top + insets.bottom);
        WebMultiLineLabelUI.paintIconR.height = 0;
        WebMultiLineLabelUI.paintIconR.width = 0;
        WebMultiLineLabelUI.paintIconR.y = 0;
        WebMultiLineLabelUI.paintIconR.x = 0;
        WebMultiLineLabelUI.paintTextR.height = 0;
        WebMultiLineLabelUI.paintTextR.width = 0;
        WebMultiLineLabelUI.paintTextR.y = 0;
        WebMultiLineLabelUI.paintTextR.x = 0;
        this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent);
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.updateLayout(jLabel, fontMetrics, jComponent.getWidth(), jComponent.getHeight());
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, WebMultiLineLabelUI.paintIconR.x, WebMultiLineLabelUI.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                this.paintTextLines(graphics, jLabel, fontMetrics);
            }
        }
        SwingUtils.restoreTextAntialias(graphics, map);
    }

    protected void paintTextLines(Graphics graphics, JLabel jLabel, FontMetrics fontMetrics) {
        int n;
        List<String> list = this.getTextLines(jLabel);
        int n2 = this.getAvailableHeight(jLabel);
        for (n = list.size() * fontMetrics.getHeight(); n > n2; n -= fontMetrics.getHeight()) {
        }
        WebMultiLineLabelUI.paintTextR.height = Math.min(n, n2);
        WebMultiLineLabelUI.paintTextR.y = this.alignmentY(jLabel, fontMetrics, paintTextR);
        int n3 = WebMultiLineLabelUI.paintTextR.x;
        int n4 = WebMultiLineLabelUI.paintTextR.y;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && paintTextR.contains(n3, n4 + WebMultiLineLabelUI.getAscent(fontMetrics))) {
            String string = iterator.next().trim();
            if (iterator.hasNext() && !paintTextR.contains(n3, n4 + fontMetrics.getHeight() + WebMultiLineLabelUI.getAscent(fontMetrics))) {
                string = this.clip(string, fontMetrics, paintTextR);
            }
            int n5 = this.alignmentX(jLabel, fontMetrics, string, paintTextR);
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string, n5, n4);
            } else {
                this.paintDisabledText(jLabel, graphics, string, n5, n4);
            }
            n4 += fontMetrics.getHeight();
        }
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        if (this.drawShade) {
            graphics.setColor(jLabel.getForeground());
            this.paintShadowText(graphics, string, n, n2);
        } else {
            int n3 = jLabel.getDisplayedMnemonicIndex();
            graphics.setColor(jLabel.getForeground());
            SwingUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
        }
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        if (this.drawShade) {
            graphics.setColor(jLabel.getBackground().darker());
            this.paintShadowText(graphics, string, n, n2);
        } else {
            int n3 = jLabel.getDisplayedMnemonicIndex();
            graphics.setColor(jLabel.getForeground());
            SwingUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
        }
    }

    private void paintShadowText(Graphics graphics, String string, int n, int n2) {
        graphics.translate(n, n2);
        LafUtils.paintTextShadow((Graphics2D)graphics, string, this.shadeColor);
        graphics.translate(-n, -n2);
    }

    protected int getAvailableHeight(JLabel jLabel) {
        jLabel.getInsets(paintViewInsets);
        return jLabel.getHeight() - WebMultiLineLabelUI.paintViewInsets.top - WebMultiLineLabelUI.paintViewInsets.bottom;
    }

    protected String clip(String string, FontMetrics fontMetrics, Rectangle rectangle) {
        if (string.length() < 3) {
            return "...";
        }
        return string.substring(0, string.length() - 3) + "...";
    }

    protected int alignmentY(JLabel jLabel, FontMetrics fontMetrics, Rectangle rectangle) {
        int n = this.getAvailableHeight(jLabel);
        int n2 = rectangle.height;
        int n3 = jLabel.getVerticalAlignment();
        switch (n3) {
            case 1: {
                return WebMultiLineLabelUI.getAscent(fontMetrics) + WebMultiLineLabelUI.paintViewInsets.top;
            }
            case 3: {
                return WebMultiLineLabelUI.getAscent(fontMetrics) + n - WebMultiLineLabelUI.paintViewInsets.top + WebMultiLineLabelUI.paintViewInsets.bottom - n2;
            }
        }
        int n4 = WebMultiLineLabelUI.paintViewInsets.top + (n - n2) / 2 + WebMultiLineLabelUI.getAscent(fontMetrics);
        return Math.max(n4, WebMultiLineLabelUI.getAscent(fontMetrics) + WebMultiLineLabelUI.paintViewInsets.top);
    }

    private static int getAscent(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    protected int alignmentX(JLabel jLabel, FontMetrics fontMetrics, String string, Rectangle rectangle) {
        boolean bl = jLabel.getComponentOrientation().isLeftToRight();
        int n = jLabel.getHorizontalAlignment();
        if (n == 4 || n == 11 && bl || n == 10 && !bl) {
            return WebMultiLineLabelUI.paintViewR.width - fontMetrics.stringWidth(string);
        }
        if (n == 0) {
            return WebMultiLineLabelUI.paintViewR.width / 2 - fontMetrics.stringWidth(string) / 2;
        }
        return WebMultiLineLabelUI.paintViewR.x;
    }

    private static boolean isHTMLString(String string) {
        if (string != null && string.length() >= 6 && string.charAt(0) == '<' && string.charAt(5) == '>') {
            String string2 = string.substring(1, 5);
            return string2.equalsIgnoreCase("html");
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        JLabel jLabel = (JLabel)jComponent;
        if (WebMultiLineLabelUI.isHTMLString(jLabel.getText())) {
            return dimension;
        }
        if (jComponent.getParent() != null) {
            Insets insets = jComponent.getParent().getInsets();
            Dimension dimension2 = jComponent.getParent().getSize();
            if (dimension2.width > 0) {
                dimension.width = dimension2.width - insets.left - insets.right;
            }
        }
        this.updateLayout(jLabel, null, dimension.width, dimension.height);
        dimension.height = Math.max(dimension.height, this.getPreferredHeight(jLabel));
        return dimension;
    }

    protected int getPreferredHeight(JLabel jLabel) {
        int n = this.getTextLines(jLabel).size();
        Insets insets = jLabel.getInsets(paintViewInsets);
        return n * this.metrics.getHeight() + insets.top + insets.bottom;
    }

    protected List<String> getTextLines(JLabel jLabel) {
        List<String> list = (List<String>)jLabel.getClientProperty(PROPERTY_KEY);
        if (list == null) {
            list = this.prepareLines(jLabel);
            jLabel.putClientProperty(PROPERTY_KEY, list);
        }
        return list;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.clearCache((JLabel)componentEvent.getSource());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    protected List<String> prepareLines(JLabel jLabel) {
        ArrayList<String> arrayList = new ArrayList<String>(defaultSize);
        String string = jLabel.getText();
        if (string == null) {
            return null;
        }
        PlainDocument plainDocument = new PlainDocument();
        try {
            plainDocument.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        Element element = plainDocument.getDefaultRootElement();
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            this.wrap(arrayList, element.getElement(i));
        }
        return arrayList;
    }

    protected void wrap(List<String> list, Element element) {
        int n = element.getEndOffset();
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        while (n2 < n) {
            int n3 = this.calculateBreakPosition(document, n2, n);
            try {
                list.add(document.getText(n2, n3 - n2));
            }
            catch (BadLocationException badLocationException) {
                throw new Error("Can't get line text. p0=" + n2 + " p=" + n3);
            }
            n2 = n3 == n2 ? n : n3;
        }
    }

    protected int calculateBreakPosition(Document document, int n, int n2) {
        Segment segment = SegmentCache.getSegment();
        try {
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("Can't get line text");
        }
        int n3 = WebMultiLineLabelUI.paintTextR.width;
        int n4 = n + Utilities.getBreakLocation(segment, this.metrics, 0, n3, null, n);
        SegmentCache.releaseSegment(segment);
        return n4;
    }

    protected static final class SegmentCache {
        private ArrayList<Segment> segments = new ArrayList(2);
        private static SegmentCache cache = new SegmentCache();

        private SegmentCache() {
        }

        public static Segment getSegment() {
            int n = SegmentCache.cache.segments.size();
            if (n > 0) {
                return SegmentCache.cache.segments.remove(n - 1);
            }
            return new Segment();
        }

        public static void releaseSegment(Segment segment) {
            segment.array = null;
            segment.count = 0;
            SegmentCache.cache.segments.add(segment);
        }
    }
}

