/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentPanelLayout
implements LayoutManager {
    private List<Component> components = new ArrayList<Component>();
    private Map<Component, Integer> yShift = new HashMap<Component, Integer>();

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponentShift(Component component, Integer n) {
        this.yShift.put(component, n);
    }

    public Integer getComponentShift(Component component) {
        return this.yShift.get(component);
    }

    public int indexOf(Component component) {
        return this.components.indexOf(component);
    }

    public Component getComponent(int n) {
        return this.components.get(n);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.components.add(component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.components.remove(component);
    }

    public void insertLayoutComponent(int n, Component component) {
        this.components.add(n, component);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.top;
        for (Component component : this.components) {
            Dimension dimension = component.getPreferredSize();
            Integer n2 = this.yShift.get(component);
            component.setBounds(insets.left, n2 == null ? n : n + n2, container.getWidth() - insets.left - insets.right, dimension.height);
            n += dimension.height;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        for (Component component : this.components) {
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, insets.left + dimension.width + insets.right);
            n2 += dimension.height;
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }
}

