/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.ComponentState;
import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class NinePatchStatePainter<E extends JComponent>
extends DefaultPainter<E> {
    private Map<String, NinePatchIcon> stateIcons;

    public NinePatchStatePainter() {
        this.stateIcons = new HashMap<String, NinePatchIcon>();
    }

    public NinePatchStatePainter(Map<String, NinePatchIcon> map) {
        this.stateIcons = map;
    }

    public Map<String, NinePatchIcon> getStateIcons() {
        return this.stateIcons;
    }

    public void setStateIcons(Map<String, NinePatchIcon> map) {
        this.stateIcons = map;
    }

    public void addStateIcon(String string, NinePatchIcon ninePatchIcon) {
        this.stateIcons.put(string, ninePatchIcon);
    }

    public void removeStateIcon(ComponentState componentState) {
        this.stateIcons.remove(componentState);
    }

    public boolean hasStateIcons() {
        return this.stateIcons != null && this.stateIcons.size() > 0;
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        if (this.hasStateIcons() && e != null) {
            NinePatchIcon ninePatchIcon;
            NinePatchIcon ninePatchIcon2 = e instanceof AbstractButton ? this.getButtonBackground((AbstractButton)e) : (e instanceof JToolBar ? this.getToolBarBackground((JToolBar)e) : this.getComponentBackground(e));
            if (ninePatchIcon2 != null) {
                ninePatchIcon2.setComponent((Component)e);
                ninePatchIcon2.paintIcon(graphics2D, rectangle);
            }
            if (this.isFocused(e) && (ninePatchIcon = this.getExactStateIcon(ComponentState.focused)) != null) {
                ninePatchIcon.setComponent((Component)e);
                ninePatchIcon.paintIcon(graphics2D, rectangle);
            }
        }
    }

    private boolean isFocused(E e) {
        return ((Component)e).isFocusOwner();
    }

    private NinePatchIcon getComponentBackground(E e) {
        return this.getStateIcon(((Component)e).isEnabled() ? ComponentState.normal : ComponentState.disabled);
    }

    private NinePatchIcon getButtonBackground(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed()) {
            return this.getStateIcon(buttonModel.isSelected() ? ComponentState.selectedPressed : ComponentState.pressed);
        }
        if (buttonModel.isSelected()) {
            if (buttonModel.isEnabled()) {
                return this.getStateIcon(buttonModel.isRollover() ? ComponentState.selectedRollover : ComponentState.selected);
            }
            return this.getStateIcon(ComponentState.selectedDisabled);
        }
        if (buttonModel.isEnabled()) {
            return this.getStateIcon(buttonModel.isRollover() ? ComponentState.rollover : ComponentState.normal);
        }
        return this.getStateIcon(ComponentState.disabled);
    }

    private NinePatchIcon getToolBarBackground(JToolBar jToolBar) {
        if (jToolBar instanceof WebToolBar && ((WebToolBar)jToolBar).isFloating()) {
            return this.getStateIcon(jToolBar.isEnabled() ? ComponentState.floating : ComponentState.floatingDisabled);
        }
        return this.getStateIcon(jToolBar.isEnabled() ? ComponentState.normal : ComponentState.disabled);
    }

    public NinePatchIcon getExactStateIcon(String string) {
        return this.stateIcons.get(string);
    }

    public NinePatchIcon getStateIcon(String string) {
        if (string.equals(ComponentState.normal)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : null;
        }
        if (string.equals(ComponentState.rollover)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.normal);
        }
        if (string.equals(ComponentState.disabled)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.normal);
        }
        if (string.equals(ComponentState.pressed)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.selected);
        }
        if (string.equals(ComponentState.selected)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.normal);
        }
        if (string.equals(ComponentState.selectedRollover)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.selected);
        }
        if (string.equals(ComponentState.selectedDisabled)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.selected);
        }
        if (string.equals(ComponentState.selectedPressed)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.pressed);
        }
        if (string.equals(ComponentState.focused)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : null;
        }
        if (string.equals(ComponentState.floating)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.normal);
        }
        if (string.equals(ComponentState.floatingDisabled)) {
            return this.stateIcons.containsKey(string) ? this.stateIcons.get(string) : this.getStateIcon(ComponentState.floating);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize(E e) {
        if (this.hasStateIcons()) {
            Dimension dimension = new Dimension(0, 0);
            for (NinePatchIcon ninePatchIcon : this.stateIcons.values()) {
                ninePatchIcon.setComponent((Component)e);
                dimension = SwingUtils.max(dimension, ninePatchIcon.getPreferredSize());
            }
            return dimension;
        }
        return super.getPreferredSize(e);
    }

    @Override
    public Insets getMargin(E e) {
        Insets insets = super.getMargin(e);
        if (this.hasStateIcons()) {
            Insets insets2 = new Insets(0, 0, 0, 0);
            for (NinePatchIcon ninePatchIcon : this.stateIcons.values()) {
                ninePatchIcon.setComponent((Component)e);
                insets2 = SwingUtils.max(insets2, ninePatchIcon.getMargin());
            }
            return SwingUtils.max(insets, insets2);
        }
        return insets;
    }
}

