/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.laf.StyleConstants;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultTransitionEffect
implements TransitionEffect {
    protected static final String DIRECTION = "DIRECTION";
    protected Map<String, Object> effectSettings = new HashMap<String, Object>();
    protected boolean animating = false;

    @Override
    public long getAnimationDelay() {
        return StyleConstants.avgAnimationDelay;
    }

    @Override
    public boolean isAnimating() {
        return this.animating;
    }

    public Direction getDirection() {
        return this.get(DIRECTION, Direction.random);
    }

    public void setDirection(Direction direction) {
        this.put(DIRECTION, (Object)direction);
    }

    protected Map<String, Object> getEffectSettings() {
        return this.effectSettings;
    }

    protected void setEffectSettings(Map<String, Object> map) {
        this.effectSettings = map;
    }

    protected void put(String string, Object object) {
        this.effectSettings.put(string, object);
    }

    protected void remove(String string) {
        this.effectSettings.remove(string);
    }

    protected void clearSettings() {
        this.effectSettings.clear();
    }

    protected <T> T get(String string, T t) {
        if (this.effectSettings.containsKey(string)) {
            return (T)this.effectSettings.get(string);
        }
        return t;
    }

    @Override
    public boolean performAnimationTick(ImageTransition imageTransition) {
        if (!this.animating) {
            this.animating = true;
            this.prepareAnimation(imageTransition);
            return false;
        }
        boolean bl = this.performAnimation(imageTransition);
        if (bl) {
            this.animating = false;
        }
        return bl;
    }

    public abstract void prepareAnimation(ImageTransition var1);

    public abstract boolean performAnimation(ImageTransition var1);
}

