/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.fade;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.utils.LafUtils;
import java.awt.Composite;
import java.awt.Graphics2D;

public class FadeTransitionEffect
extends DefaultTransitionEffect {
    private static final String FADE_MINIMUM_SPEED = "FADE_MINIMUM_SPEED";
    private static final String FADE_SPEED = "FADE_SPEED";
    private float minimumSpeed;
    private float speed;
    private float opacity;

    public float getMinimumSpeed() {
        return this.get(FADE_MINIMUM_SPEED, Float.valueOf(0.02f)).floatValue();
    }

    public void setMinimumSpeed(float f) {
        this.put(FADE_MINIMUM_SPEED, Float.valueOf(f));
    }

    public float getSpeed() {
        return this.get(FADE_SPEED, Float.valueOf(0.1f)).floatValue();
    }

    public void setSpeed(float f) {
        this.put(FADE_SPEED, Float.valueOf(f));
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.opacity = 0.0f;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        if (this.opacity < 1.0f) {
            this.opacity = Math.min(this.opacity + this.getCurrentSpeed(), 1.0f);
            imageTransition.repaint();
            return false;
        }
        return true;
    }

    private float getCurrentSpeed() {
        return Math.max(this.minimumSpeed, this.speed * (float)Math.sqrt((1.0f - this.opacity) / 1.0f));
    }

    @Override
    public void paint(Graphics2D graphics2D, ImageTransition imageTransition) {
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, 1.0f - this.opacity);
        graphics2D.drawImage(imageTransition.getCurrentImage(), 0, 0, imageTransition.getWidth(), imageTransition.getHeight(), null);
        LafUtils.restoreComposite(graphics2D, composite);
        LafUtils.setupAlphaComposite(graphics2D, this.opacity);
        graphics2D.drawImage(imageTransition.getOtherImage(), 0, 0, imageTransition.getWidth(), imageTransition.getHeight(), null);
        LafUtils.restoreComposite(graphics2D, composite);
    }
}

