/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.slide;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.slide.SlideType;
import com.alee.utils.LafUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;

public class SlideTransitionEffect
extends DefaultTransitionEffect {
    private static final String SLIDE_MINIMUM_SPEED = "SLIDE_MINIMUM_SPEED";
    private static final String SLIDE_SPEED = "SLIDE_SPEED";
    private static final String SLIDE_FADE = "SLIDE_FADE";
    private static final String SLIDE_TYPE = "SLIDE_TYPE";
    private int minimumSpeed;
    private int speed;
    private boolean fade;
    private SlideType type;
    private Direction direction;
    private int slideProgress;

    public int getMinimumSpeed() {
        return this.get(SLIDE_MINIMUM_SPEED, 1);
    }

    public void setMinimumSpeed(int n) {
        this.put(SLIDE_MINIMUM_SPEED, n);
    }

    public int getSpeed() {
        return this.get(SLIDE_SPEED, 20);
    }

    public void setSpeed(int n) {
        this.put(SLIDE_SPEED, n);
    }

    public boolean isFade() {
        return this.get(SLIDE_FADE, true);
    }

    public void setFade(boolean bl) {
        this.put(SLIDE_FADE, bl);
    }

    public SlideType getType() {
        return this.get(SLIDE_TYPE, SlideType.random);
    }

    public void setType(SlideType slideType) {
        this.put(SLIDE_TYPE, (Object)slideType);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.fade = this.isFade();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.slideProgress = 0;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        int n = this.direction.equals((Object)Direction.left) || this.direction.equals((Object)Direction.right) ? imageTransition.getWidth() : imageTransition.getHeight();
        int n2 = Math.max(this.minimumSpeed, Math.round((float)this.speed * (float)Math.sqrt((float)Math.abs(this.type.equals((Object)SlideType.moveOld) ? this.slideProgress : n - this.slideProgress) / (float)n)));
        this.slideProgress = Math.min(this.slideProgress + n2, n);
        if (this.slideProgress < n) {
            imageTransition.repaint();
            return false;
        }
        this.type = null;
        return true;
    }

    @Override
    public void paint(Graphics2D graphics2D, ImageTransition imageTransition) {
        int n = imageTransition.getWidth();
        int n2 = imageTransition.getHeight();
        float f = (float)this.slideProgress / (float)(this.direction.isHorizontal() ? n : n2);
        if (this.type.equals((Object)SlideType.moveNew)) {
            Point point = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                point.x = n - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                point.x = -n + this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                point.y = n2 - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                point.y = -n2 + this.slideProgress;
            }
            graphics2D.drawImage(imageTransition.getCurrentImage(), 0, 0, n, n2, null);
            Composite composite = LafUtils.setupAlphaComposite(graphics2D, f, this.fade);
            graphics2D.drawImage(imageTransition.getOtherImage(), point.x, point.y, n, n2, null);
            LafUtils.restoreComposite(graphics2D, composite, this.fade);
        } else if (this.type.equals((Object)SlideType.moveOld)) {
            Point point = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                point.x = -this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                point.x = this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                point.y = -this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                point.y = this.slideProgress;
            }
            graphics2D.drawImage(imageTransition.getOtherImage(), 0, 0, n, n2, null);
            Composite composite = LafUtils.setupAlphaComposite(graphics2D, 1.0f - f, this.fade);
            graphics2D.drawImage(imageTransition.getCurrentImage(), point.x, point.y, n, n2, null);
            LafUtils.restoreComposite(graphics2D, composite, this.fade);
        } else if (this.type.equals((Object)SlideType.moveBoth)) {
            Point point = new Point(0, 0);
            Point point2 = new Point(0, 0);
            if (this.direction.equals((Object)Direction.left)) {
                point.x = -this.slideProgress;
                point2.x = n - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.right)) {
                point.x = this.slideProgress;
                point2.x = -n + this.slideProgress;
            } else if (this.direction.equals((Object)Direction.up)) {
                point.y = -this.slideProgress;
                point2.y = n2 - this.slideProgress;
            } else if (this.direction.equals((Object)Direction.down)) {
                point.y = this.slideProgress;
                point2.y = -n2 + this.slideProgress;
            }
            graphics2D.drawImage(imageTransition.getCurrentImage(), point.x, point.y, n, n2, null);
            graphics2D.drawImage(imageTransition.getOtherImage(), point2.x, point2.y, n, n2, null);
        }
    }
}

