/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree.sample;

import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.sample.SampleNode;
import com.alee.extended.tree.sample.SampleNodeType;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.ThreadUtils;
import java.util.List;

public class SampleDataProvider
implements AsyncTreeDataProvider<SampleNode> {
    @Override
    public SampleNode getRoot() {
        return new SampleNode("Root", SampleNodeType.root);
    }

    @Override
    public List<SampleNode> getChilds(SampleNode sampleNode) {
        sampleNode.setTime(0L);
        int n = MathUtils.random(100, 3000);
        ThreadUtils.sleepSafely(n);
        sampleNode.setTime(n);
        switch (sampleNode.getType()) {
            case root: {
                SampleNode sampleNode2 = new SampleNode("Folder 1", SampleNodeType.folder);
                SampleNode sampleNode3 = new SampleNode("Folder 2", SampleNodeType.folder);
                SampleNode sampleNode4 = new SampleNode("Folder 3", SampleNodeType.folder);
                return CollectionUtils.copy(sampleNode2, sampleNode3, sampleNode4);
            }
            case folder: {
                SampleNode sampleNode5 = new SampleNode("Leaf 1", SampleNodeType.leaf);
                SampleNode sampleNode6 = new SampleNode("Leaf 2", SampleNodeType.leaf);
                SampleNode sampleNode7 = new SampleNode("Leaf 3", SampleNodeType.leaf);
                return CollectionUtils.copy(sampleNode5, sampleNode6, sampleNode7);
            }
        }
        return null;
    }

    @Override
    public boolean isLeaf(SampleNode sampleNode) {
        return sampleNode.getType().equals((Object)SampleNodeType.leaf);
    }
}

