/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.filters;

import com.alee.graphics.filters.AbstractBufferedImageOp;
import com.alee.graphics.filters.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class ShadowFilter
extends AbstractBufferedImageOp {
    private int radius = 5;
    private int xOffset = 5;
    private int yOffset = 5;
    private float opacity = 0.5f;
    private boolean addMargins = false;
    private boolean shadowOnly = true;
    private int shadowColor = -16777216;

    public ShadowFilter() {
    }

    public ShadowFilter(int n, int n2, int n3, float f) {
        this.radius = n;
        this.xOffset = n2;
        this.yOffset = n3;
        this.opacity = f;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int n) {
        this.yOffset = n;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setAddMargins(boolean bl) {
        this.addMargins = bl;
    }

    public boolean getAddMargins() {
        return this.addMargins;
    }

    public void setShadowOnly(boolean bl) {
        this.shadowOnly = bl;
    }

    public boolean getShadowOnly() {
        return this.shadowOnly;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.addMargins) {
            rectangle.width += Math.abs(this.xOffset) + 2 * this.radius;
            rectangle.height += Math.abs(this.yOffset) + 2 * this.radius;
        }
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            if (this.addMargins) {
                object = bufferedImage.getColorModel();
                bufferedImage2 = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), ((ColorModel)object).isAlphaPremultiplied(), null);
            } else {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        object = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, this.opacity}};
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        new BandCombineOp((float[][])object, null).filter(bufferedImage.getRaster(), bufferedImage3.getRaster());
        bufferedImage3 = new GaussianFilter(this.radius).filter(bufferedImage3, null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        if (this.addMargins) {
            int n3 = Math.max(0, this.radius - this.yOffset);
            int n4 = Math.max(0, this.radius - this.xOffset);
            graphics2D.translate(n3, n4);
        }
        graphics2D.drawRenderedImage(bufferedImage3, AffineTransform.getTranslateInstance(this.xOffset, this.yOffset));
        if (!this.shadowOnly) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawRenderedImage(bufferedImage, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }
}

