/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class RandomStroke
implements Stroke {
    private float detail = 2.0f;
    private float amplitude = 2.0f;
    private static final float FLATNESS = 1.0f;

    public RandomStroke(float f, float f2) {
        this.detail = f;
        this.amplitude = f2;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath();
        shape = new BasicStroke(10.0f).createStrokedShape(shape);
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        while (!flatteningPathIterator.isDone()) {
            int n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = this.randomize(fArray[0]);
                    f2 = f4 = this.randomize(fArray[1]);
                    generalPath.moveTo(f, f2);
                    f5 = 0.0f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    float f6 = this.randomize(fArray[0]);
                    float f7 = this.randomize(fArray[1]);
                    float f8 = f6 - f3;
                    float f9 = f7 - f4;
                    float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                    if (f10 >= f5) {
                        float f11 = 1.0f / f10;
                        while (f10 >= f5) {
                            float f12 = f3 + f5 * f8 * f11;
                            float f13 = f4 + f5 * f9 * f11;
                            generalPath.lineTo(this.randomize(f12), this.randomize(f13));
                            f5 += this.detail;
                        }
                    }
                    f5 -= f10;
                    f3 = f6;
                    f4 = f7;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }

    private float randomize(float f) {
        return f + (float)Math.random() * this.amplitude * 2.0f - 1.0f;
    }
}

