/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class ZigzagStroke
implements Stroke {
    private float amplitude = 10.0f;
    private float wavelength = 10.0f;
    private Stroke stroke;
    private static final float FLATNESS = 1.0f;

    public ZigzagStroke(float f, float f2) {
        this(new BasicStroke(1.0f), f, f2);
    }

    public ZigzagStroke(Stroke stroke, float f, float f2) {
        this.stroke = stroke;
        this.amplitude = f;
        this.wavelength = f2;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = 0;
        while (!flatteningPathIterator.isDone()) {
            int n2 = flatteningPathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    generalPath.moveTo(f, f2);
                    f5 = this.wavelength / 2.0f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    float f6 = fArray[0];
                    float f7 = fArray[1];
                    float f8 = f6 - f3;
                    float f9 = f7 - f4;
                    float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                    if (f10 >= f5) {
                        float f11 = 1.0f / f10;
                        while (f10 >= f5) {
                            float f12 = f3 + f5 * f8 * f11;
                            float f13 = f4 + f5 * f9 * f11;
                            if (!(n & true)) {
                                generalPath.lineTo(f12 + this.amplitude * f9 * f11, f13 - this.amplitude * f8 * f11);
                            } else {
                                generalPath.lineTo(f12 - this.amplitude * f9 * f11, f13 + this.amplitude * f8 * f11);
                            }
                            f5 += this.wavelength;
                            ++n;
                        }
                    }
                    f5 -= f10;
                    f3 = f6;
                    f4 = f7;
                    if (n2 != 4) break;
                    generalPath.closePath();
                }
            }
            flatteningPathIterator.next();
        }
        return this.stroke.createStrokedShape(generalPath);
    }
}

