/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButtonStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class WebButtonUI
extends BasicButtonUI
implements ShapeProvider,
SwingConstants {
    private Color topBgColor = WebButtonStyle.topBgColor;
    private Color bottomBgColor = WebButtonStyle.bottomBgColor;
    private Color topSelectedBgColor = WebButtonStyle.topSelectedBgColor;
    private Color bottomSelectedBgColor = WebButtonStyle.bottomSelectedBgColor;
    private Color selectedForeground = WebButtonStyle.selectedForeground;
    private boolean rolloverShine = WebButtonStyle.rolloverShine;
    private Color shineColor = WebButtonStyle.shineColor;
    private boolean rolloverDarkBorderOnly = WebButtonStyle.rolloverDarkBorderOnly;
    private int round = WebButtonStyle.round;
    private boolean drawShade = WebButtonStyle.drawShade;
    private boolean rolloverShadeOnly = WebButtonStyle.rolloverShadeOnly;
    private boolean showDisabledShade = WebButtonStyle.showDisabledShade;
    private int shadeWidth = WebButtonStyle.shadeWidth;
    private Insets margin = WebButtonStyle.margin;
    private Color shadeColor = WebButtonStyle.shadeColor;
    private int innerShadeWidth = WebButtonStyle.innerShadeWidth;
    private Color innerShadeColor = WebButtonStyle.innerShadeColor;
    private int leftRightSpacing = WebButtonStyle.leftRightSpacing;
    private boolean shadeToggleIcon = WebButtonStyle.shadeToggleIcon;
    private float shadeToggleIconTransparency = WebButtonStyle.shadeToggleIconTransparency;
    private boolean drawFocus = WebButtonStyle.drawFocus;
    private boolean rolloverDecoratedOnly = WebButtonStyle.rolloverDecoratedOnly;
    private boolean animate = WebButtonStyle.animate;
    private boolean undecorated = WebButtonStyle.undecorated;
    private Painter painter = WebButtonStyle.painter;
    private boolean moveIconOnPress = WebButtonStyle.moveIconOnPress;
    private boolean drawTop = true;
    private boolean drawLeft = true;
    private boolean drawBottom = true;
    private boolean drawRight = true;
    private boolean drawTopLine = false;
    private boolean drawLeftLine = false;
    private boolean drawBottomLine = false;
    private boolean drawRightLine = false;
    private Color transparentShineColor = new Color(this.shineColor.getRed(), this.shineColor.getGreen(), this.shineColor.getBlue(), 0);
    private boolean rollover = false;
    private float transparency = 0.0f;
    private Point mousePoint = null;
    private Timer animator = null;
    private AbstractButton button = null;
    private MouseAdapter mouseAdapter;
    private AncestorListener ancestorListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebButtonUI();
    }

    @Override
    public void installUI(final JComponent jComponent) {
        super.installUI(jComponent);
        this.button = (AbstractButton)jComponent;
        SwingUtils.setOrientation(this.button);
        this.button.setFocusPainted(false);
        this.button.setContentAreaFilled(false);
        this.button.setBorderPainted(false);
        this.button.setFocusable(true);
        this.button.setOpaque(false);
        this.updateBorder();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WebButtonUI.this.rollover = true;
                WebButtonUI.this.button.getModel().setRollover(true);
                WebButtonUI.this.mousePoint = mouseEvent.getPoint();
                this.stopAnimator();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.animate && (WebButtonUI.this.rolloverShine || WebButtonUI.this.rolloverDecoratedOnly || WebButtonUI.this.rolloverShadeOnly)) {
                    WebButtonUI.this.animator = new Timer("WebButtonUI.fadeInTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WebButtonUI.this.transparency += 0.075f;
                            if (WebButtonUI.this.transparency >= 1.0f) {
                                WebButtonUI.this.transparency = 1.0f;
                                WebButtonUI.this.animator.stop();
                            }
                            WebButtonUI.this.updateTransparentShineColor();
                            if (jComponent.isEnabled()) {
                                jComponent.repaint();
                            }
                        }
                    });
                    WebButtonUI.this.animator.start();
                } else {
                    WebButtonUI.this.transparency = 1.0f;
                    WebButtonUI.this.updateTransparentShineColor();
                    jComponent.repaint();
                }
                this.refresh(jComponent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WebButtonUI.this.mousePoint = mouseEvent.getPoint();
                this.stopAnimator();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.animate && (WebButtonUI.this.rolloverShine || WebButtonUI.this.rolloverDecoratedOnly || WebButtonUI.this.rolloverShadeOnly)) {
                    WebButtonUI.this.animator = new Timer("WebButtonUI.fadeOutTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WebButtonUI.this.transparency -= 0.075f;
                            if (WebButtonUI.this.transparency <= 0.0f) {
                                WebButtonUI.this.rollover = false;
                                WebButtonUI.this.button.getModel().setRollover(false);
                                WebButtonUI.this.transparency = 0.0f;
                                WebButtonUI.this.mousePoint = null;
                                WebButtonUI.this.animator.stop();
                            }
                            WebButtonUI.this.updateTransparentShineColor();
                            if (jComponent.isEnabled()) {
                                jComponent.repaint();
                            }
                        }
                    });
                    WebButtonUI.this.animator.start();
                } else {
                    WebButtonUI.this.rollover = false;
                    WebButtonUI.this.button.getModel().setRollover(false);
                    WebButtonUI.this.transparency = 0.0f;
                    WebButtonUI.this.mousePoint = null;
                    WebButtonUI.this.updateTransparentShineColor();
                    jComponent.repaint();
                }
                this.refresh(jComponent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!jComponent.isShowing() || this.windowLostFocus()) {
                    WebButtonUI.this.mousePoint = null;
                    jComponent.repaint();
                }
            }

            private boolean windowLostFocus() {
                Window window = SwingUtils.getWindowAncestor(jComponent);
                return window == null || !window.isVisible() || !window.isActive();
            }

            private void stopAnimator() {
                if (WebButtonUI.this.animator != null) {
                    WebButtonUI.this.animator.stop();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                WebButtonUI.this.mousePoint = mouseEvent.getPoint();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.rolloverShine) {
                    this.refresh(jComponent);
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                WebButtonUI.this.mousePoint = mouseEvent.getPoint();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.rolloverShine) {
                    this.refresh(jComponent);
                }
            }

            private void refresh(JComponent jComponent2) {
                if (jComponent2.isEnabled() && (WebButtonUI.this.animator == null || !WebButtonUI.this.animator.isRunning())) {
                    jComponent2.repaint();
                }
            }
        };
        jComponent.addMouseListener(this.mouseAdapter);
        jComponent.addMouseMotionListener(this.mouseAdapter);
        this.ancestorListener = new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                WebButtonUI.this.rollover = false;
                WebButtonUI.this.button.getModel().setRollover(false);
                WebButtonUI.this.transparency = 0.0f;
                WebButtonUI.this.mousePoint = null;
                WebButtonUI.this.updateTransparentShineColor();
                jComponent.repaint();
            }
        };
        jComponent.addAncestorListener(this.ancestorListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebButtonUI.this.updateBorder();
            }
        };
        jComponent.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(this.mouseAdapter);
        jComponent.removeMouseMotionListener(this.mouseAdapter);
        jComponent.removeAncestorListener(this.ancestorListener);
        jComponent.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null || this.undecorated) {
            return SwingUtils.size(this.button);
        }
        return this.getButtonShape(this.button, true);
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color color) {
        this.topBgColor = color;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color color) {
        this.bottomBgColor = color;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color color) {
        this.topSelectedBgColor = color;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color color) {
        this.bottomSelectedBgColor = color;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean bl) {
        this.rolloverDarkBorderOnly = bl;
    }

    public boolean isRolloverShine() {
        return this.rolloverShine;
    }

    public void setRolloverShine(boolean bl) {
        this.rolloverShine = bl;
    }

    public Color getShineColor() {
        return this.shineColor;
    }

    public void setShineColor(Color color) {
        this.shineColor = color;
        this.updateTransparentShineColor();
    }

    private void updateTransparentShineColor() {
        this.transparentShineColor = new Color(this.shineColor.getRed(), this.shineColor.getGreen(), this.shineColor.getBlue(), Math.round(this.transparency * (float)this.shineColor.getAlpha()));
    }

    private void updateBorder() {
        if (this.button != null) {
            boolean bl = this.button.getComponentOrientation().isLeftToRight();
            Insets insets = new Insets(this.margin.top, (bl ? this.margin.left : this.margin.right) + this.leftRightSpacing, this.margin.bottom, (bl ? this.margin.right : this.margin.left) + this.leftRightSpacing);
            if (this.painter != null) {
                Insets insets2 = this.painter.getMargin(this.button);
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
                insets.left = insets.left + (bl ? insets2.left : insets2.right);
                insets.right = insets.right + (bl ? insets2.right : insets2.left);
            } else if (!this.undecorated) {
                boolean bl2 = bl ? this.drawLeft : this.drawRight;
                boolean bl3 = bl ? this.drawLeftLine : this.drawRightLine;
                boolean bl4 = bl ? this.drawRight : this.drawLeft;
                boolean bl5 = bl ? this.drawRightLine : this.drawLeftLine;
                insets.top = insets.top + ((this.drawTop ? this.shadeWidth + 1 : (this.drawTopLine ? 1 : 0) - 1) + this.innerShadeWidth);
                insets.left = insets.left + ((bl2 ? this.shadeWidth + 1 : (bl3 ? 1 : 0) - 1) + this.innerShadeWidth);
                insets.bottom = insets.bottom + ((this.drawBottom ? this.shadeWidth + 1 : (this.drawBottomLine ? 1 : 0) - 1) + this.innerShadeWidth);
                insets.right = insets.right + ((bl4 ? this.shadeWidth + 1 : (bl5 ? 1 : 0) - 1) + this.innerShadeWidth);
            }
            this.button.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean bl) {
        this.drawShade = bl;
    }

    public boolean isRolloverShadeOnly() {
        return this.rolloverShadeOnly;
    }

    public void setRolloverShadeOnly(boolean bl) {
        this.rolloverShadeOnly = bl;
    }

    public boolean isShowDisabledShade() {
        return this.showDisabledShade;
    }

    public void setShowDisabledShade(boolean bl) {
        this.showDisabledShade = bl;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color color) {
        this.shadeColor = color;
    }

    public int getInnerShadeWidth() {
        return this.innerShadeWidth;
    }

    public void setInnerShadeWidth(int n) {
        this.innerShadeWidth = n;
        this.updateBorder();
    }

    public Color getInnerShadeColor() {
        return this.innerShadeColor;
    }

    public void setInnerShadeColor(Color color) {
        this.innerShadeColor = color;
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int n) {
        this.leftRightSpacing = n;
        this.updateBorder();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public boolean isShadeToggleIcon() {
        return this.shadeToggleIcon;
    }

    public void setShadeToggleIcon(boolean bl) {
        this.shadeToggleIcon = bl;
    }

    public float getShadeToggleIconTransparency() {
        return this.shadeToggleIconTransparency;
    }

    public void setShadeToggleIconTransparency(float f) {
        this.shadeToggleIconTransparency = f;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
        this.updateBorder();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.updateBorder();
    }

    public boolean isMoveIconOnPress() {
        return this.moveIconOnPress;
    }

    public void setMoveIconOnPress(boolean bl) {
        this.moveIconOnPress = bl;
    }

    public boolean isRolloverDecoratedOnly() {
        return this.rolloverDecoratedOnly;
    }

    public void setRolloverDecoratedOnly(boolean bl) {
        this.rolloverDecoratedOnly = bl;
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public void setDrawBottom(boolean bl) {
        this.drawBottom = bl;
        this.updateBorder();
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public void setDrawLeft(boolean bl) {
        this.drawLeft = bl;
        this.updateBorder();
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public void setDrawRight(boolean bl) {
        this.drawRight = bl;
        this.updateBorder();
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public void setDrawTop(boolean bl) {
        this.drawTop = bl;
        this.updateBorder();
    }

    public void setDrawSides(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.drawTop = bl;
        this.drawLeft = bl2;
        this.drawBottom = bl3;
        this.drawRight = bl4;
        this.updateBorder();
    }

    public boolean isDrawTopLine() {
        return this.drawTopLine;
    }

    public void setDrawTopLine(boolean bl) {
        this.drawTopLine = bl;
        this.updateBorder();
    }

    public boolean isDrawLeftLine() {
        return this.drawLeftLine;
    }

    public void setDrawLeftLine(boolean bl) {
        this.drawLeftLine = bl;
        this.updateBorder();
    }

    public boolean isDrawBottomLine() {
        return this.drawBottomLine;
    }

    public void setDrawBottomLine(boolean bl) {
        this.drawBottomLine = bl;
        this.updateBorder();
    }

    public boolean isDrawRightLine() {
        return this.drawRightLine;
    }

    public void setDrawRightLine(boolean bl) {
        this.drawRightLine = bl;
        this.updateBorder();
    }

    public void setDrawLines(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.drawTopLine = bl;
        this.drawLeftLine = bl2;
        this.drawBottomLine = bl3;
        this.drawRightLine = bl4;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        if (this.painter != null || !this.undecorated) {
            if (this.painter != null) {
                this.painter.paint(graphics2D, SwingUtils.size(jComponent), jComponent);
            } else if (!this.undecorated) {
                boolean bl = buttonModel.isPressed() || buttonModel.isSelected();
                Shape shape = this.getButtonShape(abstractButton, true);
                if (this.isDrawButton(jComponent, buttonModel)) {
                    int n;
                    boolean bl2;
                    boolean bl3 = this.animate && this.rolloverDecoratedOnly && !bl;
                    Composite composite = LafUtils.setupAlphaComposite(graphics2D, this.transparency, bl3);
                    if (this.drawShade && (jComponent.isEnabled() || this.showDisabledShade) && (!this.rolloverShadeOnly || this.rollover)) {
                        bl2 = !bl3 && this.rolloverShadeOnly;
                        Composite composite2 = LafUtils.setupAlphaComposite(graphics2D, this.transparency, bl2);
                        LafUtils.drawShade(graphics2D, shape, this.getShadeColor(jComponent), this.shadeWidth);
                        LafUtils.restoreComposite(graphics2D, composite2, bl2);
                    }
                    graphics2D.setPaint(new GradientPaint(0.0f, this.drawTop ? (float)this.shadeWidth : 0.0f, bl ? this.topSelectedBgColor : this.topBgColor, 0.0f, abstractButton.getHeight() - (this.drawBottom ? this.shadeWidth : 0), bl ? this.bottomSelectedBgColor : this.bottomBgColor));
                    graphics2D.fill(this.getButtonShape(abstractButton, false));
                    if (this.rolloverShine && this.mousePoint != null && jComponent.isEnabled()) {
                        Shape shape2 = LafUtils.intersectClip(graphics2D, shape);
                        graphics2D.setPaint(new RadialGradientPaint(this.mousePoint.x, (float)jComponent.getHeight(), jComponent.getWidth(), new float[]{0.0f, 1.0f}, new Color[]{this.transparentShineColor, StyleConstants.transparent}));
                        graphics2D.fill(shape);
                        LafUtils.restoreClip(graphics2D, shape2);
                    }
                    if (bl) {
                        LafUtils.drawShade(graphics2D, shape, this.innerShadeColor, this.innerShadeWidth, shape);
                    }
                    graphics2D.setPaint(jComponent.isEnabled() ? (this.rolloverDarkBorderOnly && this.rollover ? this.getBorderColor() : (!this.rolloverDarkBorderOnly ? StyleConstants.darkBorderColor : StyleConstants.borderColor)) : StyleConstants.disabledBorderColor);
                    graphics2D.draw(shape);
                    bl2 = abstractButton.getComponentOrientation().isLeftToRight();
                    boolean bl4 = bl2 ? this.drawLeft : this.drawRight;
                    boolean bl5 = bl2 ? this.drawLeftLine : this.drawRightLine;
                    boolean bl6 = bl2 ? this.drawRight : this.drawLeft;
                    boolean bl7 = bl2 ? this.drawRightLine : this.drawLeftLine;
                    graphics2D.setPaint(jComponent.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                    if (this.drawTopLine) {
                        n = bl4 ? this.shadeWidth : 0;
                        graphics2D.drawLine(n, 0, n + jComponent.getWidth() - (bl4 ? this.shadeWidth : 0) - (bl6 ? this.shadeWidth + 1 : 0), 0);
                    }
                    if (this.drawBottomLine) {
                        n = bl4 ? this.shadeWidth : 0;
                        graphics2D.drawLine(n, jComponent.getHeight() - 1, n + jComponent.getWidth() - (bl4 ? this.shadeWidth : 0) - (bl6 ? this.shadeWidth + 1 : 0), jComponent.getHeight() - 1);
                    }
                    if (bl5) {
                        n = this.drawTop ? this.shadeWidth : 0;
                        graphics2D.drawLine(0, n, 0, n + jComponent.getHeight() - (this.drawTop ? this.shadeWidth : 0) - (this.drawBottom ? this.shadeWidth + 1 : 0));
                    }
                    if (bl7) {
                        n = this.drawTop ? this.shadeWidth : 0;
                        graphics2D.drawLine(jComponent.getWidth() - 1, n, jComponent.getWidth() - 1, n + jComponent.getHeight() - (this.drawTop ? this.shadeWidth : 0) - (this.drawBottom ? this.shadeWidth + 1 : 0));
                    }
                    LafUtils.restoreComposite(graphics2D, composite, bl3);
                }
            }
        }
        if (buttonModel.isPressed() && this.moveIconOnPress) {
            graphics2D.translate(1, 1);
        }
        LafUtils.restoreAntialias(graphics2D, object);
        Map map = SwingUtils.setupTextAntialias(graphics2D, (Component)jComponent);
        super.paint(graphics, jComponent);
        SwingUtils.restoreTextAntialias(graphics2D, map);
    }

    private Color getShadeColor(JComponent jComponent) {
        return this.isFocusActive(jComponent) ? StyleConstants.fieldFocusColor : this.shadeColor;
    }

    private boolean isFocusActive(JComponent jComponent) {
        return jComponent.isEnabled() && this.drawFocus && jComponent.isFocusOwner();
    }

    private boolean isDrawButton(JComponent jComponent, ButtonModel buttonModel) {
        return this.rolloverDecoratedOnly && this.rollover && jComponent.isEnabled() || this.animate && this.transparency > 0.0f && jComponent.isEnabled() || !this.rolloverDecoratedOnly || buttonModel.isSelected() || buttonModel.isPressed();
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtils.getFontMetrics(jComponent, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(buttonModel.isPressed() || buttonModel.isSelected() ? this.selectedForeground : abstractButton.getForeground());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    private Color getBorderColor() {
        return ColorUtils.getIntermediateColor(StyleConstants.borderColor, StyleConstants.darkBorderColor, this.transparency);
    }

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = this.shadeToggleIcon && abstractButton instanceof JToggleButton && !buttonModel.isSelected();
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, this.shadeToggleIconTransparency, bl);
        super.paintIcon(graphics, jComponent, rectangle);
        LafUtils.restoreComposite(graphics2D, composite, bl);
    }

    protected Shape getButtonShape(AbstractButton abstractButton, boolean bl) {
        boolean bl2 = abstractButton.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl2 ? this.drawLeft : this.drawRight;
        boolean bl4 = bl2 ? this.drawRight : this.drawLeft;
        int n = bl3 ? this.shadeWidth : -this.shadeWidth - this.round - 1;
        int n2 = this.drawTop ? this.shadeWidth : -this.shadeWidth - this.round - 1;
        int n3 = bl4 ? abstractButton.getWidth() - this.shadeWidth - 1 : abstractButton.getWidth() + this.shadeWidth + this.round;
        int n4 = this.drawBottom ? abstractButton.getHeight() - this.shadeWidth - 1 : abstractButton.getHeight() + this.shadeWidth + this.round;
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (this.round > 0) {
            return new RoundRectangle2D.Double(n, n2, n5, n6, this.round * 2 + (bl ? 0 : 1), this.round * 2 + (bl ? 0 : 1));
        }
        return new Rectangle2D.Double(n, n2, n5, n6);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.painter != null) {
            dimension = SwingUtils.max(dimension, this.painter.getPreferredSize(jComponent));
        }
        return dimension;
    }
}

