/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.laf.StyleConstants;
import com.alee.laf.checkbox.WebCheckBoxStyle;
import com.alee.laf.list.WebListElement;
import com.alee.laf.tree.WebTreeElement;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.Timer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class WebCheckBoxUI
extends BasicCheckBoxUI
implements ShapeProvider {
    public static final int MAX_DARKNESS = 5;
    public static List<ImageIcon> CHECK_STATES = new ArrayList<ImageIcon>();
    public static ImageIcon DISABLED_CHECK = null;
    public static int updateDelay = 40;
    private Color borderColor = WebCheckBoxStyle.borderColor;
    private Color darkBorderColor = WebCheckBoxStyle.darkBorderColor;
    private Color disabledBorderColor = WebCheckBoxStyle.disabledBorderColor;
    private Color topBgColor = WebCheckBoxStyle.topBgColor;
    private Color bottomBgColor = WebCheckBoxStyle.bottomBgColor;
    private Color topSelectedBgColor = WebCheckBoxStyle.topSelectedBgColor;
    private Color bottomSelectedBgColor = WebCheckBoxStyle.bottomSelectedBgColor;
    private int round = WebCheckBoxStyle.round;
    private int shadeWidth = WebCheckBoxStyle.shadeWidth;
    private Insets margin = WebCheckBoxStyle.margin;
    private boolean animated = WebCheckBoxStyle.animated;
    private boolean rolloverDarkBorderOnly = WebCheckBoxStyle.rolloverDarkBorderOnly;
    public Stroke borderStroke = new BasicStroke(1.5f);
    private int iconWidth = 16;
    private int iconHeight = 16;
    private int bgDarkness = 0;
    private boolean rollover;
    private Timer bgTimer;
    private int checkIcon;
    private boolean checking;
    private Timer checkTimer;
    private Rectangle iconRect;
    private JCheckBox checkBox = null;
    private MouseAdapter mouseAdapter;
    private ItemListener itemListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebCheckBoxUI();
    }

    @Override
    public void installUI(final JComponent jComponent) {
        super.installUI(jComponent);
        this.checkBox = (JCheckBox)jComponent;
        SwingUtils.setOrientation(this.checkBox);
        this.checkBox.setOpaque(false);
        this.checkIcon = this.checkBox.isSelected() ? CHECK_STATES.size() - 1 : 0;
        this.updateBorder();
        this.updateIcon(this.checkBox);
        this.bgTimer = new Timer("WebCheckBoxUI.bgUpdater", (long)updateDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebCheckBoxUI.this.rollover && WebCheckBoxUI.this.bgDarkness < 5) {
                    WebCheckBoxUI.this.bgDarkness++;
                    jComponent.repaint();
                } else if (!WebCheckBoxUI.this.rollover && WebCheckBoxUI.this.bgDarkness > 0) {
                    WebCheckBoxUI.this.bgDarkness--;
                    jComponent.repaint();
                } else {
                    WebCheckBoxUI.this.bgTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WebCheckBoxUI.this.rollover = true;
                if (WebCheckBoxUI.this.isAnimated() && jComponent.isEnabled()) {
                    WebCheckBoxUI.this.bgTimer.start();
                } else {
                    WebCheckBoxUI.this.bgDarkness = 5;
                    jComponent.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WebCheckBoxUI.this.rollover = false;
                if (WebCheckBoxUI.this.isAnimated() && jComponent.isEnabled()) {
                    WebCheckBoxUI.this.bgTimer.start();
                } else {
                    WebCheckBoxUI.this.bgDarkness = 0;
                    jComponent.repaint();
                }
            }
        };
        this.checkBox.addMouseListener(this.mouseAdapter);
        this.checkTimer = new Timer("WebCheckBoxUI.iconUpdater", (long)updateDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebCheckBoxUI.this.checking && WebCheckBoxUI.this.checkIcon < CHECK_STATES.size() - 1) {
                    WebCheckBoxUI.this.checkIcon++;
                    jComponent.repaint();
                } else if (!WebCheckBoxUI.this.checking && WebCheckBoxUI.this.checkIcon > 0) {
                    WebCheckBoxUI.this.checkIcon--;
                    jComponent.repaint();
                } else {
                    WebCheckBoxUI.this.checkTimer.stop();
                }
            }
        });
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (WebCheckBoxUI.this.isAnimationAllowed() && WebCheckBoxUI.this.isAnimated() && jComponent.isEnabled()) {
                    if (WebCheckBoxUI.this.checkBox.isSelected()) {
                        WebCheckBoxUI.this.checking = true;
                        WebCheckBoxUI.this.checkTimer.start();
                    } else {
                        WebCheckBoxUI.this.checking = false;
                        WebCheckBoxUI.this.checkTimer.start();
                    }
                } else {
                    WebCheckBoxUI.this.checkTimer.stop();
                    WebCheckBoxUI.this.checkIcon = WebCheckBoxUI.this.checkBox.isSelected() ? CHECK_STATES.size() - 1 : 0;
                    jComponent.repaint();
                }
            }
        };
        this.checkBox.addItemListener(this.itemListener);
    }

    private boolean isAnimationAllowed() {
        Container container = this.checkBox.getParent();
        if (container == null) {
            return true;
        }
        String string = container.getClass().toString();
        return !string.contains("com.jidesoft.swing.CheckBoxList") && !string.contains("com.jidesoft.swing.CheckBoxTreeCellRenderer");
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.checkBox.removeMouseListener(this.mouseAdapter);
        this.checkBox.removeItemListener(this.itemListener);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.checkBox, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder() {
        boolean bl = this.checkBox.getComponentOrientation().isLeftToRight();
        Insets insets = new Insets(this.margin.top, bl ? this.margin.left : this.margin.right, this.margin.bottom, bl ? this.margin.right : this.margin.left);
        this.checkBox.setBorder(LafUtils.createWebBorder(insets));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public boolean isAnimated() {
        return this.animated && (this.checkBox == null || this.checkBox.getParent() == null || !(this.checkBox.getParent() instanceof WebListElement) && !(this.checkBox.getParent() instanceof WebTreeElement));
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean bl) {
        this.rolloverDarkBorderOnly = bl;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getDarkBorderColor() {
        return this.darkBorderColor;
    }

    public void setDarkBorderColor(Color color) {
        this.darkBorderColor = color;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        this.disabledBorderColor = color;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color color) {
        this.topBgColor = color;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color color) {
        this.bottomBgColor = color;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color color) {
        this.topSelectedBgColor = color;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color color) {
        this.bottomSelectedBgColor = color;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int n) {
        this.iconWidth = n;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int n) {
        this.iconHeight = n;
    }

    private void updateIcon(final JCheckBox jCheckBox) {
        jCheckBox.setIcon(new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                WebCheckBoxUI.this.iconRect = new Rectangle(n, n2, WebCheckBoxUI.this.iconWidth, WebCheckBoxUI.this.iconHeight);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = LafUtils.setupAntialias(graphics2D);
                Rectangle rectangle = new Rectangle(n + WebCheckBoxUI.this.shadeWidth, n2 + WebCheckBoxUI.this.shadeWidth, WebCheckBoxUI.this.iconWidth - WebCheckBoxUI.this.shadeWidth * 2 - 1, WebCheckBoxUI.this.iconHeight - WebCheckBoxUI.this.shadeWidth * 2 - 1);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, WebCheckBoxUI.this.round * 2, WebCheckBoxUI.this.round * 2);
                if (component.isEnabled()) {
                    LafUtils.drawShade(graphics2D, double_, component.isEnabled() && component.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, WebCheckBoxUI.this.shadeWidth);
                }
                int n3 = Math.round((float)Math.sqrt(rectangle.width * rectangle.width / 2));
                graphics2D.setPaint(new RadialGradientPaint(rectangle.x + rectangle.width / 2, (float)(rectangle.y + rectangle.height / 2), n3, new float[]{0.0f, 1.0f}, WebCheckBoxUI.this.getBgColors(jCheckBox)));
                graphics2D.fill(double_);
                Stroke stroke = LafUtils.setupStroke(graphics2D, WebCheckBoxUI.this.borderStroke);
                graphics2D.setPaint(component.isEnabled() ? (WebCheckBoxUI.this.rolloverDarkBorderOnly ? ColorUtils.getIntermediateColor(WebCheckBoxUI.this.borderColor, WebCheckBoxUI.this.darkBorderColor, WebCheckBoxUI.this.getProgress()) : WebCheckBoxUI.this.darkBorderColor) : WebCheckBoxUI.this.disabledBorderColor);
                graphics2D.draw(double_);
                LafUtils.restoreStroke(graphics2D, stroke);
                if (WebCheckBoxUI.this.checkIcon > 0) {
                    ImageIcon imageIcon = jCheckBox.isEnabled() ? CHECK_STATES.get(WebCheckBoxUI.this.checkIcon) : DISABLED_CHECK;
                    graphics2D.drawImage(imageIcon.getImage(), n + WebCheckBoxUI.this.iconWidth / 2 - imageIcon.getIconWidth() / 2, n2 + WebCheckBoxUI.this.iconHeight / 2 - imageIcon.getIconHeight() / 2, jCheckBox);
                }
                LafUtils.restoreAntialias(graphics2D, object);
            }

            @Override
            public int getIconWidth() {
                return WebCheckBoxUI.this.iconWidth;
            }

            @Override
            public int getIconHeight() {
                return WebCheckBoxUI.this.iconHeight;
            }
        });
    }

    private Color[] getBgColors(JCheckBox jCheckBox) {
        if (jCheckBox.isEnabled()) {
            float f = this.getProgress();
            if (f < 1.0f) {
                return new Color[]{ColorUtils.getIntermediateColor(this.topBgColor, this.topSelectedBgColor, f), ColorUtils.getIntermediateColor(this.bottomBgColor, this.bottomSelectedBgColor, f)};
            }
            return new Color[]{this.topSelectedBgColor, this.bottomSelectedBgColor};
        }
        return new Color[]{this.topBgColor, this.bottomBgColor};
    }

    private float getProgress() {
        return (float)this.bgDarkness / 5.0f;
    }

    public Rectangle getIconRect() {
        return this.iconRect != null ? new Rectangle(this.iconRect) : new Rectangle();
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent);
        super.paint(graphics, jComponent);
        SwingUtils.restoreTextAntialias(graphics, map);
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtils.getFontMetrics(jComponent, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    static {
        CHECK_STATES.add(StyleConstants.EMPTY_ICON);
        for (int i = 1; i <= 4; ++i) {
            CHECK_STATES.add(new ImageIcon(WebCheckBoxUI.class.getResource("icons/c" + i + ".png")));
        }
        DISABLED_CHECK = ImageUtils.getDisabledCopy("WebCheckBox.disabled.check", CHECK_STATES.get(CHECK_STATES.size() - 1));
    }
}

