/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.panel;

import com.alee.extended.painter.Painter;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.panel.WebPanelUI;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.util.List;
import javax.swing.JPanel;

public class WebPanel
extends JPanel
implements ShapeProvider {
    private int preferredWidth = -1;
    private int minimumWidth = -1;
    private int preferredHeight = -1;
    private int minimumHeight = -1;

    public WebPanel() {
        super(new BorderLayout());
    }

    public WebPanel(boolean bl) {
        super(new BorderLayout());
        this.setUndecorated(!bl);
    }

    public WebPanel(boolean bl, LayoutManager layoutManager) {
        super(layoutManager);
        this.setUndecorated(!bl);
    }

    public WebPanel(boolean bl, Component component) {
        super(new BorderLayout());
        this.setUndecorated(!bl);
        this.add(component, (Object)"Center");
    }

    public WebPanel(Component component) {
        super(new BorderLayout());
        this.add(component, (Object)"Center");
    }

    public WebPanel(Painter painter) {
        super(new BorderLayout());
        this.setPainter(painter);
    }

    public WebPanel(LayoutManager layoutManager, Painter painter) {
        super(layoutManager);
        this.setPainter(painter);
    }

    public WebPanel(Painter painter, Component component) {
        super(new BorderLayout());
        this.setPainter(painter);
        this.add(component, (Object)"Center");
    }

    public WebPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public WebPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public void add(List<? extends Component> list, int n) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.add(list.get(i), n + i);
            }
        }
    }

    public void add(List<? extends Component> list, String string) {
        if (list != null) {
            for (Component component : list) {
                this.add(component, (Object)string);
            }
        }
    }

    public void add(List<? extends Component> list) {
        if (list != null) {
            for (Component component : list) {
                this.add(component);
            }
        }
    }

    public void add(int n, Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.add(componentArray[i], n + i);
            }
        }
    }

    public void add(String string, Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (Component component : componentArray) {
                this.add(component, (Object)string);
            }
        }
    }

    public void add(Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (Component component : componentArray) {
                this.add(component);
            }
        }
    }

    public Component getFirstComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public Component getLastComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(this.getComponentCount() - 1);
        }
        return null;
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public void setUndecorated(boolean bl) {
        this.getWebUI().setUndecorated(bl);
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public void setDrawFocus(boolean bl) {
        this.getWebUI().setDrawFocus(bl);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public ShapeProvider getClipProvider() {
        return this.getWebUI().getClipProvider();
    }

    public void setClipProvider(ShapeProvider shapeProvider) {
        this.getWebUI().setClipProvider(shapeProvider);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int n) {
        this.getWebUI().setRound(n);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int n) {
        this.getWebUI().setShadeWidth(n);
    }

    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(Insets insets) {
        this.getWebUI().setMargin(insets);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public boolean isDrawBackground() {
        return this.getWebUI().isDrawBackground();
    }

    public void setDrawBackground(boolean bl) {
        this.getWebUI().setDrawBackground(bl);
    }

    public boolean isWebColored() {
        return this.getWebUI().isWebColored();
    }

    public void setWebColored(boolean bl) {
        this.getWebUI().setWebColored(bl);
    }

    public boolean isDrawBottom() {
        return this.getWebUI().isDrawBottom();
    }

    public void setDrawBottom(boolean bl) {
        this.getWebUI().setDrawBottom(bl);
    }

    public boolean isDrawLeft() {
        return this.getWebUI().isDrawLeft();
    }

    public void setDrawLeft(boolean bl) {
        this.getWebUI().setDrawLeft(bl);
    }

    public boolean isDrawRight() {
        return this.getWebUI().isDrawRight();
    }

    public void setDrawRight(boolean bl) {
        this.getWebUI().setDrawRight(bl);
    }

    public boolean isDrawTop() {
        return this.getWebUI().isDrawTop();
    }

    public void setDrawTop(boolean bl) {
        this.getWebUI().setDrawTop(bl);
    }

    public void setDrawSides(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.getWebUI().setDrawSides(bl, bl2, bl3, bl4);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebPanelUI getWebUI() {
        return (WebPanelUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebPanelUI)) {
            try {
                this.setUI((WebPanelUI)ReflectUtils.createInstance(WebLookAndFeel.panelUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebPanelUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        } else if (this.minimumWidth != -1) {
            dimension.width = Math.max(this.minimumWidth, dimension.width);
        }
        if (this.preferredHeight != -1) {
            dimension.height = this.preferredHeight;
        } else if (this.minimumHeight != -1) {
            dimension.height = Math.max(this.minimumHeight, dimension.height);
        }
        return dimension;
    }
}

