/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.radiobutton;

import com.alee.laf.StyleConstants;
import com.alee.laf.list.WebListElement;
import com.alee.laf.radiobutton.WebRadioButtonStyle;
import com.alee.laf.tree.WebTreeElement;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.Timer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class WebRadioButtonUI
extends BasicRadioButtonUI
implements ShapeProvider {
    public static final int MAX_DARKNESS = 5;
    public static List<ImageIcon> CHECK_STATES = new ArrayList<ImageIcon>();
    public static ImageIcon DISABLED_CHECK = null;
    private Color borderColor = WebRadioButtonStyle.borderColor;
    private Color darkBorderColor = WebRadioButtonStyle.darkBorderColor;
    private Color disabledBorderColor = WebRadioButtonStyle.disabledBorderColor;
    private Color topBgColor = WebRadioButtonStyle.topBgColor;
    private Color bottomBgColor = WebRadioButtonStyle.bottomBgColor;
    private Color topSelectedBgColor = WebRadioButtonStyle.topSelectedBgColor;
    private Color bottomSelectedBgColor = WebRadioButtonStyle.bottomSelectedBgColor;
    private int shadeWidth = WebRadioButtonStyle.shadeWidth;
    private Insets margin = WebRadioButtonStyle.margin;
    private boolean animated = WebRadioButtonStyle.animated;
    private boolean rolloverDarkBorderOnly = WebRadioButtonStyle.rolloverDarkBorderOnly;
    public Stroke borderStroke = new BasicStroke(1.5f);
    private int iconWidth = 16;
    private int iconHeight = 16;
    private int bgDarkness = 0;
    private boolean rollover;
    private Timer bgTimer;
    private int checkIcon;
    private boolean checking;
    private Timer checkTimer;
    private Rectangle iconRect;
    private JRadioButton radioButton;
    private MouseAdapter mouseAdapter;
    private ItemListener itemListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebRadioButtonUI();
    }

    @Override
    public void installUI(final JComponent jComponent) {
        super.installUI(jComponent);
        this.radioButton = (JRadioButton)jComponent;
        SwingUtils.setOrientation(jComponent);
        this.radioButton.setOpaque(false);
        this.checkIcon = this.radioButton.isSelected() ? CHECK_STATES.size() - 1 : 0;
        this.updateBorder();
        this.updateIcon(this.radioButton);
        this.bgTimer = new Timer("WebRadioButtonUI.bgUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebRadioButtonUI.this.rollover && WebRadioButtonUI.this.bgDarkness < 5) {
                    WebRadioButtonUI.this.bgDarkness++;
                    jComponent.repaint();
                } else if (!WebRadioButtonUI.this.rollover && WebRadioButtonUI.this.bgDarkness > 0) {
                    WebRadioButtonUI.this.bgDarkness--;
                    jComponent.repaint();
                } else {
                    WebRadioButtonUI.this.bgTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WebRadioButtonUI.this.rollover = true;
                if (WebRadioButtonUI.this.isAnimated()) {
                    WebRadioButtonUI.this.bgTimer.start();
                } else {
                    WebRadioButtonUI.this.bgDarkness = 5;
                    jComponent.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WebRadioButtonUI.this.rollover = false;
                if (WebRadioButtonUI.this.isAnimated()) {
                    WebRadioButtonUI.this.bgTimer.start();
                } else {
                    WebRadioButtonUI.this.bgDarkness = 0;
                    jComponent.repaint();
                }
            }
        };
        this.radioButton.addMouseListener(this.mouseAdapter);
        this.checkTimer = new Timer("WebRadioButtonUI.iconUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebRadioButtonUI.this.checking && WebRadioButtonUI.this.checkIcon < CHECK_STATES.size() - 1) {
                    WebRadioButtonUI.this.checkIcon++;
                    jComponent.repaint();
                } else if (!WebRadioButtonUI.this.checking && WebRadioButtonUI.this.checkIcon > 0) {
                    WebRadioButtonUI.this.checkIcon--;
                    jComponent.repaint();
                } else {
                    WebRadioButtonUI.this.checkTimer.stop();
                }
            }
        });
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (WebRadioButtonUI.this.animated) {
                    if (WebRadioButtonUI.this.radioButton.isSelected()) {
                        WebRadioButtonUI.this.checking = true;
                        WebRadioButtonUI.this.checkTimer.start();
                    } else {
                        WebRadioButtonUI.this.checking = false;
                        WebRadioButtonUI.this.checkTimer.start();
                    }
                } else {
                    WebRadioButtonUI.this.checkTimer.stop();
                    WebRadioButtonUI.this.checkIcon = WebRadioButtonUI.this.radioButton.isSelected() ? CHECK_STATES.size() - 1 : 0;
                    jComponent.repaint();
                }
            }
        };
        this.radioButton.addItemListener(this.itemListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.radioButton.removeMouseListener(this.mouseAdapter);
        this.radioButton.removeItemListener(this.itemListener);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.radioButton, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder() {
        boolean bl = this.radioButton.getComponentOrientation().isLeftToRight();
        Insets insets = new Insets(this.margin.top, bl ? this.margin.left : this.margin.right, this.margin.bottom, bl ? this.margin.right : this.margin.left);
        this.radioButton.setBorder(LafUtils.createWebBorder(insets));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public boolean isAnimated() {
        return this.animated && (this.radioButton == null || this.radioButton.getParent() == null || !(this.radioButton.getParent() instanceof WebListElement) && !(this.radioButton.getParent() instanceof WebTreeElement));
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean bl) {
        this.rolloverDarkBorderOnly = bl;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getDarkBorderColor() {
        return this.darkBorderColor;
    }

    public void setDarkBorderColor(Color color) {
        this.darkBorderColor = color;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        this.disabledBorderColor = color;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color color) {
        this.topBgColor = color;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color color) {
        this.bottomBgColor = color;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color color) {
        this.topSelectedBgColor = color;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color color) {
        this.bottomSelectedBgColor = color;
    }

    public int getRound() {
        return 6;
    }

    public void setRound(int n) {
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int n) {
        this.iconWidth = n;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int n) {
        this.iconHeight = n;
    }

    private void updateIcon(final JRadioButton jRadioButton) {
        jRadioButton.setIcon(new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                WebRadioButtonUI.this.iconRect = new Rectangle(n, n2, WebRadioButtonUI.this.iconWidth, WebRadioButtonUI.this.iconHeight);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = LafUtils.setupAntialias(graphics2D);
                int n3 = WebRadioButtonUI.this.iconWidth - WebRadioButtonUI.this.shadeWidth * 2 - 2;
                Rectangle rectangle = new Rectangle(n + WebRadioButtonUI.this.shadeWidth, n2 + WebRadioButtonUI.this.shadeWidth, WebRadioButtonUI.this.iconWidth - WebRadioButtonUI.this.shadeWidth * 2 - 1, WebRadioButtonUI.this.iconHeight - WebRadioButtonUI.this.shadeWidth * 2 - 1);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n3, n3);
                if (component.isEnabled()) {
                    LafUtils.drawShade(graphics2D, double_, component.isEnabled() && component.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, WebRadioButtonUI.this.shadeWidth);
                }
                int n4 = Math.round((float)Math.sqrt(rectangle.width * rectangle.width / 2));
                graphics2D.setPaint(new RadialGradientPaint(rectangle.x + rectangle.width / 2, (float)(rectangle.y + rectangle.height / 2), n4, new float[]{0.0f, 1.0f}, WebRadioButtonUI.this.getBgColors(jRadioButton)));
                graphics2D.fill(double_);
                Stroke stroke = LafUtils.setupStroke(graphics2D, WebRadioButtonUI.this.borderStroke);
                graphics2D.setPaint(component.isEnabled() ? (WebRadioButtonUI.this.rolloverDarkBorderOnly ? ColorUtils.getIntermediateColor(WebRadioButtonUI.this.borderColor, WebRadioButtonUI.this.darkBorderColor, WebRadioButtonUI.this.getProgress()) : WebRadioButtonUI.this.darkBorderColor) : WebRadioButtonUI.this.disabledBorderColor);
                graphics2D.draw(double_);
                LafUtils.restoreStroke(graphics2D, stroke);
                if (WebRadioButtonUI.this.checkIcon > 0) {
                    ImageIcon imageIcon = jRadioButton.isEnabled() ? CHECK_STATES.get(WebRadioButtonUI.this.checkIcon) : DISABLED_CHECK;
                    graphics2D.drawImage(imageIcon.getImage(), n + WebRadioButtonUI.this.iconWidth / 2 - imageIcon.getIconWidth() / 2, n2 + WebRadioButtonUI.this.iconHeight / 2 - imageIcon.getIconHeight() / 2, jRadioButton);
                }
                LafUtils.restoreAntialias(graphics2D, object);
            }

            @Override
            public int getIconWidth() {
                return WebRadioButtonUI.this.iconWidth;
            }

            @Override
            public int getIconHeight() {
                return WebRadioButtonUI.this.iconHeight;
            }
        });
    }

    private Color[] getBgColors(JRadioButton jRadioButton) {
        if (jRadioButton.isEnabled()) {
            float f = this.getProgress();
            if (f < 1.0f) {
                return new Color[]{ColorUtils.getIntermediateColor(this.topBgColor, this.topSelectedBgColor, f), ColorUtils.getIntermediateColor(this.bottomBgColor, this.bottomSelectedBgColor, f)};
            }
            return new Color[]{this.topSelectedBgColor, this.bottomSelectedBgColor};
        }
        return new Color[]{this.topBgColor, this.bottomBgColor};
    }

    private float getProgress() {
        return (float)this.bgDarkness / 5.0f;
    }

    public Rectangle getIconRect() {
        return this.iconRect != null ? new Rectangle(this.iconRect) : new Rectangle();
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent);
        super.paint(graphics, jComponent);
        SwingUtils.restoreTextAntialias(graphics, map);
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtils.getFontMetrics(jComponent, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    static {
        CHECK_STATES.add(StyleConstants.EMPTY_ICON);
        for (int i = 1; i <= 3; ++i) {
            CHECK_STATES.add(new ImageIcon(WebRadioButtonUI.class.getResource("icons/c" + i + ".png")));
        }
        DISABLED_CHECK = ImageUtils.getDisabledCopy("WebRadioButton.disabled.check", CHECK_STATES.get(CHECK_STATES.size() - 1));
    }
}

