/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.table.WebTableUI;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WebTable
extends JTable {
    private boolean editable = true;
    private int visibleRowCount = -1;

    public WebTable() {
    }

    public WebTable(TableModel tableModel) {
        super(tableModel);
    }

    public WebTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public WebTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public WebTable(int n, int n2) {
        super(n, n2);
    }

    public WebTable(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public WebTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editable && super.isCellEditable(n, n2);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
        this.setPreferredScrollableViewportSize(null);
        JScrollPane jScrollPane = SwingUtils.getScrollPane(this);
        if (jScrollPane != null) {
            jScrollPane.getViewport().invalidate();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredViewportSize != null) {
            return this.preferredViewportSize;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.visibleRowCount != -1) {
            int n;
            if (this.getRowCount() > 0) {
                Rectangle rectangle = this.getCellRect(0, 0, true);
                n = rectangle.height;
            } else {
                n = this.getRowHeight();
            }
            dimension.height = this.visibleRowCount * n;
        }
        return dimension;
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setPreferredScrollableViewportSize(null);
    }

    public WebTableUI getWebUI() {
        return (WebTableUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().updateUI();
        }
        this.configureEnclosingScrollPaneUI();
        if (this.getUI() == null || !(this.getUI() instanceof WebTableUI)) {
            try {
                this.setUI((WebTableUI)ReflectUtils.createInstance(WebLookAndFeel.tableUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebTableUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    private void configureEnclosingScrollPaneUI() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            Component component = jScrollPane.getCorner("UPPER_TRAILING_CORNER");
            if (component == null || component instanceof UIResource) {
                component = null;
                Object object = UIManager.get("Table.scrollPaneCornerComponent");
                if (object instanceof Class) {
                    try {
                        component = (Component)((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", component);
            }
        }
    }
}

