/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.text.WebPasswordFieldUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.collection.ValuesTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class TextComponentLayout
implements LayoutManager {
    public static final String LEADING = "LEADING";
    public static final String TRAILING = "TRAILING";
    private static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    private ValuesTable<Component, String> constraints = new ValuesTable();
    private JTextComponent textComponent;

    public TextComponentLayout(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null || !string.equals(LEADING) && !string.equals(TRAILING)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'LEADING' or 'TRAILING' string");
        }
        this.constraints.put(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = this.getInsets(container);
        Dimension dimension = this.constraints.containsValue(LEADING) ? this.constraints.getKey(LEADING).getPreferredSize() : new Dimension();
        Dimension dimension2 = this.constraints.containsValue(TRAILING) ? this.constraints.getKey(TRAILING).getPreferredSize() : new Dimension();
        return new Dimension(insets.left + dimension.width + dimension2.width + insets.right, insets.top + Math.max(dimension.height, dimension2.height) + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Component component;
        boolean bl = container.getComponentOrientation().isLeftToRight();
        Insets insets = this.getInsets(container);
        if (this.constraints.containsValue(LEADING)) {
            component = this.constraints.getKey(LEADING);
            n = component.getPreferredSize().width;
            if (bl) {
                component.setBounds(insets.left - n, insets.top, n, container.getHeight() - insets.top - insets.bottom);
            } else {
                component.setBounds(container.getWidth() - insets.right, insets.top, n, container.getHeight() - insets.top - insets.bottom);
            }
        }
        if (this.constraints.containsValue(TRAILING)) {
            component = this.constraints.getKey(TRAILING);
            n = component.getPreferredSize().width;
            if (bl) {
                component.setBounds(container.getWidth() - insets.right, insets.top, n, container.getHeight() - insets.top - insets.bottom);
            } else {
                component.setBounds(insets.left - n, insets.top, n, container.getHeight() - insets.top - insets.bottom);
            }
        }
    }

    private Insets getInsets(Container container) {
        Insets insets = container.getInsets();
        Insets insets2 = this.getFieldMargin();
        boolean bl = container.getComponentOrientation().isLeftToRight();
        return new Insets(insets.top - insets2.top, insets.left - (bl ? insets2.left : insets2.right), insets.bottom - insets2.bottom, insets.right - (bl ? insets2.right : insets2.left));
    }

    private Insets getFieldMargin() {
        TextUI textUI = this.textComponent.getUI();
        if (textUI instanceof WebTextFieldUI) {
            return ((WebTextFieldUI)textUI).getFieldMargin();
        }
        if (textUI instanceof WebPasswordFieldUI) {
            return ((WebPasswordFieldUI)textUI).getFieldMargin();
        }
        return emptyInsets;
    }
}

