/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.effects;

import com.alee.extended.window.TestFrame;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class EffectsManager {
    public static void fadeOut(JComponent jComponent) {
        final BufferedImage bufferedImage = SwingUtils.createComponentSnapshot(jComponent);
        final Rectangle rectangle = SwingUtils.getBoundsInWindow(jComponent);
        final WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(jComponent);
        webGlassPane.setPaintedImage(100, bufferedImage, rectangle.getLocation());
        jComponent.setVisible(false);
        final Timer timer = new Timer("EffectsManager.fadeOut", (long)StyleConstants.avgAnimationDelay);
        timer.addActionListener(new ActionListener(){
            private int opacity = 100;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.opacity > 0) {
                    this.opacity -= 5;
                    Point point = rectangle.getLocation();
                    point.y += (100 - this.opacity) / 2;
                    webGlassPane.setPaintedImage(this.opacity, bufferedImage, point);
                } else {
                    webGlassPane.clearPaintedImage();
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    public static void main(String[] stringArray) {
        WebLookAndFeel.install();
        final WebButton webButton = new WebButton("1");
        webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EffectsManager.fadeOut(webButton);
            }
        });
        final WebButton webButton2 = new WebButton("2");
        webButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EffectsManager.fadeOut(webButton2);
            }
        });
        final WebButton webButton3 = new WebButton("3");
        webButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EffectsManager.fadeOut(webButton3);
            }
        });
        new TestFrame((Component)new WebToolBar(){
            {
                this.setFloatable(false);
                this.add((Component)webButton);
                this.add((Component)webButton2);
                this.add((Component)webButton3);
            }
        }, 50);
    }
}

