/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.glasspane;

import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;

public class GlassPaneManager {
    private static Map<Window, WebGlassPane> registeredWindows = new HashMap<Window, WebGlassPane>();

    public static WebGlassPane getGlassPane(Component component) {
        return GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component));
    }

    public static WebGlassPane getGlassPane(Window window) {
        if (window != null) {
            if (registeredWindows.containsKey(window)) {
                return registeredWindows.get(window);
            }
            if (window instanceof JFrame) {
                GlassPaneManager.registerWindow((JFrame)window);
            } else if (window instanceof JDialog) {
                GlassPaneManager.registerWindow((JDialog)window);
            } else if (window instanceof JWindow) {
                GlassPaneManager.registerWindow((JWindow)window);
            } else {
                return null;
            }
            return GlassPaneManager.getGlassPane(window);
        }
        return null;
    }

    public static void registerWindow(JFrame jFrame) {
        if (!registeredWindows.containsKey(jFrame)) {
            WebGlassPane webGlassPane = GlassPaneManager.createGlassPane(jFrame);
            jFrame.setGlassPane(webGlassPane);
            webGlassPane.setVisible(true);
            jFrame.invalidate();
            registeredWindows.put(jFrame, webGlassPane);
        }
    }

    public static void registerWindow(JDialog jDialog) {
        if (!registeredWindows.containsKey(jDialog)) {
            WebGlassPane webGlassPane = GlassPaneManager.createGlassPane(jDialog);
            jDialog.setGlassPane(webGlassPane);
            webGlassPane.setVisible(true);
            jDialog.invalidate();
            registeredWindows.put(jDialog, webGlassPane);
        }
    }

    public static void registerWindow(JWindow jWindow) {
        if (!registeredWindows.containsKey(jWindow)) {
            WebGlassPane webGlassPane = GlassPaneManager.createGlassPane(jWindow);
            jWindow.setGlassPane(webGlassPane);
            webGlassPane.setVisible(true);
            jWindow.invalidate();
            registeredWindows.put(jWindow, webGlassPane);
        }
    }

    private static WebGlassPane createGlassPane(Window window) {
        return new WebGlassPane(window);
    }
}

