/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.ComponentSettingsManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.ReadState;
import com.alee.managers.settings.SettingsGroup;
import com.alee.managers.settings.SettingsGroupState;
import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsManager {
    private static Map<String, Map<String, List<SettingsListener>>> settingsListeners = new HashMap<String, Map<String, List<SettingsListener>>>();
    private static String settingsFilesExtension = ".xml";
    private static String backupFilesExtension = ".backup";
    private static String defaultSettingsDir = null;
    private static String defaultSettingsDirName = ".weblaf";
    private static String defaultSettingsGroup = "default";
    private static Map<String, String> groupFileLocation = new HashMap<String, String>();
    private static Map<String, SettingsGroupState> groupState = new HashMap<String, SettingsGroupState>();
    private static Map<String, SettingsGroup> groups = new HashMap<String, SettingsGroup>();
    private static Map<String, Object> files = new HashMap<String, Object>();
    private static boolean saveOnChange = true;
    private static final Object saveOnChangeLock = new Object();
    private static long saveOnChangeDelay = 1000L;
    private static Timer groupSaveScheduler = null;
    private static List<String> groupsToSaveOnChange = new ArrayList<String>();
    private static boolean displayErrors = true;
    private static boolean allowSave = true;
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(SettingsGroup.class);
            XmlUtils.processAnnotations(SettingsGroupState.class);
            XmlUtils.processAnnotations(ReadState.class);
            ComponentSettingsManager.initializeManager();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    SettingsManager.saveSettings();
                }
            }));
        }
    }

    public static List<SettingsGroup> getLoadedGroups() {
        return CollectionUtils.copy(groups.values());
    }

    public static Map<String, SettingsGroup> getLoadedGroupsMap() {
        return groups;
    }

    public static void registerComponent(Component component, String string) {
        SettingsManager.registerComponent(component, string, null);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String string, Class<T> clazz) {
        SettingsManager.registerComponent(component, string, SettingsManager.getDefaultValue(clazz));
    }

    public static void registerComponent(Component component, String string, Object object) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, string, object);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String string, String string2, Class<T> clazz) {
        SettingsManager.registerComponent(component, string, string2, SettingsManager.getDefaultValue(clazz));
    }

    public static void registerComponent(Component component, String string, String string2, Object object) {
        SettingsManager.registerComponent(component, string, string2, object, true, true);
    }

    public static void registerComponent(Component component, String string, boolean bl, boolean bl2) {
        SettingsManager.registerComponent(component, string, null, bl, bl2);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String string, Class<T> clazz, boolean bl, boolean bl2) {
        SettingsManager.registerComponent(component, string, SettingsManager.getDefaultValue(clazz), bl, bl2);
    }

    public static void registerComponent(Component component, String string, Object object, boolean bl, boolean bl2) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, string, object, bl, bl2);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String string, String string2, Class<T> clazz, boolean bl, boolean bl2) {
        SettingsManager.registerComponent(component, string, string2, SettingsManager.getDefaultValue(clazz), bl, bl2);
    }

    public static void registerComponent(Component component, String string, String string2, Object object, boolean bl, boolean bl2) {
        ComponentSettingsManager.registerComponent(new SettingsProcessorData(component, string, string2, object, bl, bl2));
    }

    public static void loadComponentSettings(Component component) {
        ComponentSettingsManager.loadSettings(component);
    }

    public static void saveComponentSettings(Component component) {
        ComponentSettingsManager.saveSettings(component);
    }

    public static void unregisterComponent(Component component) {
        ComponentSettingsManager.unregisterComponent(component);
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class clazz, Class<T> clazz2) {
        ComponentSettingsManager.registerSettingsProcessor(clazz, clazz2);
    }

    public static Boolean getBoolean(Object object) {
        return SettingsManager.get(object, (Boolean)null);
    }

    public static Boolean getBoolean(String string, Object object) {
        return SettingsManager.get(string, object, (Boolean)null);
    }

    public static String getString(Object object) {
        return SettingsManager.get(object, (String)null);
    }

    public static String getString(String string, Object object) {
        return SettingsManager.get(string, object, (String)null);
    }

    public static Integer getInteger(Object object) {
        return SettingsManager.get(object, (Integer)null);
    }

    public static Integer getInteger(String string, Object object) {
        return SettingsManager.get(string, object, (Integer)null);
    }

    public static Long getLong(Object object) {
        return SettingsManager.get(object, (Long)null);
    }

    public static Long getLong(String string, Object object) {
        return SettingsManager.get(string, object, (Long)null);
    }

    public static Float getFloat(Object object) {
        return SettingsManager.get(object, (Float)null);
    }

    public static Float getFloat(String string, Object object) {
        return SettingsManager.get(string, object, (Float)null);
    }

    public static Double getDouble(Object object) {
        return SettingsManager.get(object, (Double)null);
    }

    public static Double getDouble(String string, Object object) {
        return SettingsManager.get(string, object, (Double)null);
    }

    public static Dimension getDimension(Object object) {
        return SettingsManager.get(object, (Dimension)null);
    }

    public static Dimension getDimension(String string, Object object) {
        return SettingsManager.get(string, object, (Dimension)null);
    }

    public static Point getPoint(Object object) {
        return SettingsManager.get(object, (Point)null);
    }

    public static Point getPoint(String string, Object object) {
        return SettingsManager.get(string, object, (Point)null);
    }

    public static Color getColor(Object object) {
        return SettingsManager.get(object, (Color)null);
    }

    public static Color getColor(String string, Object object) {
        return SettingsManager.get(string, object, (Color)null);
    }

    public static Rectangle getRectangle(Object object) {
        return SettingsManager.get(object, (Rectangle)null);
    }

    public static Rectangle getRectangle(String string, Object object) {
        return SettingsManager.get(string, object, (Rectangle)null);
    }

    public static Insets getInsets(Object object) {
        return SettingsManager.get(object, (Insets)null);
    }

    public static Insets getInsets(String string, Object object) {
        return SettingsManager.get(string, object, (Insets)null);
    }

    public static Object get(Object object) {
        return SettingsManager.get(object, (Object)null);
    }

    public static <T extends DefaultValue> T get(Object object, Class<T> clazz) {
        return (T)((DefaultValue)SettingsManager.get(defaultSettingsGroup, object, SettingsManager.getDefaultValue(clazz)));
    }

    public static <T> T get(Object object, T t) {
        return SettingsManager.get(defaultSettingsGroup, object, t);
    }

    public static <T extends DefaultValue> T get(String string, Object object, Class<T> clazz) {
        return (T)((DefaultValue)SettingsManager.get(defaultSettingsGroup, object, SettingsManager.getDefaultValue(clazz)));
    }

    public static <T> T get(String string, Object object, T t) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(string);
        Object object2 = settingsGroup.get(object != null ? object.toString() : null);
        return (T)(object2 == null && t != null ? t : object2);
    }

    public static <T extends DefaultValue> T getDefaultValue(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return (T)((DefaultValue)ReflectUtils.callStaticMethodSafely(clazz, "getDefaultValue", new Object[0]));
    }

    public static <T> T set(String string, T t) {
        return SettingsManager.set(defaultSettingsGroup, string, t);
    }

    public static <T> T set(String string, String string2, T t) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(string);
        T t2 = settingsGroup.put(string2, t);
        if (saveOnChange) {
            SettingsManager.delayedSaveSettingsGroup(string);
        }
        SettingsManager.fireSettingsChanged(string, string2, t);
        return t2;
    }

    public static SettingsGroup getSettingsGroup(String string) {
        if (groups.containsKey(string)) {
            return groups.get(string);
        }
        return SettingsManager.loadSettingsGroup(string);
    }

    private static SettingsGroup loadSettingsGroup(String string) {
        SettingsGroup settingsGroup = null;
        File file = new File(SettingsManager.getGroupFileLocation(string));
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, string + settingsFilesExtension);
            File file3 = new File(file, file2.getName() + backupFilesExtension);
            if (file2.exists() && file2.isFile() || file3.exists() && file3.isFile()) {
                boolean bl = false;
                if (file3.exists() && file3.isFile()) {
                    FileUtils.copyFile(file3, file2);
                    FileUtils.deleteFile(file3);
                    bl = true;
                }
                if (file2.exists() && file2.isFile()) {
                    try {
                        settingsGroup = (SettingsGroup)XmlUtils.fromXML(file2);
                        groupState.put(string, new SettingsGroupState(bl ? ReadState.restored : ReadState.ok));
                    }
                    catch (Throwable throwable) {
                        if (displayErrors) {
                            throwable.printStackTrace();
                        }
                        FileUtils.deleteFile(file2);
                        groupState.put(string, new SettingsGroupState(ReadState.failed, throwable));
                    }
                }
            } else {
                groupState.put(string, new SettingsGroupState(ReadState.created));
            }
        } else {
            groupState.put(string, new SettingsGroupState(ReadState.created));
        }
        if (settingsGroup == null) {
            settingsGroup = new SettingsGroup(string);
        }
        groups.put(string, settingsGroup);
        return settingsGroup;
    }

    public static void saveSettings() {
        for (Map.Entry<String, SettingsGroup> entry : groups.entrySet()) {
            SettingsManager.saveSettingsGroup(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : files.entrySet()) {
            SettingsManager.saveSettings(entry.getKey(), entry.getValue());
        }
    }

    public static void saveSettingsGroup(String string) {
        SettingsManager.saveSettingsGroup(SettingsManager.getSettingsGroup(string));
    }

    public static void saveSettingsGroup(SettingsGroup settingsGroup) {
        block6: {
            if (allowSave) {
                try {
                    String string = settingsGroup.getName();
                    File file = new File(SettingsManager.getGroupFileLocation(string));
                    if (FileUtils.ensureDirectoryExists(file)) {
                        File file2 = new File(file, string + settingsFilesExtension);
                        File file3 = null;
                        if (file2.exists()) {
                            file3 = new File(file, string + settingsFilesExtension + backupFilesExtension);
                            FileUtils.copyFile(file2, file3);
                        }
                        XmlUtils.toXML((Object)settingsGroup, file2);
                        if (file3 != null && file3.exists()) {
                            FileUtils.deleteFile(file3);
                        }
                        break block6;
                    }
                    throw new RuntimeException("Cannot create settings directory: " + file.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    if (!displayErrors) break block6;
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayedSaveSettingsGroup(String string) {
        if (saveOnChangeDelay > 0L) {
            Object object = saveOnChangeLock;
            synchronized (object) {
                if (!groupsToSaveOnChange.contains(string)) {
                    groupsToSaveOnChange.add(string);
                }
                if (groupSaveScheduler == null || !groupSaveScheduler.isRunning()) {
                    if (groupSaveScheduler == null) {
                        groupSaveScheduler = new Timer("SettingsManager.groupSaveScheduler", saveOnChangeDelay, new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Object object = saveOnChangeLock;
                                synchronized (object) {
                                    for (String string : groupsToSaveOnChange) {
                                        SettingsManager.saveSettingsGroup(string);
                                    }
                                    groupsToSaveOnChange.clear();
                                }
                            }
                        });
                        groupSaveScheduler.setRepeats(false);
                    } else {
                        groupSaveScheduler.setDelay(saveOnChangeDelay);
                    }
                    groupSaveScheduler.start();
                }
            }
        } else {
            SettingsManager.saveSettingsGroup(string);
        }
    }

    public SettingsGroupState getSettingsGroupState(String string) {
        if (!groupState.containsKey(string)) {
            groupState.put(string, new SettingsGroupState(ReadState.none));
        }
        return groupState.get(string);
    }

    public static Object getSettings(String string) {
        return SettingsManager.getSettings(string, null);
    }

    public static <T> T getSettings(String string, T t) {
        Object object;
        if (files.containsKey(string)) {
            return (T)files.get(string);
        }
        try {
            object = XmlUtils.fromXML(SettingsManager.getSettingsFile(string));
        }
        catch (Throwable throwable) {
            object = t;
        }
        files.put(string, object);
        return (T)object;
    }

    public static void setSettings(String string, Object object) {
        files.put(string, object);
        if (saveOnChange) {
            SettingsManager.saveSettings(string, object);
        }
    }

    private static void saveSettings(String string, Object object) {
        if (allowSave) {
            XmlUtils.toXML(object, SettingsManager.getSettingsFile(string));
        }
    }

    public static boolean settingsExists(String string) {
        return SettingsManager.getSettingsFile(string).exists();
    }

    private static File getSettingsFile(String string) {
        return new File(SettingsManager.getDefaultSettingsDir(), string);
    }

    public static String getSettingsFilesExtension() {
        return settingsFilesExtension;
    }

    public static void setSettingsFilesExtension(String string) {
        settingsFilesExtension = string;
    }

    public static String getBackupFilesExtension() {
        return backupFilesExtension;
    }

    public static void setBackupFilesExtension(String string) {
        backupFilesExtension = string;
    }

    public static String getDefaultSettingsDir() {
        if (defaultSettingsDir == null) {
            return FileUtils.getUserHomePath() + defaultSettingsDirName;
        }
        return defaultSettingsDir;
    }

    public static void setDefaultSettingsDir(String string) {
        defaultSettingsDir = string;
    }

    public static String getDefaultSettingsDirName() {
        return defaultSettingsDirName;
    }

    public static void setDefaultSettingsDirName(String string) {
        defaultSettingsDirName = string;
    }

    public static String getDefaultSettingsGroup() {
        return defaultSettingsGroup;
    }

    public static void setDefaultSettingsGroup(String string) {
        defaultSettingsGroup = string;
    }

    public static void setGroupFileLocation(String string, String string2) {
        groupFileLocation.put(string, string2);
    }

    public static String getGroupFileLocation(String string) {
        if (groupFileLocation.containsKey(string)) {
            return groupFileLocation.get(string);
        }
        return SettingsManager.getDefaultSettingsDir();
    }

    public static boolean isSaveOnChange() {
        return saveOnChange;
    }

    public static void setSaveOnChange(boolean bl) {
        saveOnChange = bl;
    }

    public static long getSaveOnChangeDelay() {
        return saveOnChangeDelay;
    }

    public static void setSaveOnChangeDelay(long l) {
        saveOnChangeDelay = l;
    }

    public static boolean isDisplayErrors() {
        return displayErrors;
    }

    public static void setDisplayErrors(boolean bl) {
        displayErrors = bl;
    }

    public static boolean isAllowSave() {
        return allowSave;
    }

    public static void setAllowSave(boolean bl) {
        allowSave = bl;
    }

    public static void disableSave() {
        SettingsManager.setAllowSave(false);
    }

    public static void enableSave() {
        SettingsManager.setAllowSave(true);
    }

    public static void addSettingsListener(String string, SettingsListener settingsListener) {
        SettingsManager.addSettingsListener(SettingsManager.getDefaultSettingsGroup(), string, settingsListener);
    }

    public static void addSettingsListener(String string, String string2, SettingsListener settingsListener) {
        if (!settingsListeners.containsKey(string)) {
            settingsListeners.put(string, new HashMap());
        }
        if (!settingsListeners.get(string).containsKey(string2)) {
            settingsListeners.get(string).put(string2, new ArrayList());
        }
        settingsListeners.get(string).get(string2).add(settingsListener);
    }

    public static void removeSettingsListener(String string, SettingsListener settingsListener) {
        SettingsManager.removeSettingsListener(SettingsManager.getDefaultSettingsGroup(), string, settingsListener);
    }

    public static void removeSettingsListener(String string, String string2, SettingsListener settingsListener) {
        if (settingsListeners.containsKey(string) && settingsListeners.get(string).containsKey(string2)) {
            settingsListeners.get(string).get(string2).remove(settingsListener);
        }
    }

    private static void fireSettingsChanged(String string, String string2, Object object) {
        if (settingsListeners.containsKey(string) && settingsListeners.get(string).containsKey(string2)) {
            for (SettingsListener settingsListener : CollectionUtils.copy((Collection)settingsListeners.get(string).get(string2))) {
                settingsListener.settingsChanged(string, string2, object);
            }
        }
    }
}

