/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.Component;
import java.io.Serializable;

public abstract class SettingsProcessor<C extends Component, V extends Serializable> {
    protected boolean loading = false;
    protected boolean saving = false;
    protected SettingsProcessorData data;

    public SettingsProcessor(SettingsProcessorData settingsProcessorData) {
        this.data = settingsProcessorData;
        if (settingsProcessorData.isLoadInitialSettings()) {
            this.load();
        }
        this.doInit(this.getComponent());
        if (settingsProcessorData.isApplySettingsChanges()) {
            SettingsManager.addSettingsListener(this.getGroup(), this.getKey(), new SettingsListener(){

                @Override
                public void settingsChanged(String string, String string2, Object object) {
                    SettingsProcessor.this.load();
                }
            });
        }
    }

    public SettingsProcessorData getData() {
        return this.data;
    }

    public C getComponent() {
        return (C)this.data.getComponent();
    }

    public String getGroup() {
        return this.data.getGroup();
    }

    public String getKey() {
        return this.data.getKey();
    }

    public V getDefaultValue() {
        return (V)((Serializable)this.data.getDefaultValue());
    }

    public final void load() {
        if (this.loading || this.saving) {
            return;
        }
        this.loading = true;
        this.doLoad(this.getComponent());
        this.loading = false;
    }

    public final void save() {
        if (this.loading || this.saving) {
            return;
        }
        this.saving = true;
        this.doSave(this.getComponent());
        this.saving = false;
    }

    public final void destroy() {
        this.doDestroy(this.getComponent());
        this.data = null;
    }

    protected V loadValue() {
        return (V)((Serializable)SettingsManager.get(this.getGroup(), (Object)this.getKey(), this.getDefaultValue()));
    }

    protected void saveValue(V v) {
        SettingsManager.set(this.getGroup(), this.getKey(), v);
    }

    protected abstract void doInit(C var1);

    protected abstract void doDestroy(C var1);

    protected abstract void doLoad(C var1);

    protected abstract void doSave(C var1);
}

