/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CompareUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WindowSettingsProcessor
extends SettingsProcessor<Window, Rectangle> {
    private ComponentAdapter componentAdapter;

    public WindowSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        super(settingsProcessorData);
    }

    @Override
    protected void doInit(Window window) {
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WindowSettingsProcessor.this.save();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                WindowSettingsProcessor.this.save();
            }
        };
        window.addComponentListener(this.componentAdapter);
    }

    @Override
    protected void doLoad(Window window) {
        Rectangle rectangle = (Rectangle)this.loadValue();
        if (rectangle == null) {
            window.pack();
            window.setLocationRelativeTo(null);
        } else if (CompareUtils.equals(rectangle, window.getBounds())) {
            Dimension dimension = rectangle.getSize();
            if (dimension.width > 0 && dimension.height > 0) {
                window.setSize(dimension);
            } else {
                window.pack();
            }
            Point point = rectangle.getLocation();
            if (point.x > 0 && point.y > 0) {
                window.setLocation(point);
            } else {
                window.setLocationRelativeTo(null);
            }
        }
    }

    @Override
    protected void doSave(Window window) {
        this.saveValue(window.getBounds());
    }

    @Override
    protected void doDestroy(Window window) {
        window.removeComponentListener(this.componentAdapter);
        this.componentAdapter = null;
    }
}

