/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class GeometryUtils {
    public static Rectangle getContainingRect(Point ... pointArray) {
        if (pointArray != null && pointArray.length > 0) {
            Rectangle rectangle = new Rectangle(pointArray[0], new Dimension(0, 0));
            for (int i = 1; i < pointArray.length; ++i) {
                int n;
                Point point = pointArray[i];
                if (point.x < rectangle.x) {
                    n = rectangle.x - point.x;
                    rectangle.x = point.x;
                    rectangle.width += n;
                } else if (rectangle.x + rectangle.width < point.x) {
                    rectangle.width = point.x - rectangle.x;
                }
                if (point.y < rectangle.y) {
                    n = rectangle.y - point.y;
                    rectangle.y = point.y;
                    rectangle.height += n;
                    continue;
                }
                if (rectangle.y + rectangle.height >= point.y) continue;
                rectangle.height = point.y - rectangle.y;
            }
            if (rectangle.width == 0) {
                rectangle.width = 1;
            }
            if (rectangle.height == 0) {
                rectangle.height = 1;
            }
            return rectangle;
        }
        return null;
    }

    public static Rectangle getContainingRect(Rectangle ... rectangleArray) {
        if (rectangleArray != null && rectangleArray.length > 0) {
            Rectangle rectangle = rectangleArray[0];
            for (int i = 1; i < rectangleArray.length; ++i) {
                rectangle = GeometryUtils.getContainingRect(rectangle, rectangleArray[i]);
            }
            return rectangle;
        }
        return null;
    }

    public static Rectangle getContainingRect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 != null) {
            return rectangle2;
        }
        if (rectangle2 == null && rectangle != null) {
            return rectangle;
        }
        if (rectangle == null && rectangle2 == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = Math.min(rectangle.x, rectangle2.x);
        int n2 = Math.min(rectangle.y, rectangle2.y);
        int n3 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n4 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static Rectangle validateRect(Rectangle rectangle) {
        if (rectangle.width >= 0 && rectangle.height >= 0) {
            return rectangle;
        }
        int n = rectangle.x;
        int n2 = Math.abs(rectangle.width);
        if (rectangle.width < 0) {
            n -= n2;
        }
        int n3 = rectangle.y;
        int n4 = Math.abs(rectangle.height);
        if (rectangle.height < 0) {
            n3 -= n4;
        }
        return new Rectangle(n, n3, n2, n4);
    }

    public static Point middle(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Point middle(Point point, Point point2) {
        return new Point((point.x + point2.x) / 2, (point.y + point2.y) / 2);
    }
}

