/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.FileUtils;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarEntryType;
import com.alee.utils.reflection.JarStructure;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ReflectUtils {
    public static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static JarStructure getJarStructure(Class clazz) {
        return ReflectUtils.getJarStructure(clazz, null, null);
    }

    public static JarStructure getJarStructure(Class clazz, List<String> list, List<String> list2) {
        return ReflectUtils.getJarStructure(clazz, list, list2, null);
    }

    public static JarStructure getJarStructure(Class clazz, List<String> list, List<String> list2, FileDownloadListener fileDownloadListener) {
        try {
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                ZipEntry zipEntry;
                URL uRL = codeSource.getLocation();
                URI uRI = uRL.toURI();
                String string = uRI.getScheme();
                File file = string != null && string.equalsIgnoreCase("file") ? new File(uRI) : FileUtils.downloadFile(uRL.toString(), File.createTempFile("jar_file", ".tmp"), fileDownloadListener);
                JarEntry jarEntry = new JarEntry(JarEntryType.jarEntry, file.getName());
                JarStructure jarStructure = new JarStructure(jarEntry);
                jarStructure.setJarLocation(file.getAbsolutePath());
                ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string2 = zipEntry.getName();
                    if (!ReflectUtils.isAllowedPackage(string2, list2) || !zipEntry.isDirectory() && !ReflectUtils.isAllowedExtension(string2, list)) continue;
                    ReflectUtils.parseElement(jarEntry, string2, zipEntry);
                }
                zipInputStream.close();
                return jarStructure;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return null;
    }

    private static boolean isAllowedExtension(String string, List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        String string2 = FileUtils.getFileExtPart(string, true).toLowerCase();
        return list.contains(string2);
    }

    private static boolean isAllowedPackage(String string, List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (String string2 : list) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static void parseElement(JarEntry jarEntry, String string, ZipEntry zipEntry) {
        String[] stringArray = string.split("/");
        JarEntry jarEntry2 = jarEntry;
        for (int i = 0; i < stringArray.length; ++i) {
            JarEntry jarEntry3;
            if (i < stringArray.length - 1) {
                jarEntry3 = jarEntry2.getChildByName(stringArray[i]);
                if (jarEntry3 == null) {
                    jarEntry3 = new JarEntry(JarEntryType.packageEntry, stringArray[i], jarEntry2);
                    jarEntry3.setZipEntry(zipEntry);
                    jarEntry2.addChild(jarEntry3);
                }
                jarEntry2 = jarEntry3;
                continue;
            }
            jarEntry3 = new JarEntry(ReflectUtils.getJarEntryType(stringArray[i]), stringArray[i], jarEntry2);
            jarEntry3.setZipEntry(zipEntry);
            jarEntry2.addChild(jarEntry3);
        }
    }

    private static JarEntryType getJarEntryType(String string) {
        String string2 = FileUtils.getFileExtPart(string, false);
        if (string2.equals("java")) {
            return JarEntryType.javaEntry;
        }
        if (string2.equals("class")) {
            return JarEntryType.classEntry;
        }
        if (!string2.isEmpty()) {
            return JarEntryType.fileEntry;
        }
        return JarEntryType.packageEntry;
    }

    public static Class getCallerClass() {
        try {
            return Class.forName(new Throwable().getStackTrace()[2].getClassName());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getJavaClassName(Object object) {
        return ReflectUtils.getJavaClassName(object.getClass());
    }

    public static String getJavaClassName(Class clazz) {
        return ReflectUtils.getClassName(clazz) + ".java";
    }

    public static String getClassName(Object object) {
        return ReflectUtils.getClassName(object.getClass());
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getCanonicalName();
        String string2 = string != null ? string : clazz.toString();
        int n = string2.lastIndexOf(".");
        return n != -1 ? string2.substring(n + 1) : string2;
    }

    public static String getClassFileName(Object object) {
        return ReflectUtils.getClassFileName(object.getClass());
    }

    public static String getClassFileName(Class clazz) {
        return ReflectUtils.getClassName(clazz) + ".class";
    }

    public static String[] getClassPackages(Object object) {
        return ReflectUtils.getClassPackages(object.getClass());
    }

    public static String[] getClassPackages(Class clazz) {
        return ReflectUtils.getPackages(clazz.getPackage().getName());
    }

    public static String[] getPackages(String string) {
        return string.split("\\.");
    }

    public static Object createInstanceSafely(String string, Object ... objectArray) {
        try {
            return ReflectUtils.createInstance(string, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object createInstance(String string, Object ... objectArray) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        return ReflectUtils.createInstance(ReflectUtils.loadClass(string), objectArray);
    }

    public static Object createInstanceSafely(Class clazz, Object ... objectArray) {
        try {
            return ReflectUtils.createInstance(clazz, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object createInstance(Class clazz, Object ... objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] classArray = ReflectUtils.getClassTypes(objectArray);
        Constructor constructor = ReflectUtils.getConstructor(clazz, classArray);
        return constructor.newInstance(objectArray);
    }

    public static Constructor getConstructor(Class clazz, Class ... classArray) throws NoSuchMethodException {
        if (classArray.length == 0) {
            return clazz.getConstructor(new Class[0]);
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classArray2 = constructor.getParameterTypes();
            if (classArray2.length != classArray.length) continue;
            if (classArray2.length == classArray.length && classArray2.length == 0) {
                return constructor;
            }
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (ReflectUtils.isAssignable(classArray2[i], classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return constructor;
        }
        throw new NoSuchMethodException(clazz.getName() + ReflectUtils.argumentTypesToString(classArray));
    }

    public static Object callStaticMethodSafely(String string, String string2, Object ... objectArray) {
        try {
            return ReflectUtils.callStaticMethod(ReflectUtils.loadClass(string), string2, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object callStaticMethod(String string, String string2, Object ... objectArray) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return ReflectUtils.callStaticMethod(ReflectUtils.loadClass(string), string2, objectArray);
    }

    public static Object callStaticMethodSafely(Class clazz, String string, Object ... objectArray) {
        try {
            return ReflectUtils.callStaticMethod(clazz, string, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object callStaticMethod(Class clazz, String string, Object ... objectArray) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method[] methodArray;
        if (objectArray.length == 0) {
            return clazz.getMethod(string, new Class[0]).invoke(null, new Object[0]);
        }
        Class[] classArray = ReflectUtils.getClassTypes(objectArray);
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] classArray2;
            if (!method.getName().equals(string) || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (ReflectUtils.isAssignable(classArray2[i], classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return method.invoke(null, objectArray);
        }
        throw new NoSuchMethodException(clazz.getName() + "." + string + ReflectUtils.argumentTypesToString(classArray));
    }

    public static List callMethodSafely(List list, String string, Object ... objectArray) {
        try {
            return ReflectUtils.callMethod(list, string, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List callMethod(List list, String string, Object ... objectArray) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            arrayList.add(ReflectUtils.callMethod(e, string, objectArray));
        }
        return arrayList;
    }

    public static Object[] callMethodSafely(Object[] objectArray, String string, Object ... objectArray2) {
        try {
            return ReflectUtils.callMethod(objectArray, string, objectArray2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object[] callMethod(Object[] objectArray, String string, Object ... objectArray2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray3[i] = ReflectUtils.callMethod(objectArray[i], string, objectArray2);
        }
        return objectArray3;
    }

    public static Object callMethodSafely(Object object, String string, Object ... objectArray) {
        try {
            return ReflectUtils.callMethod(object, string, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object callMethod(Object object, String string, Object ... objectArray) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method[] methodArray;
        if (objectArray.length == 0) {
            return object.getClass().getMethod(string, new Class[0]).invoke(object, new Object[0]);
        }
        Class[] classArray = ReflectUtils.getClassTypes(objectArray);
        for (Method method : methodArray = object.getClass().getMethods()) {
            Class<?>[] classArray2;
            if (!method.getName().equals(string) || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (ReflectUtils.isAssignable(classArray2[i], classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return method.invoke(object, objectArray);
        }
        throw new NoSuchMethodException(object.getClass().getName() + "." + string + ReflectUtils.argumentTypesToString(classArray));
    }

    private static String argumentTypesToString(Class[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((clazz = classArray[i]) == null ? "null" : clazz.getName());
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        return ReflectUtils.class.getClassLoader().loadClass(string);
    }

    public static Class[] getClassTypes(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class.isAssignableFrom(clazz2);
        }
        if (clazz == Integer.TYPE) {
            return Integer.class.isAssignableFrom(clazz2);
        }
        if (clazz == Float.TYPE) {
            return Float.class.isAssignableFrom(clazz2);
        }
        if (clazz == Double.TYPE) {
            return Double.class.isAssignableFrom(clazz2);
        }
        if (clazz == Character.TYPE) {
            return Character.class.isAssignableFrom(clazz2);
        }
        if (clazz == Byte.TYPE) {
            return Byte.class.isAssignableFrom(clazz2);
        }
        return false;
    }
}

