/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.utils.ImageUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NinePatchIcon
implements Icon {
    private Component component;
    private BufferedImage image;
    private List<NinePatchInterval> horizontalStretch;
    private List<NinePatchInterval> verticalStretch;
    private Insets margin;
    private Integer cachedWidth0;
    private Integer cachedWidth1;
    private Integer cachedHeight0;
    private Integer cachedHeight1;

    public NinePatchIcon(URL uRL) {
        this(uRL, null);
    }

    public NinePatchIcon(URL uRL, Component component) {
        this(ImageUtils.getBufferedImage(uRL), component);
    }

    public NinePatchIcon(String string) {
        this(string, null);
    }

    public NinePatchIcon(String string, Component component) {
        this(ImageUtils.getBufferedImage(string), component);
    }

    public NinePatchIcon(ImageIcon imageIcon) {
        this(imageIcon, null);
    }

    public NinePatchIcon(ImageIcon imageIcon, Component component) {
        this(ImageUtils.getBufferedImage(imageIcon), component);
    }

    public NinePatchIcon(Image image) {
        this(image, null);
    }

    public NinePatchIcon(Image image, Component component) {
        this(ImageUtils.getBufferedImage(image), component);
    }

    public NinePatchIcon(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public NinePatchIcon(BufferedImage bufferedImage, Component component) {
        this(bufferedImage, component, false);
    }

    private NinePatchIcon(BufferedImage bufferedImage, Component component, boolean bl) {
        if (bl) {
            this.component = component;
            this.image = bufferedImage;
            this.horizontalStretch = new ArrayList<NinePatchInterval>();
            this.verticalStretch = new ArrayList<NinePatchInterval>();
        } else {
            if (bufferedImage.getWidth() < 3 || bufferedImage.getHeight() < 3) {
                throw new IllegalArgumentException("Buffered image must be atleast 3x3 pixels size");
            }
            this.component = component;
            int n = bufferedImage.getWidth() - 2;
            int n2 = bufferedImage.getHeight() - 2;
            this.image = ImageUtils.createCompatibleImage(bufferedImage, n, n2);
            Graphics2D graphics2D = this.image.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 1, 1, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1, null);
            graphics2D.dispose();
            this.horizontalStretch = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.horizontalStretch);
            this.verticalStretch = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.verticalStretch);
            if (this.horizontalStretch.size() <= 1 && (this.horizontalStretch.size() != 1 || this.horizontalStretch.get(0).isPixel()) || this.verticalStretch.size() <= 1 && (this.verticalStretch.size() != 1 || this.verticalStretch.get(0).isPixel())) {
                throw new IllegalArgumentException("There must be stretch constraints specified on image");
            }
            List<NinePatchInterval> list = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.verticalContent);
            List<NinePatchInterval> list2 = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.horizontalContent);
            int n3 = list.size() == 0 ? 0 : list.get(0).getStart();
            int n4 = list.size() == 0 ? 0 : this.image.getHeight() - list.get(0).getEnd() - 1;
            int n5 = list2.size() == 0 ? 0 : list2.get(0).getStart();
            int n6 = list2.size() == 0 ? 0 : this.image.getWidth() - list2.get(0).getEnd() - 1;
            this.margin = new Insets(n3, n5, n4, n6);
            this.calculateFixedPixelsWidth(true);
            this.calculateFixedPixelsWidth(false);
            this.calculateFixedPixelsHeight(true);
            this.calculateFixedPixelsHeight(false);
        }
    }

    public static NinePatchIcon create(BufferedImage bufferedImage) {
        return new NinePatchIcon(bufferedImage, null, true);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public List<NinePatchInterval> getHorizontalStretch() {
        return this.horizontalStretch;
    }

    public void setHorizontalStretch(List<NinePatchInterval> list) {
        this.horizontalStretch = list;
        this.clearCachedWidthData();
    }

    public void addHorizontalStretch(NinePatchInterval ninePatchInterval) {
        this.horizontalStretch.add(ninePatchInterval);
        this.clearCachedWidthData();
    }

    public List<NinePatchInterval> getVerticalStretch() {
        return this.verticalStretch;
    }

    public void setVerticalStretch(List<NinePatchInterval> list) {
        this.verticalStretch = list;
        this.clearCachedHeightData();
    }

    public void addVerticalStretch(NinePatchInterval ninePatchInterval) {
        this.verticalStretch.add(ninePatchInterval);
        this.clearCachedHeightData();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.paintIcon((Graphics2D)graphics, 0, 0, component.getWidth(), component.getHeight());
    }

    public void paintIcon(Graphics2D graphics2D, Rectangle rectangle) {
        this.paintIcon(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintIcon(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n3, this.getIconWidth());
        int n6 = Math.max(n4, this.getIconHeight());
        int n7 = this.getFixedPixelsWidth(false);
        int n8 = n5 - n7;
        int n9 = this.getFixedPixelsHeight(false);
        int n10 = n6 - n9;
        int n11 = n2;
        for (int i = 0; i < this.verticalStretch.size(); ++i) {
            int n12;
            NinePatchInterval ninePatchInterval = this.verticalStretch.get(i);
            NinePatchInterval ninePatchInterval2 = i > 0 ? this.verticalStretch.get(i - 1) : null;
            int n13 = ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1;
            if (ninePatchInterval.isPixel()) {
                n12 = n13;
            } else {
                float f = (float)n13 / (float)(this.image.getHeight() - n9);
                n12 = Math.round(f * (float)n10);
            }
            int n14 = n;
            for (int j = 0; j < this.horizontalStretch.size(); ++j) {
                int n15;
                NinePatchInterval ninePatchInterval3 = this.horizontalStretch.get(j);
                NinePatchInterval ninePatchInterval4 = j > 0 ? this.horizontalStretch.get(j - 1) : null;
                int n16 = ninePatchInterval3.getEnd() - ninePatchInterval3.getStart() + 1;
                if (ninePatchInterval3.isPixel()) {
                    n15 = n16;
                } else {
                    float f = (float)n16 / (float)(this.image.getWidth() - n7);
                    n15 = Math.round(f * (float)n8);
                }
                graphics2D.drawImage(this.image, n14, n11, n14 + n15, n11 + n12, ninePatchInterval3.getStart(), ninePatchInterval.getStart(), ninePatchInterval3.getStart() + n16, ninePatchInterval.getStart() + n13, null);
                n14 += n15;
            }
            n11 += n12;
        }
    }

    public int getFixedPixelsWidth(boolean bl) {
        if (bl) {
            if (this.cachedWidth0 == null) {
                this.cachedWidth0 = this.calculateFixedPixelsWidth(bl);
            }
            return this.cachedWidth0;
        }
        if (this.cachedWidth1 == null) {
            this.cachedWidth1 = this.calculateFixedPixelsWidth(bl);
        }
        return this.cachedWidth1;
    }

    private int calculateFixedPixelsWidth(boolean bl) {
        int n = this.image.getWidth();
        for (NinePatchInterval ninePatchInterval : this.horizontalStretch) {
            if (ninePatchInterval.isPixel()) continue;
            n -= ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1;
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int getFixedPixelsHeight(boolean bl) {
        if (bl) {
            if (this.cachedHeight0 == null) {
                this.cachedHeight0 = this.calculateFixedPixelsHeight(bl);
            }
            return this.cachedHeight0;
        }
        if (this.cachedHeight1 == null) {
            this.cachedHeight1 = this.calculateFixedPixelsHeight(bl);
        }
        return this.cachedHeight1;
    }

    private int calculateFixedPixelsHeight(boolean bl) {
        int n = this.image.getHeight();
        for (NinePatchInterval ninePatchInterval : this.verticalStretch) {
            if (ninePatchInterval.isPixel()) continue;
            n -= ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1;
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    private void clearCachedWidthData() {
        this.cachedWidth0 = null;
        this.cachedWidth1 = null;
    }

    private void clearCachedHeightData() {
        this.cachedHeight0 = null;
        this.cachedHeight1 = null;
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.component != null ? this.component.getWidth() : 0, this.getFixedPixelsWidth(true));
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.component != null ? this.component.getHeight() : 0, this.getFixedPixelsHeight(true));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getFixedPixelsWidth(true), this.getFixedPixelsHeight(true));
    }

    public Dimension getRealImageSize() {
        return new Dimension(this.getImage().getWidth(), this.getImage().getHeight());
    }
}

