/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nio;

import com.oracle.nio.BufferSecretsPermission;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.JavaNioAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BufferSecrets<A> {
    private static final JavaNioAccess javaNioAccess = SharedSecrets.getJavaNioAccess();
    private static final BufferSecrets<?> theBufferSecrets = new BufferSecrets();

    private BufferSecrets() {
    }

    public static <A> BufferSecrets<A> instance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BufferSecretsPermission("access"));
        }
        return theBufferSecrets;
    }

    public ByteBuffer newDirectByteBuffer(long l, int n, A a) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative capacity: " + n);
        }
        return javaNioAccess.newDirectByteBuffer(l, n, a);
    }

    public long address(Buffer buffer) {
        if (buffer instanceof DirectBuffer) {
            return ((DirectBuffer)((Object)buffer)).address();
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    public A attachment(Buffer buffer) {
        if (buffer instanceof DirectBuffer) {
            return (A)((DirectBuffer)((Object)buffer)).viewedBuffer();
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public void truncate(Buffer buffer) {
        javaNioAccess.truncate(buffer);
    }
}

