/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.ThreadMXBean;
import java.lang.management.ThreadInfo;
import sun.management.ManagementFactory;
import sun.management.VMManagement;

class ThreadImpl
implements ThreadMXBean {
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;
    private boolean allocatedMemoryEnabled;

    ThreadImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
        this.allocatedMemoryEnabled = this.jvm.isThreadAllocatedMemoryEnabled();
    }

    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    public boolean isThreadAllocatedMemorySupported() {
        return this.jvm.isThreadAllocatedMemorySupported();
    }

    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    public boolean isThreadAllocatedMemoryEnabled() {
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread allocated memory measurement is not supported");
        }
        return this.allocatedMemoryEnabled;
    }

    public long[] getAllThreadIds() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.getThreads();
        int n = threadArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    public ThreadInfo getThreadInfo(long l) {
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, 0);
        return threadInfoArray[0];
    }

    public ThreadInfo getThreadInfo(long l, int n) {
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, n);
        return threadInfoArray[0];
    }

    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    private void verifyThreadIds(long[] lArray) {
        if (lArray == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > 0L) continue;
            throw new IllegalArgumentException("Invalid thread ID parameter: " + lArray[i]);
        }
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        this.verifyThreadIds(lArray);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        ManagementFactory.checkMonitorAccess();
        ThreadInfo[] threadInfoArray = new ThreadInfo[lArray.length];
        if (n == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo1(lArray, -1, threadInfoArray);
        } else {
            ThreadImpl.getThreadInfo1(lArray, n, threadInfoArray);
        }
        return threadInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != bl) {
                if (bl) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(bl);
                this.contentionMonitoringEnabled = bl;
            }
        }
    }

    private boolean verifyCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    public long getCurrentThreadCpuTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return -1L;
    }

    public long getThreadCpuTime(long l) {
        long[] lArray = new long[]{l};
        long[] lArray2 = this.getThreadCpuTime(lArray);
        return lArray2[0];
    }

    private boolean verifyThreadCpuTime(long[] lArray) {
        this.verifyThreadIds(lArray);
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported()) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == Thread.currentThread().getId()) continue;
                throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
            }
        }
        return this.isThreadCpuTimeEnabled();
    }

    private long[] initialLongArray(int n, long l) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = l;
        }
        return lArray;
    }

    public long[] getThreadCpuTime(long[] lArray) {
        boolean bl = this.verifyThreadCpuTime(lArray);
        int n = lArray.length;
        long[] lArray2 = this.initialLongArray(n, -1L);
        if (bl) {
            if (n == 1) {
                long l = lArray[0];
                if (l == Thread.currentThread().getId()) {
                    l = 0L;
                }
                lArray2[0] = ThreadImpl.getThreadTotalCpuTime0(l);
            } else {
                ThreadImpl.getThreadTotalCpuTime1(lArray, lArray2);
            }
        }
        return lArray2;
    }

    public long getCurrentThreadUserTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return -1L;
    }

    public long getThreadUserTime(long l) {
        long[] lArray = new long[]{l};
        long[] lArray2 = this.getThreadUserTime(lArray);
        return lArray2[0];
    }

    public long[] getThreadUserTime(long[] lArray) {
        boolean bl = this.verifyThreadCpuTime(lArray);
        int n = lArray.length;
        long[] lArray2 = this.initialLongArray(n, -1L);
        if (bl) {
            if (n == 1) {
                long l = lArray[0];
                if (l == Thread.currentThread().getId()) {
                    l = 0L;
                }
                lArray2[0] = ThreadImpl.getThreadUserCpuTime0(l);
            } else {
                ThreadImpl.getThreadUserCpuTime1(lArray, lArray2);
            }
        }
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != bl) {
                ThreadImpl.setThreadCpuTimeEnabled0(bl);
                this.cpuTimeEnabled = bl;
            }
        }
    }

    public long getThreadAllocatedBytes(long l) {
        long[] lArray = new long[]{l};
        long[] lArray2 = this.getThreadAllocatedBytes(lArray);
        return lArray2[0];
    }

    private boolean verifyThreadAllocatedMemory(long[] lArray) {
        this.verifyThreadIds(lArray);
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread allocated memory measurement is not supported.");
        }
        return this.isThreadAllocatedMemoryEnabled();
    }

    public long[] getThreadAllocatedBytes(long[] lArray) {
        boolean bl = this.verifyThreadAllocatedMemory(lArray);
        long[] lArray2 = this.initialLongArray(lArray.length, -1L);
        if (bl) {
            ThreadImpl.getThreadAllocatedMemory1(lArray, lArray2);
        }
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadAllocatedMemoryEnabled(boolean bl) {
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread allocated memory measurement is not supported.");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.allocatedMemoryEnabled != bl) {
                ThreadImpl.setThreadAllocatedMemoryEnabled0(bl);
                this.allocatedMemoryEnabled = bl;
            }
        }
    }

    public long[] findMonitorDeadlockedThreads() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        ManagementFactory.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    public void resetPeakThreadCount() {
        ManagementFactory.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    public boolean isObjectMonitorUsageSupported() {
        return this.jvm.isObjectMonitorUsageSupported();
    }

    public boolean isSynchronizerUsageSupported() {
        return this.jvm.isSynchronizerUsageSupported();
    }

    private void verifyDumpThreads(boolean bl, boolean bl2) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        ManagementFactory.checkMonitorAccess();
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        this.verifyThreadIds(lArray);
        this.verifyDumpThreads(bl, bl2);
        return ThreadImpl.dumpThreads0(lArray, bl, bl2);
    }

    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        this.verifyDumpThreads(bl, bl2);
        return ThreadImpl.dumpThreads0(null, bl, bl2);
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo1(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native void getThreadTotalCpuTime1(long[] var0, long[] var1);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void getThreadUserCpuTime1(long[] var0, long[] var1);

    private static native void getThreadAllocatedMemory1(long[] var0, long[] var1);

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadAllocatedMemoryEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native Thread[] findDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native ThreadInfo[] dumpThreads0(long[] var0, boolean var1, boolean var2);

    private static native void resetContentionTimes0(long var0);
}

