/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.io.OutputStream;

class PlaceholderOutputStream
extends OutputStream {
    OutputStream wrapped;

    PlaceholderOutputStream(OutputStream outputStream) {
        this.wrapped = outputStream;
    }

    void setWrappedStream(OutputStream outputStream) {
        this.wrapped = outputStream;
    }

    boolean isWrapped() {
        return this.wrapped != null;
    }

    private void checkWrap() throws IOException {
        if (this.wrapped == null) {
            throw new IOException("response headers not sent yet");
        }
    }

    public void write(int n) throws IOException {
        this.checkWrap();
        this.wrapped.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.checkWrap();
        this.wrapped.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrap();
        this.wrapped.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.checkWrap();
        this.wrapped.flush();
    }

    public void close() throws IOException {
        this.checkWrap();
        this.wrapped.close();
    }
}

