/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import java.io.IOException;

final class UnknownExtension
extends HelloExtension {
    private final byte[] data;

    UnknownExtension(HandshakeInStream handshakeInStream, int n, ExtensionType extensionType) throws IOException {
        super(extensionType);
        this.data = new byte[n];
        if (n != 0) {
            handshakeInStream.read(this.data);
        }
    }

    int length() {
        return 4 + this.data.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putBytes16(this.data);
    }

    public String toString() {
        return "Unsupported extension " + this.type + ", data: " + Debug.toString(this.data);
    }
}

