/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import com.miui.home.launcher.upsidescene.data.FreeButtonInfo;
import com.miui.home.launcher.upsidescene.data.FreeStyleSerializer;
import java.io.IOException;
import miui.util.FileAccessable;

public abstract class Appearance {
    private static final String TAG = "FreeStyle.Appearance";
    public static final char PATH_SEPARATOR = '/';
    public static final int TYPE_NONE = 0;
    public static final int TYPE_STAGE_IMAGE = 1;
    public static final int TYPE_FREE_COMPONENT = 2;
    public static final String PREFIX_STAGE_IMAGES = "stage_images";
    public static final String PREFIX_SKINS = "skins";
    String mPath;

    private Appearance(String path) {
        this.mPath = path;
    }

    public abstract int getType();

    public static Appearance load(String path, float sceneScale) throws IOException {
        if (TextUtils.isEmpty(path)) {
            return new NoneAppearance();
        }
        int slashIndex = (path = path.replace('\\', '/')).indexOf(47);
        if (slashIndex == -1) {
            Log.e(TAG, "parse appearance path failed:not found /. path:" + path);
            return new NoneAppearance();
        }
        String prefix = path.substring(0, slashIndex);
        String name = path.substring(slashIndex + 1);
        if (prefix.equalsIgnoreCase(PREFIX_STAGE_IMAGES)) {
            return new StageImageAppearance(path, sceneScale);
        }
        if (prefix.equalsIgnoreCase(PREFIX_SKINS)) {
            return new FreeButtonAppearance(name, sceneScale);
        }
        Log.w(TAG, "unknown appearance path prefix. path:" + path);
        return new NoneAppearance();
    }

    public String toString() {
        return this.mPath;
    }

    /* synthetic */ Appearance(String string, Appearance appearance) {
        this(string);
    }

    public static class FreeButtonAppearance
    extends Appearance {
        FreeButtonInfo mFreeButton;

        public FreeButtonAppearance(String name, float sceneScale) {
            super("skins/" + name, null);
            try {
                this.mFreeButton = new FreeButtonInfo(FileAccessable.Factory.create(FreeStyleSerializer.DATA_PATH, this.mPath), name, sceneScale);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FreeButtonInfo getFreeButtonInfo() {
            return this.mFreeButton;
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public static class NoneAppearance
    extends Appearance {
        public NoneAppearance() {
            super("", null);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    public static class StageImageAppearance
    extends Appearance {
        Bitmap mBitmap;

        public StageImageAppearance(String path, float sceneScale) throws IOException {
            super(path, null);
            this.mBitmap = FreeStyleSerializer.decodeBitmapFromFile(null, sceneScale, FileAccessable.Factory.create(FreeStyleSerializer.DATA_PATH, path));
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        @Override
        public int getType() {
            return 1;
        }
    }
}

