/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.miui.home.launcher.ItemInfo;
import com.miui.home.launcher.upsidescene.data.DataSerializerV1;
import com.miui.home.launcher.upsidescene.data.FreeButtonInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SceneData {
    public static final int INVALIDATE_VAL = -1;
    private static final int DEFAULT_CELL_WIDTH = 160;
    private static final int DEFAULT_CELL_HEIGHT = 200;
    public String mName;
    public String mVersion;
    public int mWidth;
    public int mHeight;
    public int mRawWidth;
    public int mRawHeight;
    public float mSceneScale;
    public Screen mBackground;
    public Screen mDrift;
    public Screen mForeground;
    public Screen mDock;
    public LinkedList<Screen> mScreens;
    private HashMap<String, Bitmap> mBitmapCache = new HashMap();
    public ArrayList<MtzGadgetInfo> mMtzGadgets = new ArrayList();
    public List<FreeButtonInfo> mFreeButtons = new ArrayList<FreeButtonInfo>();
    private static final int GADGET_ID_START_FROM = 100000000;
    int mCurrentItemId = 100000000;

    public Screen getDriftScreen() {
        return this.mDrift;
    }

    public Screen getBackgroundScreen() {
        return this.mBackground;
    }

    public Screen getForegroundScreen() {
        return this.mForeground;
    }

    public Screen getDock() {
        return this.mDock;
    }

    public List<MtzGadgetInfo> getMtzGadgets() {
        return this.mMtzGadgets;
    }

    public List<FreeButtonInfo> getFreeButtons() {
        return this.mFreeButtons;
    }

    public int getScreenWidth() {
        return this.mWidth;
    }

    public int getScreenHeight() {
        return this.mHeight;
    }

    public HashMap<String, Bitmap> getBitmapCache() {
        return this.mBitmapCache;
    }

    public void calcSpriteSize(Sprite sprite) {
        sprite.calcSize(this.mSceneScale);
    }

    private int generateNewId() {
        return this.mCurrentItemId++;
    }

    public SpriteCell createSpriteCell(int type, int spanX, int spanY) {
        SpriteCell sprite = new SpriteCell(type);
        sprite.mSpanX = spanX;
        sprite.mSpanY = spanY;
        this.calcSpriteSize(sprite);
        return sprite;
    }

    public SpriteButton createSpriteButton(FreeButtonInfo info) {
        SpriteButton sprite = new SpriteButton();
        sprite.setNoFunction();
        if (info != null) {
            sprite.mFreeButton = info;
            sprite.mResourcesPackageName = info.mPackageName;
        }
        this.calcSpriteSize(sprite);
        return sprite;
    }

    protected int getCellWidthByScene(int cellX) {
        return Math.round((float)(160 * cellX) * this.mSceneScale);
    }

    protected int getCellHeightByScene(int cellY) {
        return Math.round((float)(200 * cellY) * this.mSceneScale);
    }

    public class MtzGadgetInfo
    extends ItemInfo {
        public String title;
        public Bitmap preview;
        public String path;

        public MtzGadgetInfo() {
            this.itemType = 9;
        }
    }

    public static interface SceneItem {
        public boolean checkValidate();

        public void calcSize(float var1);
    }

    public class Screen
    implements SceneItem {
        public static final int SCREEN_TYPE_DRIFT = 1;
        public static final int SCREEN_TYPE_BACKGROUND = 2;
        public static final int SCREEN_TYPE_FOREGROUND = 3;
        public static final int SCREEN_TYPE_DOCK = 4;
        int mType;
        int mIndex;
        int mHome = 0;
        int mWidth;
        int mHeight;
        boolean mInteraction = false;
        final SpriteComparator SC = new SpriteComparator();
        LinkedList<Sprite> mSprites = new LinkedList();
        LinkedList<Sprite> mSortedSprites = new LinkedList();

        public int getType() {
            return this.mType;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getHome() {
            return this.mHome;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public boolean canInteraction() {
            return this.mInteraction;
        }

        public Collection<Sprite> getSprites() {
            return this.mSortedSprites;
        }

        public boolean bringSpriteToTop(Sprite sprite) {
            if (this.mSprites.contains(sprite)) {
                int max = 0;
                for (Sprite sp : this.mSprites) {
                    int n = max = sp.getIndex() > max ? sp.getIndex() : max;
                }
                sprite.setIndex(max + 1);
                this.resortSprites();
            }
            return false;
        }

        public void addSprite(Sprite cell) {
            cell.setIndex(this.mSprites.size());
            this.mSprites.add(cell);
        }

        public boolean removeSprite(Sprite sprite) {
            if (this.mSprites.remove(sprite)) {
                this.resortSprites();
                return true;
            }
            return false;
        }

        void resortSprites() {
            this.mSortedSprites = (LinkedList)this.mSprites.clone();
            Collections.sort(this.mSortedSprites, this.SC);
        }

        @Override
        public boolean checkValidate() {
            return this.mType >= 1 && this.mType <= 4;
        }

        @Override
        public void calcSize(float sceneScale) {
            this.mWidth = Math.round((float)this.mWidth * sceneScale);
            this.mHeight = Math.round((float)this.mHeight * sceneScale);
            for (Sprite s : this.mSprites) {
                s.calcSize(sceneScale);
            }
        }

        public String toString() {
            return "Screen:type=" + this.mType + ",index=" + this.mIndex + ",width=" + this.mWidth + ",height=" + this.mHeight + ",interaction=" + this.mInteraction + ",sprites:" + this.mSprites;
        }

        public class SpriteComparator
        implements Comparator<Sprite> {
            @Override
            public int compare(Sprite s1, Sprite s2) {
                return s1.getIndex() < s2.getIndex() ? -1 : 1;
            }
        }
    }

    public abstract class Sprite
    implements SceneItem {
        public static final int SPRITE_TYPE_PICTURE = 1;
        public static final int SPRITE_TYPE_BUTTON = 2;
        public static final int SPRITE_TYPE_CELL = 3;
        int mLeft = -1;
        int mTop = -1;
        protected int mRight = -1;
        protected int mBottom = -1;
        int mIndex = -1;
        public String mEditName;

        public abstract int getType();

        public int getLeft() {
            return this.mLeft;
        }

        public int getTop() {
            return this.mTop;
        }

        public int getRight() {
            return this.mRight;
        }

        public int getBottom() {
            return this.mBottom;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public void setIndex(int index) {
            this.mIndex = index;
        }

        public void setLeft(int left) {
            if (this.isMovable()) {
                this.mRight += left - this.mLeft;
                this.mLeft = left;
            }
        }

        public void setTop(int top) {
            if (this.isMovable()) {
                this.mBottom += top - this.mTop;
                this.mTop = top;
            }
        }

        @Override
        public boolean checkValidate() {
            return true;
        }

        @Override
        public void calcSize(float sceneScale) {
            this.mLeft = Math.round((float)this.mLeft * sceneScale);
            this.mTop = Math.round((float)this.mTop * sceneScale);
        }

        public boolean isMovable() {
            return true;
        }

        public String toString() {
            return "[index:" + this.mIndex + ",left:" + this.mLeft + ",top:" + this.mTop + ",right:" + this.mRight + ",bottom:" + this.mBottom + "]";
        }

        public String getEditName() {
            return this.mEditName;
        }

        public void setEditName(String editName) {
            this.mEditName = editName;
        }
    }

    public class SpriteButton
    extends Sprite {
        public static final int FUNCTION_TYPE_NONE = 0;
        public static final int FUNCTION_TYPE_APPLICATION = 1;
        public static final int FUNCTION_TYPE_FOLDER = 2;
        public static final int FUNCTION_TYPE_DRAWER = 3;
        public String mResourcesPackageName;
        public String mNormalName;
        Bitmap mNormal;
        public String mPressedName;
        Bitmap mPressed;
        boolean mSendBroadcast = false;
        public Intent mIntent;
        public FreeButtonInfo mFreeButton;
        public List<ComponentName> mComponents;
        public int mFunctionType;
        public String mFolderTitle;

        public Bitmap getNormal() {
            return this.mNormal;
        }

        public Bitmap getPressed() {
            return this.mPressed;
        }

        public void setNeedBroadcast(boolean send) {
            this.mSendBroadcast = send;
        }

        public boolean isBroadcast() {
            return this.mSendBroadcast;
        }

        public void setIntent(Intent intent) {
            this.mIntent = intent;
        }

        public Intent getIntent() {
            return this.mIntent;
        }

        public boolean isFreeButton() {
            return this.mFreeButton != null;
        }

        public int getFunctionType() {
            return this.mFunctionType;
        }

        public void setFolder(List<ComponentName> components) {
            this.mFunctionType = 2;
            this.mComponents = components;
        }

        public List<ComponentName> getComponents() {
            if (this.mFunctionType == 3) {
                Intent mainIntent = new Intent("android.intent.action.MAIN", null);
                mainIntent.addCategory("android.intent.category.LAUNCHER");
                PackageManager pm = ActivityThread.currentApplication().getPackageManager();
                List<ResolveInfo> installedApps = pm.queryIntentActivities(mainIntent, 0);
                ArrayList<ComponentName> list = new ArrayList<ComponentName>();
                for (ResolveInfo resolveInfo : installedApps) {
                    list.add(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.clsName));
                }
                return list;
            }
            return this.mComponents;
        }

        public void setApplication(ComponentName app) {
            this.mFunctionType = 1;
            this.mComponents = new ArrayList<ComponentName>();
            this.mComponents.add(app);
        }

        public void setDrawer() {
            this.mFunctionType = 3;
        }

        public void setNoFunction() {
            this.mFunctionType = 0;
            this.mComponents = null;
        }

        public Drawable getDrawable(String state, Context context) {
            if (this.mFreeButton != null) {
                try {
                    return this.mFreeButton.getDrawable(state, context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public int getType() {
            return 2;
        }

        public String getFolderTitle() {
            return this.mFolderTitle;
        }

        public void setFolderTitle(String folderTitle) {
            this.mFolderTitle = folderTitle;
        }

        @Override
        public boolean checkValidate() {
            return true;
        }

        @Override
        public void calcSize(float sceneScale) {
            super.calcSize(sceneScale);
            int width = 0;
            int height = 0;
            if (!this.isFreeButton()) {
                if (this.mNormal != null) {
                    width = this.mNormal.getWidth();
                    height = this.mNormal.getHeight();
                }
                if (this.mPressed != null) {
                    width = Math.max(width, this.mPressed.getWidth());
                    height = Math.max(height, this.mPressed.getHeight());
                }
            }
            this.mRight = this.getLeft() + width;
            this.mBottom = this.getTop() + height;
        }
    }

    public class SpriteCell
    extends Sprite {
        public static final int CONTENT_TYPE_NULL = 0;
        @Deprecated
        private static final int CONTENT_TYPE_SHORTCUTS = 1;
        public static final int CONTENT_TYPE_SYSTEM_WIDGET = 2;
        public static final int CONTENT_TYPE_INTERNAL_GADGET = 3;
        public static final int CONTENT_TYPE_EXTERNAL_GADGET = 4;
        public static final int CONTENT_TYPE_APPLICATION = 5;
        public static final int CONTENT_TYPE_FOLDER = 6;
        int mSpanX = -1;
        int mSpanY = -1;
        public boolean mShowTitle = true;
        public boolean mShowIcon = true;
        public int mDefaultContentType = -1;
        public int mCurrentContentType = -1;
        public float mRotation = 0.0f;
        public float mScale = 1.0f;
        public Shortcuts mShortcuts;
        public Widget mWidget;

        public SpriteCell(int type) {
            this.mCurrentContentType = this.mDefaultContentType = type;
            if (this.mDefaultContentType == 5 || this.mDefaultContentType == 6) {
                this.mSpanY = 1;
                this.mSpanX = 1;
            }
        }

        public int getSpanX() {
            return this.mSpanX;
        }

        public int getSpanY() {
            return this.mSpanY;
        }

        public float getRotation() {
            return this.mRotation;
        }

        public float getScale() {
            return this.mScale;
        }

        boolean isAppOrFolder() {
            return this.mCurrentContentType == 5 || this.mCurrentContentType == 6;
        }

        @Override
        public int getType() {
            return 3;
        }

        public int getContentType() {
            return this.mCurrentContentType;
        }

        public Shortcuts getShortcuts() {
            return this.mShortcuts;
        }

        public Widget getWidget() {
            return this.mWidget;
        }

        public void setEmpty() {
            if (this.isAppOrFolder()) {
                this.mShortcuts.clear();
            } else if (this.mCurrentContentType != 0) {
                this.mWidget.setEmpty();
            }
            this.mCurrentContentType = 0;
        }

        private boolean prepairShortcuts(boolean isFolder) {
            if (this.mSpanX != 1 || this.mSpanY != 1) {
                return false;
            }
            this.mCurrentContentType = isFolder ? 6 : 5;
            this.ensureContent();
            return true;
        }

        public boolean setShortcut(ComponentName name) {
            if (!this.prepairShortcuts(false)) {
                return false;
            }
            this.mShortcuts.setComponentName(name);
            return true;
        }

        public boolean setShortcuts(Collection<ComponentName> names) {
            if (!this.prepairShortcuts(true)) {
                return false;
            }
            this.mShortcuts.setComponentNames(names);
            return true;
        }

        public boolean setSystemWidget(int id) {
            this.mCurrentContentType = 2;
            this.ensureContent();
            this.mWidget.setId(id);
            return true;
        }

        public int setInternalGadget(int gadgetType) {
            this.mCurrentContentType = 3;
            this.ensureContent();
            int newId = SceneData.this.generateNewId();
            this.mWidget.setId(newId);
            this.mWidget.setGadgetType(gadgetType);
            return newId;
        }

        public boolean updateInternalGadget(String location, Context context) {
            if (this.mCurrentContentType == 3) {
                return this.mWidget.setLocation(location, context);
            }
            return false;
        }

        public boolean setExternalGadget(String location, Context context) {
            this.mDefaultContentType = 4;
            this.mCurrentContentType = 4;
            this.ensureContent();
            return this.mWidget.setLocation(location, context);
        }

        private void ensureContent() {
            if (this.isAppOrFolder() && this.mShortcuts == null) {
                this.mShortcuts = new Shortcuts();
            } else if (this.mWidget == null) {
                this.mWidget = new Widget();
            }
        }

        @Override
        public void calcSize(float sceneScale) {
            super.calcSize(sceneScale);
            this.mRight = this.getLeft() + SceneData.this.getCellWidthByScene(this.mSpanX);
            this.mBottom = this.getTop() + SceneData.this.getCellHeightByScene(this.mSpanY);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "->spanx:" + this.mSpanX + ",spany:" + this.mSpanY + ",rotation:" + this.mRotation + ",scale:" + this.mScale;
        }

        public class Shortcuts
        implements SceneItem {
            ArrayList<ComponentName> mComponentNames = new ArrayList();
            String mFolderTitle = null;
            boolean mIsFolder;

            public ComponentName[] getComponentNames() {
                if (this.mComponentNames.isEmpty()) {
                    return null;
                }
                return this.mComponentNames.toArray(new ComponentName[this.mComponentNames.size()]);
            }

            private void setComponentName(ComponentName name) {
                this.mComponentNames.clear();
                this.mComponentNames.add(name);
                this.mIsFolder = false;
            }

            private void setComponentNames(Collection<ComponentName> names) {
                this.mComponentNames.clear();
                if (names != null) {
                    this.mComponentNames.addAll(names);
                }
                this.mIsFolder = true;
            }

            private void clear() {
                this.mComponentNames.clear();
            }

            public boolean isFolder() {
                return this.mIsFolder;
            }

            public boolean isShowTitle() {
                return SpriteCell.this.mShowTitle;
            }

            public boolean isShowIcon() {
                return SpriteCell.this.mShowIcon;
            }

            public String getFolderTitle() {
                return this.mFolderTitle;
            }

            public boolean setFolderTitle(String title) {
                if (SpriteCell.this.mCurrentContentType == 6) {
                    this.mFolderTitle = title;
                    return true;
                }
                return false;
            }

            @Override
            public boolean checkValidate() {
                return true;
            }

            @Override
            public void calcSize(float sceneScale) {
            }
        }

        public class Widget
        implements SceneItem {
            public String mLocation = null;
            public String mDefaultLocation = null;
            int mId = -1;
            int mGadgetType = -1;

            public int getId() {
                return this.mId;
            }

            public String getLocation() {
                return this.mLocation;
            }

            public int getGadgetType() {
                return this.mGadgetType;
            }

            private void setEmpty() {
                this.mId = -1;
                this.mLocation = null;
            }

            private void setId(int id) {
                this.mId = id;
                this.mLocation = null;
            }

            private void setGadgetType(int type) {
                this.mGadgetType = type;
            }

            private boolean setLocation(String src, Context context) {
                File file;
                if (src != null && (file = new File(src)).exists()) {
                    this.mLocation = String.valueOf(DataSerializerV1.getPersistDirectory(SceneData.this, context)) + "/" + file.getName();
                    try {
                        if (DataSerializerV1.copyStreamToFileIfNotExist(new FileInputStream(file), this.mLocation)) {
                            return true;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                this.mLocation = null;
                return false;
            }

            @Override
            public boolean checkValidate() {
                return true;
            }

            @Override
            public void calcSize(float sceneScale) {
            }
        }
    }

    public class SpritePicture
    extends Sprite {
        public String mPictureName;
        Bitmap mPicture;

        public Bitmap getPicture() {
            return this.mPicture;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean checkValidate() {
            return true;
        }

        @Override
        public void calcSize(float sceneScale) {
            super.calcSize(sceneScale);
            if (this.mPicture != null) {
                this.mRight = this.getLeft() + this.mPicture.getWidth();
                this.mBottom = this.getTop() + this.mPicture.getHeight();
            }
        }

        @Override
        public boolean isMovable() {
            return false;
        }
    }
}

