/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.apk;

import com.miui.theme.tool.module.MIUIThemeValues;
import com.miui.theme.tool.resource.ResourceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

public class ThemeValue {
    private final String[] VALID_NAMES = new String[]{"bool", "integer", "string", "color", "fraction", "dimen"};
    private File mOriginFile;
    private File mTargetXml;
    private String mPkgName = null;
    private String mStr;
    private Vector<Vector<Pair>> mVectorCfg;
    private HashMap<String, Item> mapIdItem = null;
    private boolean DEBUG = false;
    private final String configFileName = "configuration" + File.separator + "config.cfg";
    private Vector<Vector<String>> mThemeValues;
    public final String DEPRECATED_SUFFIX = "deprecated_";

    public ThemeValue(File valuesFile, File targetXml) {
        this.mOriginFile = valuesFile;
        this.mTargetXml = targetXml;
        this.mThemeValues = new Vector();
    }

    public ThemeValue(String strValuesPath, String strXmlPath) {
        this(new File(strValuesPath), new File(strXmlPath));
    }

    public ThemeValue(String strValuePath) {
        this.mOriginFile = new File(strValuePath);
    }

    public void generateThemeValuesXml() {
        this.readCfgFromFile();
        try {
            this.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saveThemeValues();
    }

    private void saveThemeValues() {
        MIUIThemeValues mtv = new MIUIThemeValues();
        mtv.setXmlFile(this.mTargetXml);
        mtv.setAll(this.mThemeValues);
        mtv.save();
    }

    public String getPackageName() {
        if (this.mPkgName == null) {
            this.loadPackageName();
        }
        return this.mPkgName;
    }

    private void readCfgFromFile() {
        File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + this.configFileName);
        this.mVectorCfg = new Vector();
        try {
            int j;
            String str2;
            FileInputStream fin = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fin));
            while ((str2 = br.readLine()) != null) {
                if (str2.startsWith("#")) continue;
                String[] s = str2.split(" ");
                Vector<Pair> vc = new Vector<Pair>();
                int i = 0;
                while (i < s.length) {
                    vc.add(new Pair(s[i], 0));
                    ++i;
                }
                this.mVectorCfg.add(vc);
            }
            br.close();
            fin.close();
            int i = 0;
            int tmp = 1;
            while (i < this.mVectorCfg.size()) {
                j = 1;
                while (j < this.mVectorCfg.get(i).size()) {
                    this.mVectorCfg.get((int)i).get((int)j).priorityValue = tmp * j;
                    ++j;
                }
                tmp *= this.mVectorCfg.get(i).size();
                ++i;
            }
            if (this.DEBUG) {
                i = 0;
                while (i < this.mVectorCfg.size()) {
                    j = 0;
                    while (j < this.mVectorCfg.get(i).size()) {
                        System.out.print(this.mVectorCfg.get(i).get(j) + " ");
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPackageName() {
        try {
            FileInputStream fin = new FileInputStream(this.mOriginFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fin));
            br.readLine();
            this.mStr = br.readLine().trim();
            int i = this.mStr.lastIndexOf(61);
            if (i == -1) {
                return;
            }
            this.mPkgName = this.mStr.substring(i + 1, this.mStr.length());
            br.close();
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getPattern(String s) {
        String str = "";
        try {
            try {
                str = s.split(" ")[3].split(":")[1].split("/")[0];
            }
            catch (Exception e) {
                str = "";
            }
        }
        catch (Throwable throwable) {}
        return str;
    }

    private String getId(String s) {
        return s.split(" ")[2];
    }

    private String getName(String str2) {
        return str2.split(" ")[2].split(":")[1].split("/")[1];
    }

    private String getNameFirst(String str1) {
        String str = "";
        try {
            try {
                str = str1.split(" ")[3].split(":")[1].split("/")[1];
            }
            catch (Exception e) {
                str = "";
            }
        }
        catch (Throwable throwable) {}
        return str;
    }

    private int getConfigPriority(String line) {
        if (line.matches("config [0-9]*")) {
            return 0;
        }
        int sum = 0;
        if (line.contains(ResourceFactory.locale.getCountry())) {
            ++sum;
        }
        if (sum > 0 && line.contains(ResourceFactory.locale.getLanguage())) {
            ++sum;
        }
        return sum;
    }

    @Deprecated
    private int getConfigPriority2(String str2) {
        if (str2.matches("config [0-9]*")) {
            return 0;
        }
        int sum = 0;
        String[] s = str2.split(" ");
        int i = 2;
        while (i < s.length) {
            String[] ss = s[i].split("=");
            if (ss.length == 2) {
                int row = -1;
                int j = 0;
                while (j < this.mVectorCfg.size()) {
                    if (this.mVectorCfg.get((int)j).get((int)0).configValue.equals(ss[0])) {
                        row = j;
                        break;
                    }
                    ++j;
                }
                if (row != -1) {
                    int col = 0;
                    int j2 = 1;
                    while (j2 < this.mVectorCfg.get(row).size()) {
                        if (this.mVectorCfg.get((int)row).get((int)j2).configValue.equals(ss[1])) {
                            col = j2;
                            break;
                        }
                        ++j2;
                    }
                    sum += this.mVectorCfg.get((int)row).get((int)col).priorityValue;
                }
            }
            ++i;
        }
        return sum;
    }

    private void process() throws IOException {
        FileInputStream fin = new FileInputStream(this.mOriginFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fin, "utf-8"));
        while (this.mStr != null && this.mStr.startsWith("type") || (this.mStr = br.readLine()) != null) {
            this.mStr = this.mStr.trim();
            if (!this.mStr.startsWith("type")) continue;
            int configCount = 0;
            int entryCount = 0;
            configCount = this.getConfigCount(this.mStr);
            entryCount = this.getEntryCount(this.mStr);
            if (configCount == 0) {
                this.mStr = br.readLine();
                continue;
            }
            this.mStr = br.readLine();
            if (this.mStr == null) break;
            this.mStr = this.mStr.trim();
            String patternName = this.getPattern(this.mStr);
            if (!this.isValid(patternName)) continue;
            this.mapIdItem = new HashMap();
            Item item1 = new Item(patternName, this.getNameFirst(this.mStr));
            this.mapIdItem.put(this.getId(this.mStr), item1);
            int i = 1;
            while (i < entryCount) {
                this.mStr = br.readLine();
                if (this.mStr == null) break;
                this.mStr = this.mStr.trim();
                Item item = new Item(patternName, this.getNameFirst(this.mStr));
                this.mapIdItem.put(this.getId(this.mStr), item);
                ++i;
            }
            i = 0;
            while (i < configCount) {
                this.gotoNextConfig(br);
                String configThis = this.mStr;
                int priorityValue = this.getConfigPriority(configThis);
                int j = 0;
                while (j < entryCount) {
                    if (!this.mStr.startsWith("resource") && (this.mStr = br.readLine()) == null) break;
                    this.mStr = this.mStr.trim();
                    if (this.mStr.startsWith("config") || this.mStr.startsWith("type")) break;
                    String name = this.getName(this.mStr);
                    String id = this.mStr.split(" ")[1];
                    Item item = this.mapIdItem.get(id);
                    this.mStr = br.readLine();
                    if (this.mStr == null) break;
                    this.mStr = this.mStr.trim();
                    String value = this.getValue(this.mStr);
                    if (priorityValue > item.priority) {
                        item.priority = priorityValue;
                        item.name = name;
                        item.setValue(value);
                    }
                    ++j;
                }
                if (this.mStr == null || this.mStr.startsWith("type")) break;
                ++i;
            }
            for (Item item : this.mapIdItem.values()) {
                this.writeOneElement(item);
            }
        }
        br.close();
        fin.close();
    }

    private String getValue(String s2) {
        String value = "";
        if (s2.trim().startsWith("(reference)")) {
            return value;
        }
        int i = s2.indexOf(32);
        value = s2.substring(i + 1, s2.length());
        return value;
    }

    private void gotoNextConfig(BufferedReader br) throws IOException {
        if (this.mStr.startsWith("config")) {
            return;
        }
        this.mStr = br.readLine();
        if (this.mStr == null) {
            return;
        }
        this.mStr = this.mStr.trim();
        while (!this.mStr.startsWith("config")) {
            this.mStr = br.readLine();
            if (this.mStr == null) {
                return;
            }
            this.mStr = this.mStr.trim();
        }
    }

    private void writeOneElement(Item item) {
        if (item.value == null) {
            return;
        }
        if (item.pattern.equals("string")) {
            if (item.value == null) {
                return;
            }
            item.value = item.value.replace('\"', ' ');
        }
        item.value = item.value.trim();
        if (item.value.startsWith("\"")) {
            return;
        }
        if (item.name.startsWith("deprecated_")) {
            return;
        }
        Vector<String> vs = new Vector<String>();
        vs.add(0, item.pattern);
        vs.add(1, item.name);
        vs.add(2, item.value);
        vs.add(3, "");
        this.mThemeValues.add(vs);
    }

    private boolean isValid(String name) {
        int i = 0;
        while (i < this.VALID_NAMES.length) {
            if (this.VALID_NAMES[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getEntryCount(String str2) {
        String[] s = str2.split(" ");
        String t = s[3].substring("entryCount=".length(), s[3].length());
        int cnt = 0;
        cnt = Integer.parseInt(t);
        return cnt;
    }

    private int getConfigCount(String str2) {
        String[] s = str2.split(" ");
        String t = s[2].substring("configCount=".length(), s[2].length());
        int cnt = 0;
        cnt = Integer.parseInt(t);
        return cnt;
    }

    private class Item {
        public String pattern;
        public String name;
        public String value;
        public int priority = -1;

        public Item(String pattern, String name) {
            this.pattern = pattern;
            this.name = name;
        }

        public void setValue(String value) {
            if ("bool".equals(this.pattern)) {
                if (value.equals("#ffffffff")) {
                    value = "true";
                } else if (value.equals("#00000000")) {
                    value = "false";
                }
            }
            this.value = value;
        }
    }

    private class Pair {
        public String configValue;
        public int priorityValue;

        public Pair(String configValue, int priorityValue) {
            this.configValue = configValue;
            this.priorityValue = priorityValue;
        }
    }
}

