/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import android.content.Context;
import com.android.ddmlib.utils.VerticalFlowLayout;
import com.miui.home.launcher.upsidescene.data.Appearance;
import com.miui.home.launcher.upsidescene.data.FreeStyle;
import com.miui.home.launcher.upsidescene.data.FreeStyleSerializer;
import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import com.miui.theme.tool.freestyle.DragableScenePreviewPanel;
import com.miui.theme.tool.freestyle.FreeStyleTree;
import com.miui.theme.tool.freestyle.ScenePreviewPanel;
import com.miui.theme.tool.freestyle.SelectAppearance;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xmlpull.v1.XmlPullParserException;

public class FreeStylePanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    public static final String FREE_STYLE_NAME = "com.miui.home.freestyle";
    public static final String FREE_STYLE_STAGE_IMAGES_NAME = "stage_images";
    public static final String FREE_STYLE_SKINS_NAME = "skins";
    public static final String FREE_STYLE_TOOLS_NAME = "tools";
    public static final int[] screenTypes = new int[]{2, 1, 3, 4};
    public static final int DEFAULT_SCREEN_WIDTH = 720;
    public static final int DEFAULT_SCREEN_HEIGHT = 1280;
    private String mFreeStyleDescriptionPath;
    public FreeStyle mFreeStyle;
    private FreeStyleSerializer mFreeStyleSerializer;
    private FreeStyleTree mFreeStyleTree;
    private JPanel mTreeEditPanel;
    private JPanel mRightPanel = new JPanel();
    private JPanel mEditPanel = new JPanel();
    private ScenePreviewPanel mScenePreviewPanel;
    private JButton mDeleteButton;
    private JButton mCreateButton;
    private JButton mUpButton;
    private JButton mDownButton;
    private JButton mRefreshButton;
    private DefaultMutableTreeNode mCurrentTreeNode;
    private Object mCurrentObject;
    private JLabel mWidthLabel = new JLabel(ResourceFactory.getString("width"));
    private JTextField mWidthTextField;
    private JLabel mHeightLabel = new JLabel(ResourceFactory.getString("height"));
    private JTextField mHeightTextField;
    private JLabel mNameLabel = new JLabel(ResourceFactory.getString("name"));
    private JTextField mNameTextField;
    private JLabel mHomeLabel = new JLabel(ResourceFactory.getString("home"));
    private JTextField mHomeTextField;
    private JLabel mLeftLabel = new JLabel(ResourceFactory.getString("left"));
    private JTextField mLeftTextField;
    private JLabel mTopLabel = new JLabel(ResourceFactory.getString("top"));
    private JTextField mTopTextField;
    private JLabel mAppearanceLabel = new JLabel(ResourceFactory.getString("appearance"));
    private JTextField mAppearanceTextField;
    private JLabel mFunctionLabel = new JLabel(ResourceFactory.getString("function"));
    private JTextField mFunctionTextField;
    private ArrayList<JTextField> mInstantFieldHost;
    private ArrayList<JTextField> mDelayFieldHost;
    private MouseListener mSelectAppearanceAndFunctionMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            Sprite sprite = (Sprite)FreeStylePanel.this.mCurrentObject;
            SelectAppearance saaf = new SelectAppearance(FreeStylePanel.getFreeStylePath());
            saaf.mAppearanceResult = sprite.getAppearance();
            saaf.mFunctionResult = sprite.getFunction();
            saaf.setVisible(true);
            sprite.setAppearance(saaf.mAppearanceResult);
            sprite.setFunction(saaf.mFunctionResult);
            FreeStylePanel.this.mScenePreviewPanel.prepareRefresh();
            FreeStylePanel.this.mFreeStyleTree.refresh();
        }
    };
    private KeyListener mKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            FreeStylePanel.this.onUpdate(e.getSource());
        }
    };
    public static final float MOCK_SCALE = 1.0f;

    public FreeStylePanel() {
        this.mScenePreviewPanel = new DragableScenePreviewPanel();
        this.mScenePreviewPanel.mFreeStylePanel = this;
    }

    public static String getFreeStylePath() {
        return String.valueOf(ThemeHelper.getS_themeFolderPath()) + File.separator + FREE_STYLE_NAME;
    }

    public boolean onFileSelected(File f) {
        block8: {
            this.mFreeStyleSerializer = new FreeStyleSerializer(new Context(FREE_STYLE_NAME));
            FreeStyleSerializer.DATA_PATH = FreeStylePanel.getFreeStylePath();
            this.mFreeStyleDescriptionPath = String.valueOf(f.getAbsolutePath()) + "/" + "description.xml";
            File newFile = new File(this.mFreeStyleDescriptionPath);
            if (!newFile.exists()) {
                return false;
            }
            this.mFreeStyle = this.mFreeStyleSerializer.loadFreeStyle(new FileInputStream(newFile), false);
            if (this.mFreeStyle != null) break block8;
            return false;
        }
        try {
            this.mFreeStyle.mName = this.mFreeStyleSerializer.loadFreeStyleName();
            int i = 0;
            while (i < screenTypes.length) {
                Screen screen = this.mFreeStyle.getSpecifyScreen(screenTypes[i]);
                if (screen == null) {
                    screen = new Screen();
                    screen.mType = screenTypes[i];
                    screen.mWidth = 720;
                    screen.mHeight = 1280;
                    this.mFreeStyle.getScreens().add(screen);
                }
                ++i;
            }
            this.initEditViews();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void save() {
        this.mFreeStyleSerializer.saveFreeStyle(this.mFreeStyle, this.mFreeStyleDescriptionPath, false);
    }

    private void initEditViews() {
        this.setLayout(new GridBagLayout());
        this.mFreeStyleTree = new FreeStyleTree();
        this.mFreeStyleTree.setFreeStyle(this.mFreeStyle);
        this.mFreeStyleTree.addTreeSelectionListener(this);
        this.initTreeEditPanel();
        this.initRightPanel();
        int gap = 10;
        int x = 0;
        int y = 0;
        GridBagHelper.addComponent(this, new JScrollPane(this.mFreeStyleTree), x, y, 1, 1, 0, 0, new Insets(gap, gap, 0, gap), 1.0, 1.0, 1, 17);
        GridBagHelper.addComponent(this, this.mRightPanel, ++x, y, 1, 2, 0, 0, new Insets(gap, 0, gap, gap), 15.0, 0.0, 1, 17);
        x = 0;
        GridBagHelper.addComponent(this, this.mTreeEditPanel, x, ++y, 1, 1, 0, 0, new Insets(0, gap, gap, gap), 0.0, 0.0, 1, 17);
    }

    private void initRightPanel() {
        this.mRightPanel.setLayout(new GridBagLayout());
        int gap = 0;
        int x = 0;
        int y = 0;
        this.mEditPanel.setLayout(new VerticalFlowLayout());
        this.mScenePreviewPanel.setFreeStyle(this.mFreeStyle);
        JScrollPane jsp = new JScrollPane(this.mScenePreviewPanel);
        jsp.setBorder(null);
        GridBagHelper.addComponent(this.mRightPanel, jsp, x, y, 1, 1, 0, 0, gap, gap, 1.0, 2.0, 1, 17);
        GridBagHelper.addComponent(this.mRightPanel, this.mEditPanel, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 17);
    }

    private void initTreeEditPanel() {
        this.mTreeEditPanel = new JPanel();
        this.mDeleteButton = new JButton(ResourceFactory.getString("delete"));
        this.mDeleteButton.addActionListener(this);
        this.mCreateButton = new JButton(ResourceFactory.getString("create"));
        this.mCreateButton.addActionListener(this);
        this.mUpButton = new JButton(ResourceFactory.getString("up"));
        this.mUpButton.addActionListener(this);
        this.mDownButton = new JButton(ResourceFactory.getString("down"));
        this.mDownButton.addActionListener(this);
        this.mRefreshButton = new JButton(ResourceFactory.getString("refresh"));
        this.mRefreshButton.addActionListener(this);
        this.mCreateButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
        this.mUpButton.setEnabled(false);
        this.mDownButton.setEnabled(false);
        this.mTreeEditPanel.setLayout(new GridBagLayout());
        int gap = 0;
        int x = 0;
        int y = 0;
        GridBagHelper.addComponent(this.mTreeEditPanel, this.mCreateButton, x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mTreeEditPanel, this.mDeleteButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        x = 0;
        GridBagHelper.addComponent(this.mTreeEditPanel, this.mUpButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mTreeEditPanel, this.mDownButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        ++x;
        x = 0;
        GridBagHelper.addComponent(this.mTreeEditPanel, this.mRefreshButton, x, ++y, 2, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Screen screen;
        Object source = e.getSource();
        if (source.equals(this.mRefreshButton)) {
            ScenePreviewPanel.clearCachedImage();
        }
        if (this.mCurrentObject instanceof Sprite) {
            screen = (Screen)((DefaultMutableTreeNode)this.mCurrentTreeNode.getParent()).getUserObject();
            List<Sprite> sprites = screen.getSprites();
            int i = 0;
            while (i < sprites.size()) {
                if (sprites.get(i).equals(this.mCurrentObject)) {
                    Sprite s;
                    if (source.equals(this.mDeleteButton)) {
                        sprites.remove(i);
                        this.setCurrentObject(null);
                    }
                    if (source.equals(this.mUpButton) && i != 0) {
                        s = sprites.get(i - 1);
                        sprites.set(i - 1, (Sprite)this.mCurrentObject);
                        sprites.set(i, s);
                    }
                    if (source.equals(this.mDownButton) && sprites.size() - 1 != i) {
                        s = sprites.get(i + 1);
                        sprites.set(i + 1, (Sprite)this.mCurrentObject);
                        sprites.set(i, s);
                    }
                    if (!source.equals(this.mCreateButton)) break;
                    this.createSprite(sprites, i);
                    break;
                }
                ++i;
            }
        }
        if (this.mCurrentObject instanceof Screen) {
            screen = (Screen)this.mCurrentObject;
            if (source.equals(this.mCreateButton)) {
                this.createSprite(screen.getSprites(), screen.getSprites().size());
            }
        }
        this.refreshAll();
    }

    public void refreshAll() {
        if (this.mCurrentObject instanceof Sprite) {
            this.mFreeStyleTree.setNextSelectSprite((Sprite)this.mCurrentObject);
        }
        this.mFreeStyleTree.refresh();
        this.mScenePreviewPanel.prepareRefresh();
        this.mFreeStyleTree.updateUI();
    }

    private void createSprite(List<Sprite> sprites, int i) {
        Sprite sprite = new Sprite();
        SelectAppearance saaf = new SelectAppearance(FreeStylePanel.getFreeStylePath());
        saaf.mAppearanceResult = sprite.getAppearance();
        saaf.mFunctionResult = sprite.getFunction();
        saaf.setVisible(true);
        sprite.setAppearance(saaf.mAppearanceResult);
        sprite.setFunction(saaf.mFunctionResult);
        sprites.add(i, sprite);
        this.setCurrentObject(sprite);
    }

    public void setCurrentObject(Object object) {
        this.mCurrentObject = object;
    }

    public Object getCurrentObject() {
        return this.mCurrentObject;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.initEditPanel();
    }

    public void initEditPanel() {
        this.mEditPanel.removeAll();
        if (this.mFreeStyleTree.getLastSelectedPathComponent() == null) {
            return;
        }
        this.mCurrentTreeNode = (DefaultMutableTreeNode)this.mFreeStyleTree.getLastSelectedPathComponent();
        this.setCurrentObject(this.mCurrentTreeNode.getUserObject());
        this.mEditPanel.setLayout(new GridBagLayout());
        this.mScenePreviewPanel.repaint();
        this.mInstantFieldHost = new ArrayList();
        this.mDelayFieldHost = new ArrayList();
        if (this.mCurrentObject instanceof FreeStyle) {
            this.initFreeStyleEdit((FreeStyle)this.mCurrentObject);
        }
        if (this.mCurrentObject instanceof Screen) {
            this.initScreenEdit((Screen)this.mCurrentObject);
        }
        if (this.mCurrentObject instanceof Sprite) {
            this.initSpriteEdit((Sprite)this.mCurrentObject);
        }
        for (JTextField jtf : this.mInstantFieldHost) {
            jtf.addKeyListener(this.mKeyListener);
        }
        for (JTextField jtf : this.mDelayFieldHost) {
            jtf.addKeyListener(this.mKeyListener);
        }
        this.mEditPanel.validate();
        this.mEditPanel.updateUI();
        this.mEditPanel.repaint();
    }

    private void initSpriteEdit(Sprite s) {
        this.mCreateButton.setEnabled(true);
        this.mDeleteButton.setEnabled(true);
        this.mUpButton.setEnabled(true);
        this.mDownButton.setEnabled(true);
        int gap = 10;
        int x = 0;
        int y = 0;
        this.mNameTextField = new JTextField(s.getEditName());
        this.mDelayFieldHost.add(this.mNameTextField);
        GridBagHelper.addComponent(this.mEditPanel, this.mNameLabel, x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mNameTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        this.mLeftTextField = new JTextField(String.valueOf(s.mLeft));
        this.mInstantFieldHost.add(this.mLeftTextField);
        this.mTopTextField = new JTextField(String.valueOf(s.mTop));
        this.mInstantFieldHost.add(this.mTopTextField);
        this.mWidthTextField = new JTextField(String.valueOf(s.mRawWidth));
        this.mInstantFieldHost.add(this.mWidthTextField);
        this.mHeightTextField = new JTextField(String.valueOf(s.mRawHeight));
        this.mInstantFieldHost.add(this.mHeightTextField);
        GridBagHelper.addComponent(this.mEditPanel, this.mLeftLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mLeftTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mEditPanel, this.mTopLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mTopTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        if (1 == s.getAppearance().getType()) {
            GridBagHelper.addComponent(this.mEditPanel, this.mWidthLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
            GridBagHelper.addComponent(this.mEditPanel, this.mWidthTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
            GridBagHelper.addComponent(this.mEditPanel, this.mHeightLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
            GridBagHelper.addComponent(this.mEditPanel, this.mHeightTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        }
        this.mAppearanceTextField = new JTextField(s.mAppearance.toString());
        this.mDelayFieldHost.add(this.mAppearanceTextField);
        this.mAppearanceTextField.setCursor(Cursor.getPredefinedCursor(12));
        this.mAppearanceTextField.addMouseListener(this.mSelectAppearanceAndFunctionMouseListener);
        this.mFunctionTextField = new JTextField(s.mFunction.toString());
        this.mDelayFieldHost.add(this.mFunctionTextField);
        this.mFunctionTextField.setCursor(Cursor.getPredefinedCursor(12));
        this.mFunctionTextField.addMouseListener(this.mSelectAppearanceAndFunctionMouseListener);
        x = 0;
        GridBagHelper.addComponent(this.mEditPanel, this.mAppearanceLabel, x, ++y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        int l = 3;
        GridBagHelper.addComponent(this.mEditPanel, this.mAppearanceTextField, ++x, y, l, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mEditPanel, this.mFunctionLabel, x += l, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        l = 7;
        GridBagHelper.addComponent(this.mEditPanel, this.mFunctionTextField, ++x, y, l, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
    }

    private void initScreenEdit(Screen s) {
        this.mCreateButton.setEnabled(true);
        this.mDeleteButton.setEnabled(false);
        this.mUpButton.setEnabled(false);
        this.mDownButton.setEnabled(false);
        int gap = 10;
        int x = 0;
        int y = 0;
        this.mWidthTextField = new JTextField(String.valueOf(s.mWidth));
        this.mInstantFieldHost.add(this.mWidthTextField);
        GridBagHelper.addComponent(this.mEditPanel, this.mWidthLabel, x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mWidthTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        if (1 == s.getType()) {
            this.mHomeTextField = new JTextField(String.valueOf(s.mHome));
            this.mDelayFieldHost.add(this.mHomeTextField);
            GridBagHelper.addComponent(this.mEditPanel, this.mHomeLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
            GridBagHelper.addComponent(this.mEditPanel, this.mHomeTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        }
    }

    private void initFreeStyleEdit(FreeStyle fs) {
        this.mCreateButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
        this.mUpButton.setEnabled(false);
        this.mDownButton.setEnabled(false);
        int gap = 10;
        int x = 0;
        int y = 0;
        this.mWidthTextField = new JTextField(String.valueOf(fs.mWidth));
        this.mInstantFieldHost.add(this.mWidthTextField);
        this.mNameTextField = new JTextField(fs.mName);
        this.mDelayFieldHost.add(this.mNameTextField);
        GridBagHelper.addComponent(this.mEditPanel, this.mNameLabel, x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mNameTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mEditPanel, this.mWidthLabel, ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mEditPanel, this.mWidthTextField, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
    }

    private void onUpdate(Object source) {
        if (this.mCurrentObject instanceof FreeStyle) {
            this.onUpdateFreeStyle(source);
        }
        if (this.mCurrentObject instanceof Screen) {
            this.onUpdateScreen(source);
        }
        if (this.mCurrentObject instanceof Sprite) {
            this.onUpdateSprite(source);
        }
        this.mScenePreviewPanel.prepareRefresh();
        this.mFreeStyleTree.updateUI();
    }

    private void onUpdateSprite(Object source) {
        Sprite s = (Sprite)this.mCurrentObject;
        if (source.equals(this.mNameTextField)) {
            s.setEditName(this.mNameTextField.getText());
        }
        if (source.equals(this.mLeftTextField)) {
            s.mLeft = Integer.parseInt(this.mLeftTextField.getText());
        }
        if (source.equals(this.mTopTextField)) {
            s.mTop = Integer.parseInt(this.mTopTextField.getText());
        }
        if (source.equals(this.mWidthTextField)) {
            s.mRawWidth = Integer.parseInt(this.mWidthTextField.getText());
        }
        if (source.equals(this.mHeightTextField)) {
            s.mRawHeight = Integer.parseInt(this.mHeightTextField.getText());
        }
        if (source.equals(this.mAppearanceTextField)) {
            try {
                s.mAppearance = Appearance.load(this.mAppearanceTextField.getText(), 1.0f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (source.equals(this.mFunctionTextField)) {
            s.mFunction = Function.parse(this.mFunctionTextField.getText());
        }
    }

    private void onUpdateScreen(Object source) {
        Screen s = (Screen)this.mCurrentObject;
        if (source.equals(this.mWidthTextField)) {
            s.mWidth = Integer.parseInt(this.mWidthTextField.getText());
        }
        if (source.equals(this.mHomeTextField)) {
            s.mHome = Integer.parseInt(this.mHomeTextField.getText());
        }
    }

    private void onUpdateFreeStyle(Object source) {
        FreeStyle fs = (FreeStyle)this.mCurrentObject;
        if (source.equals(this.mWidthTextField)) {
            fs.mRawWidth = Integer.parseInt(this.mWidthTextField.getText());
        }
        if (source.equals(this.mNameTextField)) {
            fs.mName = this.mNameTextField.getText();
        }
    }
}

