/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.theme.tool.freestyle.ToggleSelectPanel;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.SelectComponentNameHelper;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

class SelectFunction
extends JDialog
implements ActionListener {
    public static final int DIALOG_WIDTH = 900;
    public static final int DIALOG_HEIGHT = 100;
    public Function mFunctionResult;
    private JButton mNoneFunctionButton;
    private JButton mAppButton;
    private JButton mDrawerButton;
    private JButton mToggleButton;
    private JButton mFolderButton;

    public SelectFunction() {
        this.setModal(true);
        MainFrame mainFrame = MainFrame.getInstance();
        this.setTitle(ResourceFactory.getString("select_function"));
        this.setBounds(mainFrame.getX() + (mainFrame.getWidth() - 900) / 2, mainFrame.getY() + (mainFrame.getHeight() - 100) / 2, 900, 100);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mNoneFunctionButton = new JButton(ResourceFactory.getString("freestyle.none_function"));
        this.mNoneFunctionButton.addActionListener(this);
        this.mAppButton = new JButton(ResourceFactory.getString("freestyle.app_function"));
        this.mAppButton.addActionListener(this);
        this.mDrawerButton = new JButton(ResourceFactory.getString("freestyle.drawer_function"));
        this.mDrawerButton.addActionListener(this);
        this.mToggleButton = new JButton(ResourceFactory.getString("freestyle.toggle_function"));
        this.mToggleButton.addActionListener(this);
        this.mFolderButton = new JButton(ResourceFactory.getString("freestyle.folder_function"));
        this.mFolderButton.addActionListener(this);
        int x = 0;
        int y = 0;
        int gap = 5;
        GridBagHelper.addComponent(this.getContentPane(), this.mNoneFunctionButton, x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mAppButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mDrawerButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mToggleButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mFolderButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
    }

    public void selectApp() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SelectComponentNameHelper scnh = new SelectComponentNameHelper();
        scnh.show();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (scnh.mCurrentValue == null) {
            return;
        }
        String componentName = scnh.mCurrentValue;
        this.mFunctionResult = Function.parse("app:" + componentName);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mAppButton)) {
            this.selectApp();
            return;
        }
        if (e.getSource().equals(this.mNoneFunctionButton)) {
            this.mFunctionResult = Function.parse(null);
        } else if (e.getSource().equals(this.mDrawerButton)) {
            this.mFunctionResult = Function.parse("drawer:");
        } else if (e.getSource().equals(this.mFolderButton)) {
            this.mFunctionResult = Function.parse("folder:");
        } else if (e.getSource().equals(this.mToggleButton)) {
            this.selectToggle();
            return;
        }
        this.dispose();
    }

    private void selectToggle() {
        ToggleSelectPanel tsp = new ToggleSelectPanel();
        if (tsp.mFunctionResult != null) {
            this.mFunctionResult = tsp.mFunctionResult;
            this.dispose();
        }
    }
}

