/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icons;

import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class IconManager {
    public static final String PATH_XHDPI;
    public static final String PATH_HDPI;
    public static final String PATH_ICONS = "icons";
    public static final String THEME_DEFAULT_ICON_PATH_V4 = "/system/media/theme/default/icons";
    public static final String THEME_DEFAULT_ICON_PATH_V5 = "/system/media/theme/miui_mod_icons";
    public static final String THEME_DEFAULT_ICON_TMP;
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_FOLDER;
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_HDPI;
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_XHDPI;
    public static final String SHOW_APPS_ICONS = "/data/data/com.miui.themetool/app_appicon";
    public static final String THEME_ICONS_TMP;
    public static final String ICON_SUFFIX = ".png";
    private static HashSet<String> oldDefaultThemeSet;
    public static HashMap<String, String> sSystemIconsName;

    static {
        String systemIcon;
        String[] systemIcons;
        PATH_XHDPI = PATH_ICONS + File.separator + "res" + File.separator + "drawable-xhdpi";
        PATH_HDPI = PATH_ICONS + File.separator + "res" + File.separator + "drawable-hdpi";
        THEME_DEFAULT_ICON_TMP = ThemeHelper.getTmpFolder() + File.separator + "defaulticons";
        THEME_DEFAULT_ICON_TMP_UNZIPPED_FOLDER = ThemeHelper.getTmpFolder() + File.separator + "res";
        THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_HDPI = ThemeHelper.getTmpFolder() + File.separator + "res" + File.separator + "drawable-hdpi";
        THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_XHDPI = ThemeHelper.getTmpFolder() + File.separator + "res" + File.separator + "drawable-xhdpi";
        THEME_ICONS_TMP = ThemeHelper.getTmpFolder() + File.separator + "syncicons";
        oldDefaultThemeSet = new HashSet();
        oldDefaultThemeSet.add("com.android.gallery.png");
        sSystemIconsName = new HashMap();
        String fileName = "icon_name_map_" + ResourceFactory.locale.getLanguage() + ".txt";
        File file = new File(ThemeHelper.getDataFolder() + File.separator + fileName);
        if (file.exists() && (systemIcons = (systemIcon = ThemeHelper.readFromFile(file)).split("\n")) != null) {
            int i = 0;
            while (i < systemIcons.length) {
                String[] values = systemIcons[i].split(" ");
                if (values.length == 2) {
                    sSystemIconsName.put(values[0], values[1]);
                }
                ++i;
            }
        }
    }

    public static String getThemeIconsCatalog() {
        return String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + PATH_ICONS;
    }

    public static String getThemeIconsCatalogDefault() {
        return String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "defaulticons";
    }

    public static String getImportThemeIconsCatalog() {
        return String.valueOf(ThemeHelper.getImportResourceCatalogPath()) + File.separator + PATH_ICONS;
    }

    public static String getImportThemeIconsCatalogDefault() {
        return String.valueOf(ThemeHelper.getImportResourceCatalogPath()) + File.separator + "defaulticons";
    }

    public static boolean syncIcons() {
        File themeIconsTmp = new File(THEME_ICONS_TMP);
        if (themeIconsTmp.exists()) {
            CmdUtils.deleteDir(THEME_ICONS_TMP);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean flag = CmdUtils.adb_install(CmdUtils.IMPORT_APPS_APK_FILE);
        if (!flag) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("generate", PATH_ICONS);
        flag = CmdUtils.adb_shell_start("com.miui.themetool/com.miui.themetool.ShowAppsActivity", map);
        if (!flag) {
            return false;
        }
        flag = ThemeHelper.waitForCompleteFile("/data/data/com.miui.themetool/app_appicon/complete");
        if (!flag) {
            return false;
        }
        flag = CmdUtils.adb_pull(SHOW_APPS_ICONS, THEME_ICONS_TMP);
        if (!flag) {
            return false;
        }
        new File(String.valueOf(THEME_ICONS_TMP) + File.separator + "complete").delete();
        IconManager.copyFiles(THEME_ICONS_TMP, IconManager.getImportThemeIconsCatalog());
        CmdUtils.deleteFile(THEME_ICONS_TMP);
        if (2 == ThemeHelper.getRomUIVersion()) {
            flag = CmdUtils.adb_pull(THEME_DEFAULT_ICON_PATH_V4, THEME_DEFAULT_ICON_TMP);
            if (!flag) {
                return false;
            }
            ThemeHelper.unzip(new File(THEME_DEFAULT_ICON_TMP), ThemeHelper.getTmpFolder());
            IconManager.copyFiles(THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_HDPI, IconManager.getImportThemeIconsCatalogDefault());
            IconManager.copyFiles(THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_XHDPI, IconManager.getImportThemeIconsCatalogDefault());
            CmdUtils.deleteFile(THEME_DEFAULT_ICON_TMP);
            CmdUtils.deleteDir(THEME_DEFAULT_ICON_TMP_UNZIPPED_FOLDER);
        } else if (3 == ThemeHelper.getRomUIVersion()) {
            flag = CmdUtils.adb_pull(THEME_DEFAULT_ICON_PATH_V5, THEME_DEFAULT_ICON_TMP);
            IconManager.copyFiles(THEME_DEFAULT_ICON_TMP, IconManager.getImportThemeIconsCatalogDefault());
            CmdUtils.deleteDir(THEME_DEFAULT_ICON_TMP);
            if (!flag) {
                return false;
            }
        }
        IconManager.removeOldDefaultTheme();
        return true;
    }

    private static void removeOldDefaultTheme() {
        for (String fileName : oldDefaultThemeSet) {
            new File(String.valueOf(IconManager.getImportThemeIconsCatalogDefault()) + File.separator + fileName).delete();
        }
    }

    private static void copyFiles(String source, String dest) {
        File[] files;
        File destFile = new File(dest);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        if ((files = new File(source).listFiles()) == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                ThemeHelper.copyFile(f, new File(String.valueOf(dest) + File.separator + f.getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void cleanIcons() {
        CmdUtils.deleteDir(IconManager.getImportThemeIconsCatalog());
    }
}

