/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class NinePatchDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    public static boolean decode(String inName, boolean replaceOriginFile) throws Exception {
        NinePatch np;
        BufferedImage im2;
        int h;
        int w;
        block11: {
            block10: {
                byte[] data;
                block9: {
                    FileInputStream in = new FileInputStream(inName);
                    data = IOUtils.toByteArray(in);
                    in.close();
                    if (data[37] == 110 && data[38] == 112 && data[39] == 84 && data[40] == 99) break block9;
                    return false;
                }
                BufferedImage im = ImageIO.read(new ByteArrayInputStream(data));
                w = im.getWidth();
                h = im.getHeight();
                im2 = new BufferedImage(w + 2, h + 2, 6);
                if (im.getType() == 6) {
                    im2.getRaster().setRect(1, 1, im.getRaster());
                } else {
                    im2.getGraphics().drawImage(im, 1, 1, null);
                }
                DataInputStream datain = new DataInputStream(new ByteArrayInputStream(data));
                np = NinePatchDecoder.getNinePatch(datain);
                if (np.xDivs.length > 0 && np.yDivs.length > 0) break block10;
                return false;
            }
            if (replaceOriginFile) break block11;
            return true;
        }
        try {
            NinePatchDecoder.drawHLine(im2, h + 1, np.padLeft + 1, w - np.padRight);
            NinePatchDecoder.drawVLine(im2, w + 1, np.padTop + 1, h - np.padBottom);
            int[] xDivs = np.xDivs;
            int i = 0;
            while (i < xDivs.length) {
                NinePatchDecoder.drawHLine(im2, 0, xDivs[i] + 1, xDivs[i + 1]);
                i += 2;
            }
            int[] yDivs = np.yDivs;
            int i2 = 0;
            while (i2 < yDivs.length) {
                NinePatchDecoder.drawVLine(im2, 0, yDivs[i2] + 1, yDivs[i2 + 1]);
                i2 += 2;
            }
            FileOutputStream out = new FileOutputStream(inName);
            ImageIO.write((RenderedImage)im2, "png", out);
            out.close();
            return true;
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
    }

    private static NinePatch getNinePatch(DataInputStream di) throws Exception {
        NinePatchDecoder.find9patchChunk(di);
        return NinePatch.decode(di);
    }

    private static void find9patchChunk(DataInputStream di) throws Exception {
        di.skipBytes(8);
        while (true) {
            int size = 0;
            try {
                size = di.readInt();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (di.readInt() == 1852855395) {
                return;
            }
            di.skipBytes(size + 4);
        }
    }

    private static void drawHLine(BufferedImage im, int y, int x1, int x2) {
        int x = x1;
        while (x <= x2) {
            im.setRGB(x, y, -16777216);
            ++x;
        }
    }

    private static void drawVLine(BufferedImage im, int x, int y1, int y2) {
        int y = y1;
        while (y <= y2) {
            im.setRGB(x, y, -16777216);
            ++y;
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
            this.padLeft = padLeft;
            this.padRight = padRight;
            this.padTop = padTop;
            this.padBottom = padBottom;
            this.xDivs = xDivs;
            this.yDivs = yDivs;
        }

        public static NinePatch decode(DataInputStream di) throws IOException {
            di.skipBytes(1);
            int numXDivs = di.readByte();
            int numYDivs = di.readByte();
            di.skipBytes(1);
            di.skipBytes(8);
            int padLeft = di.readInt();
            int padRight = di.readInt();
            int padTop = di.readInt();
            int padBottom = di.readInt();
            di.skipBytes(4);
            int[] xDivs = new int[numXDivs];
            int i = 0;
            while (i < numXDivs) {
                xDivs[i] = di.readInt();
                ++i;
            }
            int[] yDivs = new int[numYDivs];
            int i2 = 0;
            while (i2 < numYDivs) {
                yDivs[i2] = di.readInt();
                ++i2;
            }
            return new NinePatch(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
        }
    }
}

