/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.schema;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Description {
    private String mDescriptionFile = new String("configuration" + File.separator + "description.xml");
    private Map<String, String> mDesMap = new HashMap<String, String>();
    private static Description mDescription = null;

    public static Description getInstance() {
        if (mDescription == null) {
            mDescription = new Description();
            return mDescription;
        }
        return mDescription;
    }

    private Description() {
        this.loadFile();
    }

    private void loadFile() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element theElem = null;
        Element root = null;
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document xmldoc = db.parse(new File(this.mDescriptionFile));
            root = xmldoc.getDocumentElement();
            NodeList list = root.getElementsByTagName("string");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                theElem = (Element)list.item(i);
                String id = theElem.getAttribute("id");
                String description = theElem.getTextContent();
                this.mDesMap.put(id, description);
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String fetchDescription(String id) {
        return this.mDesMap.get(id);
    }
}

