/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import java.awt.image.BufferedImage;

public class ImageData {
    int[] pixels;
    int width;
    int height;

    public ImageData(int width, int height) {
        this.width = width;
        this.height = height;
        this.pixels = new int[width * height];
    }

    public static ImageData bufferedImageToImageData(BufferedImage bi) {
        ImageData imgData = new ImageData(bi.getWidth(), bi.getHeight());
        int i = 0;
        while (i < imgData.width) {
            int j = 0;
            while (j < imgData.height) {
                imgData.pixels[i * imgData.width + j] = bi.getRGB(i, j);
                ++j;
            }
            ++i;
        }
        return imgData;
    }

    public static BufferedImage imageDataToBufferedImage(ImageData imgData) {
        BufferedImage bi = new BufferedImage(imgData.width, imgData.height, 6);
        int i = 0;
        while (i < imgData.width) {
            int j = 0;
            while (j < imgData.height) {
                bi.setRGB(i, j, imgData.pixels[i * imgData.width + j]);
                ++j;
            }
            ++i;
        }
        return bi;
    }
}

