/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.hotkey;

import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LanguageKeyListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Value;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class WebHotkeyField
extends WebTextField {
    private static final String EMPTY_HOTKEY_TEXT_KEY = "weblaf.ex.hotkeyfield.press";
    private List<Integer> keys = new ArrayList<Integer>();
    private boolean isCtrl = false;
    private boolean isAlt = false;
    private boolean isShift = false;
    private Integer keyCode = null;

    public WebHotkeyField() {
        this.updateFieldText();
        this.setEditable(false);
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(0);
        this.setSelectionColor(this.getBackground());
        this.setSelectedTextColor(this.getForeground());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (WebHotkeyField.this.keys.size() == 0) {
                    WebHotkeyField.this.clearData();
                }
                WebHotkeyField.this.keys.add(keyEvent.getKeyCode());
                this.updateKeys(keyEvent);
                WebHotkeyField.this.updateFieldText();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                WebHotkeyField.this.keys.remove((Object)keyEvent.getKeyCode());
                WebHotkeyField.this.updateFieldText();
            }

            private void updateKeys(KeyEvent keyEvent) {
                WebHotkeyField.this.isCtrl = SwingUtils.isCtrl(keyEvent);
                WebHotkeyField.this.isAlt = SwingUtils.isAlt(keyEvent);
                WebHotkeyField.this.isShift = SwingUtils.isShift(keyEvent);
                if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 16) {
                    WebHotkeyField.this.keyCode = keyEvent.getKeyCode();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && WebHotkeyField.this.isEnabled()) {
                    WebHotkeyField.this.clearData();
                    WebHotkeyField.this.updateFieldText();
                }
            }
        });
        LanguageManager.addLanguageKeyListener(EMPTY_HOTKEY_TEXT_KEY, new LanguageKeyListener(){

            @Override
            public void languageKeyUpdated(String string, Value value) {
                if (WebHotkeyField.this.isEmpty()) {
                    WebHotkeyField.this.updateFieldText();
                }
            }
        });
    }

    public void updateFieldText() {
        this.setText(this.isEmpty() ? LanguageManager.get(EMPTY_HOTKEY_TEXT_KEY) : this.getHotkeyData().toString());
    }

    public boolean isEmpty() {
        return this.keyCode == null && (!this.isCtrl && !this.isAlt && !this.isShift || this.keys.size() == 0);
    }

    public boolean isCtrl() {
        return this.isCtrl;
    }

    public void setCtrl(boolean bl) {
        this.isCtrl = bl;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setAlt(boolean bl) {
        this.isAlt = bl;
    }

    public boolean isShift() {
        return this.isShift;
    }

    public void setShift(boolean bl) {
        this.isShift = bl;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer n) {
        this.keyCode = n;
        this.updateFieldText();
    }

    public HotkeyData getHotkeyData() {
        HotkeyData hotkeyData = new HotkeyData();
        hotkeyData.setKeyCode(this.getKeyCode());
        hotkeyData.setCtrl(this.isCtrl());
        hotkeyData.setAlt(this.isAlt());
        hotkeyData.setShift(this.isShift());
        return hotkeyData;
    }

    public void setHotkeyData(HotkeyData hotkeyData) {
        this.setCtrl(hotkeyData.isCtrl());
        this.setAlt(hotkeyData.isAlt());
        this.setShift(hotkeyData.isShift());
        this.setKeyCode(hotkeyData.getKeyCode());
    }

    public void clearData() {
        this.keyCode = null;
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
    }
}

