/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.laf.tree.WebTreeElement;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DictionariesTreeRenderer
extends WebTreeCellRenderer {
    private static ImageIcon multidicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/multidic.png"));
    private static ImageIcon dicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/dic.png"));
    private static ImageIcon recordIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/record.png"));
    private static ImageIcon textIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/text.png"));
    private static ImageIcon tooltipIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/tooltip.png"));

    @Override
    public WebTreeElement getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 == null) {
            this.setIcon(multidicIcon);
            this.setText("Dictionaries");
        } else if (object2 instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object2;
            this.setIcon(dicIcon);
            this.setText("<html><b>" + dictionary.getPrefix() + "</b> - " + dictionary.getName() + "</html>");
        } else if (object2 instanceof Record) {
            Record record = (Record)object2;
            this.setIcon(recordIcon);
            this.setText(bl2 ? "<html><b>" + record.getKey() + "</b>" + (record.getHotkey() != null ? " (" + record.getHotkey() + ")" : "") + "</html>" : record.toString(true));
        } else if (object2 instanceof Value) {
            Value value = (Value)object2;
            this.setIcon(LanguageManager.getLanguageIcon(value.getLang()));
            this.setText(value.getLang() + (value.getMnemonic() != null ? " (" + value.getMnemonic() + ")" : "") + (value.getHotkey() != null ? " (" + value.getHotkey() + ")" : ""));
        } else if (object2 instanceof Text) {
            Text text = (Text)object2;
            this.setIcon(textIcon);
            this.setText(text.getState() == null ? text.toString() : "<html><b>" + text.getState() + "</b> -> " + text.toString() + "</html>");
        } else if (object2 instanceof Tooltip) {
            this.setIcon(tooltipIcon);
            this.setText(object2.toString());
        }
        return this;
    }
}

