/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButtonStyle;
import com.alee.laf.button.WebButtonUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Shape;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class WebButton
extends JButton
implements ShapeProvider,
LanguageMethods {
    public WebButton() {
    }

    public WebButton(Icon icon) {
        super(icon);
        this.setRound(WebButtonStyle.iconRound);
        this.setLeftRightSpacing(WebButtonStyle.iconLeftRightSpacing);
    }

    public WebButton(String string) {
        super(string);
    }

    public WebButton(Action action) {
        super(action);
    }

    public WebButton(String string, Icon icon) {
        super(string, icon);
    }

    public HotkeyInfo addHotkey(Integer n) {
        return this.addHotkey(new HotkeyData(n));
    }

    public HotkeyInfo addHotkey(boolean bl, boolean bl2, boolean bl3, Integer n) {
        return this.addHotkey(new HotkeyData(bl, bl2, bl3, n));
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(this, hotkeyData);
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData, boolean bl) {
        return HotkeyManager.registerHotkey((AbstractButton)this, hotkeyData, bl);
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey((AbstractButton)this, hotkeyData, tooltipWay);
    }

    public HotkeyInfo addHotkey(Component component, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(component, this, hotkeyData);
    }

    public HotkeyInfo addHotkey(Component component, HotkeyData hotkeyData, boolean bl) {
        return HotkeyManager.registerHotkey(component, (AbstractButton)this, hotkeyData, bl);
    }

    public HotkeyInfo addHotkey(Component component, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(component, (AbstractButton)this, hotkeyData, tooltipWay);
    }

    public List<HotkeyInfo> getHotkeys() {
        return HotkeyManager.getComponentHotkeys(this);
    }

    public void removeHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.unregisterHotkey(hotkeyInfo);
    }

    public void removeHotkeys() {
        HotkeyManager.unregisterHotkeys(this);
    }

    public Color getTopBgColor() {
        return this.getWebUI().getTopBgColor();
    }

    public void setTopBgColor(Color color) {
        this.getWebUI().setTopBgColor(color);
    }

    public Color getBottomBgColor() {
        return this.getWebUI().getBottomBgColor();
    }

    public void setBottomBgColor(Color color) {
        this.getWebUI().setBottomBgColor(color);
    }

    public Color getTopSelectedBgColor() {
        return this.getWebUI().getTopSelectedBgColor();
    }

    public void setTopSelectedBgColor(Color color) {
        this.getWebUI().setTopSelectedBgColor(color);
    }

    public Color getBottomSelectedBgColor() {
        return this.getWebUI().getBottomSelectedBgColor();
    }

    public void setBottomSelectedBgColor(Color color) {
        this.getWebUI().setBottomSelectedBgColor(color);
    }

    public Color getSelectedForeground() {
        return this.getWebUI().getSelectedForeground();
    }

    public void setSelectedForeground(Color color) {
        this.getWebUI().setSelectedForeground(color);
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.getWebUI().isRolloverDarkBorderOnly();
    }

    public void setRolloverDarkBorderOnly(boolean bl) {
        this.getWebUI().setRolloverDarkBorderOnly(bl);
    }

    public boolean isRolloverShine() {
        return this.getWebUI().isRolloverShine();
    }

    public void setRolloverShine(boolean bl) {
        this.getWebUI().setRolloverShine(bl);
    }

    public Color getShineColor() {
        return this.getWebUI().getShineColor();
    }

    public void setShineColor(Color color) {
        this.getWebUI().setShineColor(color);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int n) {
        this.getWebUI().setRound(n);
    }

    public boolean isDrawShade() {
        return this.getWebUI().isDrawShade();
    }

    public void setDrawShade(boolean bl) {
        this.getWebUI().setDrawShade(bl);
    }

    public boolean isRolloverShadeOnly() {
        return this.getWebUI().isRolloverShadeOnly();
    }

    public void setRolloverShadeOnly(boolean bl) {
        this.getWebUI().setRolloverShadeOnly(bl);
    }

    public boolean isShowDisabledShade() {
        return this.getWebUI().isShowDisabledShade();
    }

    public void setShowDisabledShade(boolean bl) {
        this.getWebUI().setShowDisabledShade(bl);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int n) {
        this.getWebUI().setShadeWidth(n);
    }

    public Color getShadeColor() {
        return this.getWebUI().getShadeColor();
    }

    public void setShadeColor(Color color) {
        this.getWebUI().setShadeColor(color);
    }

    public int getInnerShadeWidth() {
        return this.getWebUI().getInnerShadeWidth();
    }

    public void setInnerShadeWidth(int n) {
        this.getWebUI().setInnerShadeWidth(n);
    }

    public Color getInnerShadeColor() {
        return this.getWebUI().getInnerShadeColor();
    }

    public void setInnerShadeColor(Color color) {
        this.getWebUI().setInnerShadeColor(color);
    }

    public int getLeftRightSpacing() {
        return this.getWebUI().getLeftRightSpacing();
    }

    public void setLeftRightSpacing(int n) {
        this.getWebUI().setLeftRightSpacing(n);
    }

    public boolean isRolloverDecoratedOnly() {
        return this.getWebUI().isRolloverDecoratedOnly();
    }

    public void setRolloverDecoratedOnly(boolean bl) {
        this.getWebUI().setRolloverDecoratedOnly(bl);
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public void setUndecorated(boolean bl) {
        this.getWebUI().setUndecorated(bl);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public boolean isMoveIconOnPress() {
        return this.getWebUI().isMoveIconOnPress();
    }

    public void setMoveIconOnPress(boolean bl) {
        this.getWebUI().setMoveIconOnPress(bl);
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public void setDrawFocus(boolean bl) {
        this.getWebUI().setDrawFocus(bl);
    }

    public boolean isDrawBottom() {
        return this.getWebUI().isDrawBottom();
    }

    public void setDrawBottom(boolean bl) {
        this.getWebUI().setDrawBottom(bl);
    }

    public boolean isDrawLeft() {
        return this.getWebUI().isDrawLeft();
    }

    public void setDrawLeft(boolean bl) {
        this.getWebUI().setDrawLeft(bl);
    }

    public boolean isDrawRight() {
        return this.getWebUI().isDrawRight();
    }

    public void setDrawRight(boolean bl) {
        this.getWebUI().setDrawRight(bl);
    }

    public boolean isDrawTop() {
        return this.getWebUI().isDrawTop();
    }

    public void setDrawTop(boolean bl) {
        this.getWebUI().setDrawTop(bl);
    }

    public void setDrawSides(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.getWebUI().setDrawSides(bl, bl2, bl3, bl4);
    }

    public boolean isDrawTopLine() {
        return this.getWebUI().isDrawTopLine();
    }

    public void setDrawTopLine(boolean bl) {
        this.getWebUI().setDrawTopLine(bl);
    }

    public boolean isDrawLeftLine() {
        return this.getWebUI().isDrawLeftLine();
    }

    public void setDrawLeftLine(boolean bl) {
        this.getWebUI().setDrawLeftLine(bl);
    }

    public boolean isDrawBottomLine() {
        return this.getWebUI().isDrawBottomLine();
    }

    public void setDrawBottomLine(boolean bl) {
        this.getWebUI().setDrawBottomLine(bl);
    }

    public boolean isDrawRightLine() {
        return this.getWebUI().isDrawRightLine();
    }

    public void setDrawRightLine(boolean bl) {
        this.getWebUI().setDrawRightLine(bl);
    }

    public void setDrawLines(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.getWebUI().setDrawLines(bl, bl2, bl3, bl4);
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    @Override
    public void setMargin(Insets insets) {
        this.getWebUI().setMargin(insets);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebButtonUI getWebUI() {
        return (WebButtonUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebButtonUI)) {
            try {
                this.setUI((WebButtonUI)ReflectUtils.createInstance(WebLookAndFeel.buttonUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebButtonUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public void setLanguage(String string, Object ... objectArray) {
        LanguageManager.registerComponent(this, string, objectArray);
    }

    @Override
    public void updateLanguage(Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, objectArray);
    }

    @Override
    public void updateLanguage(String string, Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, string, objectArray);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater languageUpdater) {
        LanguageManager.registerLanguageUpdater(this, languageUpdater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon) {
        return WebButton.createIconWebButton(imageIcon, StyleConstants.smallRound);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n) {
        return WebButton.createIconWebButton(imageIcon, n, StyleConstants.shadeWidth);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, int n2) {
        return WebButton.createIconWebButton(imageIcon, n, n2, StyleConstants.innerShadeWidth);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, int n2, int n3) {
        return WebButton.createIconWebButton(imageIcon, n, n2, n3, StyleConstants.rolloverDecoratedOnly);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, boolean bl) {
        return WebButton.createIconWebButton(imageIcon, StyleConstants.smallRound, bl);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, boolean bl) {
        return WebButton.createIconWebButton(imageIcon, n, StyleConstants.shadeWidth, StyleConstants.innerShadeWidth, bl, StyleConstants.undecorated);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, int n2, int n3, boolean bl) {
        return WebButton.createIconWebButton(imageIcon, n, n2, n3, bl, StyleConstants.undecorated);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, int n2, int n3, boolean bl, boolean bl2) {
        return WebButton.createIconWebButton(imageIcon, n, n2, n3, bl, bl2, true);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        WebButton webButton = WebButton.createWebButton(n, n2, n3, 0, bl, bl2, bl3);
        webButton.setIcon(imageIcon);
        return webButton;
    }

    public static WebButton createWebButton(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        WebButton webButton = new WebButton();
        webButton.setRound(n);
        webButton.setShadeWidth(n2);
        webButton.setInnerShadeWidth(n3);
        webButton.setLeftRightSpacing(n4);
        webButton.setRolloverDecoratedOnly(bl);
        webButton.setUndecorated(bl2);
        webButton.setDrawFocus(bl3);
        return webButton;
    }
}

