/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabelStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class WebLabelUI
extends BasicLabelUI {
    private Insets margin = WebLabelStyle.margin;
    private Painter painter = WebLabelStyle.painter;
    private boolean drawShade = WebLabelStyle.drawShade;
    private Color shadeColor = WebLabelStyle.shadeColor;
    private JLabel label;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebLabelUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.label = (JLabel)jComponent;
        SwingUtils.setOrientation(this.label);
        this.label.setBackground(WebLabelStyle.backgroundColor);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebLabelUI.this.updateBorder();
            }
        };
        this.label.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.label.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.label = null;
        super.uninstallUI(jComponent);
    }

    private void updateBorder() {
        if (this.label != null) {
            boolean bl = this.label.getComponentOrientation().isLeftToRight();
            Insets insets = new Insets(this.margin.top, bl ? this.margin.left : this.margin.right, this.margin.bottom, bl ? this.margin.right : this.margin.left);
            if (this.painter != null) {
                Insets insets2 = this.painter.getMargin(this.label);
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
                insets.left = insets.left + (bl ? insets2.left : insets2.right);
                insets.right = insets.right + (bl ? insets2.right : insets2.left);
            }
            this.label.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.updateBorder();
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean bl) {
        this.drawShade = bl;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color color) {
        this.shadeColor = color;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, SwingUtils.size(jComponent), jComponent);
        }
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent, this.drawShade ? StyleConstants.defaultTextRenderingHints : StyleConstants.textRenderingHints);
        super.paint(graphics, jComponent);
        SwingUtils.restoreTextAntialias(graphics, map);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        if (this.drawShade) {
            graphics.setColor(jLabel.getForeground());
            this.paintShadowText(graphics, string, n, n2);
        } else {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
        }
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        if (jLabel.isEnabled() && this.drawShade) {
            graphics.setColor(jLabel.getBackground().darker());
            this.paintShadowText(graphics, string, n, n2);
        } else {
            super.paintDisabledText(jLabel, graphics, string, n, n2);
        }
    }

    private void paintShadowText(Graphics graphics, String string, int n, int n2) {
        graphics.translate(n, n2);
        LafUtils.paintTextShadow((Graphics2D)graphics, string, this.shadeColor);
        graphics.translate(-n, -n2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.painter != null) {
            if (jComponent.getLayout() != null) {
                dimension = SwingUtils.max(dimension, jComponent.getLayout().preferredLayoutSize(jComponent));
            }
            dimension = SwingUtils.max(dimension, this.painter.getPreferredSize(jComponent));
        }
        return dimension;
    }
}

