/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.WebMenuUI;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;

public class WebMenu
extends JMenu
implements LanguageMethods {
    private Point customMenuLocation = null;

    public WebMenu() {
    }

    public WebMenu(String string) {
        super(string);
    }

    public WebMenu(Action action) {
        super(action);
    }

    public WebMenu(String string, boolean bl) {
        super(string, bl);
    }

    public WebMenu(String string, Icon icon) {
        super(string);
        this.setIcon(icon);
    }

    @Override
    public void setMenuLocation(int n, int n2) {
        this.customMenuLocation = new Point(n, n2);
        if (this.getPopupMenu().isVisible()) {
            this.getPopupMenu().setLocation(n, n2);
        }
    }

    public Point getCustomMenuLocation() {
        return this.customMenuLocation;
    }

    @Override
    public void setPopupMenuVisible(boolean bl) {
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2 && (this.isEnabled() || !bl)) {
            if (bl && this.isShowing()) {
                Point point = this.getCustomMenuLocation();
                if (point == null) {
                    point = this.getPopupMenuOrigin();
                }
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    public WebMenuUI getWebUI() {
        return (WebMenuUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebMenuUI)) {
            try {
                this.setUI((WebMenuUI)ReflectUtils.createInstance(WebLookAndFeel.menuUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebMenuUI());
            }
        } else {
            this.setUI(this.getUI());
        }
        if (this.getPopupMenu() != null) {
            this.getPopupMenu().updateUI();
        }
    }

    @Override
    public void setLanguage(String string, Object ... objectArray) {
        LanguageManager.registerComponent(this, string, objectArray);
    }

    @Override
    public void updateLanguage(Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, objectArray);
    }

    @Override
    public void updateLanguage(String string, Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, string, objectArray);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater languageUpdater) {
        LanguageManager.registerLanguageUpdater(this, languageUpdater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }
}

