/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPaneStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class WebTabbedPaneUI
extends BasicTabbedPaneUI
implements ShapeProvider {
    private TabbedPaneStyle tabbedPaneStyle = WebTabbedPaneStyle.tabbedPaneStyle;
    private Color selectedTopBg = WebTabbedPaneStyle.selectedTopBg;
    private Color selectedBottomBg = WebTabbedPaneStyle.selectedBottomBg;
    private Color topBg = WebTabbedPaneStyle.topBg;
    private Color bottomBg = WebTabbedPaneStyle.bottomBg;
    private Map<Integer, Color> selectedForegroundAt = new HashMap<Integer, Color>();
    private Map<Integer, Painter> backgroundPainterAt = new HashMap<Integer, Painter>();
    private int round = WebTabbedPaneStyle.round;
    private int shadeWidth = WebTabbedPaneStyle.shadeWidth;
    private boolean rotateTabInsets = WebTabbedPaneStyle.rotateTabInsets;
    private Insets contentInsets = WebTabbedPaneStyle.contentInsets;
    private Insets tabInsets = WebTabbedPaneStyle.tabInsets;
    private Painter painter = WebTabbedPaneStyle.painter;
    private int tabRunIndent = WebTabbedPaneStyle.tabRunIndent;
    private int tabOverlay = WebTabbedPaneStyle.tabOverlay;
    private TabStretchType tabStretchType = WebTabbedPaneStyle.tabStretchType;
    private FocusAdapter focusAdapter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.tabPane);
        this.tabPane.setBackground(StyleConstants.backgroundColor);
        this.updateBorder(this.tabPane);
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WebTabbedPaneUI.this.tabPane.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addFocusListener(this.focusAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (this.focusAdapter != null) {
            jComponent.removeFocusListener(this.focusAdapter);
        }
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.tabPane, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder(JComponent jComponent) {
        Insets insets = this.getBackgroundInsets(jComponent);
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            jComponent.setBorder(new EmptyBorder(SwingUtils.max(insets, new Insets(this.shadeWidth, this.shadeWidth, this.shadeWidth, this.shadeWidth))));
        } else {
            jComponent.setBorder(new EmptyBorder(insets));
        }
    }

    private Insets getBackgroundInsets(JComponent jComponent) {
        return this.painter != null ? this.painter.getMargin(jComponent) : new Insets(0, 0, 0, 0);
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.tabPane);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public Insets getContentInsets() {
        return this.contentInsets;
    }

    public void setContentInsets(Insets insets) {
        this.contentInsets = insets;
    }

    public Insets getTabInsets() {
        return this.tabInsets;
    }

    public void setTabInsets(Insets insets) {
        this.tabInsets = insets;
    }

    public Color getSelectedTopBg() {
        return this.selectedTopBg;
    }

    public void setSelectedTopBg(Color color) {
        this.selectedTopBg = color;
    }

    public Color getSelectedBottomBg() {
        return this.selectedBottomBg;
    }

    public void setSelectedBottomBg(Color color) {
        this.selectedBottomBg = color;
    }

    public Color getTopBg() {
        return this.topBg;
    }

    public void setTopBg(Color color) {
        this.topBg = color;
    }

    public Color getBottomBg() {
        return this.bottomBg;
    }

    public void setBottomBg(Color color) {
        this.bottomBg = color;
    }

    public void setSelectedForegroundAt(int n, Color color) {
        this.selectedForegroundAt.put(n, color);
    }

    public Color getSelectedForegroundAt(int n) {
        return this.selectedForegroundAt.get(n);
    }

    public void setBackgroundPainterAt(int n, Painter painter) {
        this.backgroundPainterAt.put(n, painter);
    }

    public Painter getBackgroundPainterAt(int n) {
        return this.backgroundPainterAt.get(n);
    }

    public TabbedPaneStyle getTabbedPaneStyle() {
        return this.tabbedPaneStyle;
    }

    public void setTabbedPaneStyle(TabbedPaneStyle tabbedPaneStyle) {
        this.tabbedPaneStyle = tabbedPaneStyle;
        this.updateBorder(this.tabPane);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.updateBorder(this.tabPane);
    }

    public int getTabRunIndent() {
        return this.tabRunIndent;
    }

    public void setTabRunIndent(int n) {
        this.tabRunIndent = n;
    }

    public int getTabOverlay() {
        return this.tabOverlay;
    }

    public void setTabOverlay(int n) {
        this.tabOverlay = n;
    }

    public TabStretchType getTabStretchType() {
        return this.tabStretchType;
    }

    public void setTabStretchType(TabStretchType tabStretchType) {
        this.tabStretchType = tabStretchType;
    }

    @Override
    protected int getTabRunIndent(int n, int n2) {
        return this.tabRunIndent;
    }

    @Override
    protected int getTabRunOverlay(int n) {
        return this.tabOverlay;
    }

    @Override
    protected boolean shouldPadTabRun(int n, int n2) {
        return !this.tabStretchType.equals((Object)TabStretchType.never) && (this.tabStretchType.equals((Object)TabStretchType.always) || this.tabStretchType.equals((Object)TabStretchType.multiline) && this.runCount > 1);
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            Insets insets = n == 1 ? new Insets(1, 2, 1, 2) : (n == 3 ? new Insets(2, 2, 0, 2) : (n == 2 ? new Insets(2, 1, 2, 1) : (n == 4 ? new Insets(2, 2, 2, 0) : new Insets(0, 0, 0, 0))));
            insets.top += this.contentInsets.top - 1;
            insets.left += this.contentInsets.left - 1;
            insets.bottom += this.contentInsets.bottom - 1;
            insets.right += this.contentInsets.right - 1;
            return insets;
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(n == 4 ? 1 : 0, 1, 0, 2) : new Insets(-1, -1, 0, 0), insets, n);
        return insets;
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        Insets insets = SwingUtils.copy(this.tabInsets);
        if (n2 == 0 && this.tabPane.getSelectedIndex() == 0) {
            --insets.left;
            ++insets.right;
        }
        if (this.rotateTabInsets) {
            Insets insets2 = new Insets(0, 0, 0, 0);
            WebTabbedPaneUI.rotateInsets(insets, insets2, n);
            return insets2;
        }
        return insets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(2, 2, 2, 1) : new Insets(0, 0, 0, 0), insets, n);
        return insets;
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            return super.getTabLabelShiftX(n, n2, bl);
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            return super.getTabLabelShiftY(n, n2, bl);
        }
        return 0;
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2;
        Object object;
        GeneralPath generalPath;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object2 = LafUtils.setupAntialias(graphics2D);
        GeneralPath generalPath2 = this.createTabShape(TabShapeType.border, n, n3, n4, n5, n6, bl);
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            generalPath = this.createTabShape(TabShapeType.shade, n, n3, n4, n5, n6, bl);
            LafUtils.drawShade(graphics2D, (Shape)generalPath, StyleConstants.shadeColor, this.shadeWidth, new Rectangle2D.Double(0.0, 0.0, this.tabPane.getWidth(), n4 + n6), this.round > 0);
        }
        generalPath = this.createTabShape(TabShapeType.background, n, n3, n4, n5, n6, bl);
        if (this.backgroundPainterAt.containsKey(n2) && bl) {
            object = LafUtils.intersectClip(graphics2D, generalPath);
            Painter painter = this.backgroundPainterAt.get(n2);
            painter.paint(graphics2D, new Rectangle(n3, n4, n5, n6), this.tabPane);
            LafUtils.restoreClip(graphics2D, (Shape)object);
        } else {
            object = this.getTopTabBgPoint(n, n3, n4, n5, n6);
            Point point = this.getBottomTabBgPoint(n, n3, n4, n5, n6);
            if (bl) {
                Color color = this.tabPane.getBackgroundAt(n2);
                color = color != null ? color : this.tabPane.getBackground();
                graphics2D.setPaint(new GradientPaint(((Point)object).x, ((Point)object).y, this.selectedTopBg, point.x, point.y, color));
            } else {
                graphics2D.setPaint(new GradientPaint(((Point)object).x, ((Point)object).y, this.topBg, point.x, point.y, this.bottomBg));
            }
            graphics2D.fill(bl ? generalPath2 : generalPath);
        }
        graphics2D.setPaint(StyleConstants.darkBorderColor);
        graphics2D.draw(generalPath2);
        boolean bl3 = bl2 = bl && this.tabPane.isFocusOwner();
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            LafUtils.drawCustomWebFocus(graphics2D, null, StyleConstants.focusType, generalPath2, null, bl2);
        }
        LafUtils.restoreAntialias(graphics2D, object2);
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                Color color = this.tabPane.getForegroundAt(n2);
                if (bl && color instanceof UIResource) {
                    if (this.selectedForegroundAt.containsKey(n2)) {
                        color = this.selectedForegroundAt.get(n2);
                    } else {
                        Color color2 = UIManager.getColor("TabbedPane.selectedForeground");
                        if (color2 != null) {
                            color = color2;
                        }
                    }
                }
                graphics.setColor(color);
                SwingUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                SwingUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                SwingUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    private GeneralPath createTabShape(TabShapeType tabShapeType, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Insets insets = this.tabPane.getInsets();
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.attached) && bl && n == 1 && n2 == insets.left) {
            --n2;
            ++n4;
        }
        int n6 = this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? this.round : 0;
        GeneralPath generalPath = new GeneralPath(0);
        if (n == 1) {
            generalPath.moveTo(n2, n3 + n5 + this.getChange(tabShapeType));
            generalPath.lineTo(n2, n3 + n6);
            generalPath.quadTo(n2, n3, n2 + n6, n3);
            generalPath.lineTo(n2 + n4 - n6, n3);
            generalPath.quadTo(n2 + n4, n3, n2 + n4, n3 + n6);
            generalPath.lineTo(n2 + n4, n3 + n5 + this.getChange(tabShapeType));
        } else if (n == 3) {
            generalPath.moveTo(n2, n3 - this.getChange(tabShapeType));
            generalPath.lineTo(n2, n3 + n5 - n6);
            generalPath.quadTo(n2, n3 + n5, n2 + n6, n3 + n5);
            generalPath.lineTo(n2 + n4 - n6, n3 + n5);
            generalPath.quadTo(n2 + n4, n3 + n5, n2 + n4, n3 + n5 - n6);
            generalPath.lineTo(n2 + n4, n3 - this.getChange(tabShapeType));
        } else if (n == 2) {
            generalPath.moveTo(n2 + n4 + this.getChange(tabShapeType), n3);
            generalPath.lineTo(n2 + n6, n3);
            generalPath.quadTo(n2, n3, n2, n3 + n6);
            generalPath.lineTo(n2, n3 + n5 - n6);
            generalPath.quadTo(n2, n3 + n5, n2 + n6, n3 + n5);
            generalPath.lineTo(n2 + n4 + this.getChange(tabShapeType), n3 + n5);
        } else {
            generalPath.moveTo(n2 - this.getChange(tabShapeType), n3);
            generalPath.lineTo(n2 + n4 - n6, n3);
            generalPath.quadTo(n2 + n4, n3, n2 + n4, n3 + n6);
            generalPath.lineTo(n2 + n4, n3 + n5 - n6);
            generalPath.quadTo(n2 + n4, n3 + n5, n2 + n4 - n6, n3 + n5);
            generalPath.lineTo(n2 - this.getChange(tabShapeType), n3 + n5);
        }
        return generalPath;
    }

    private int getChange(TabShapeType tabShapeType) {
        if (tabShapeType.equals((Object)TabShapeType.shade)) {
            return -(this.round > 0 ? this.round : 1);
        }
        if (tabShapeType.equals((Object)TabShapeType.border)) {
            return -1;
        }
        if (tabShapeType.equals((Object)TabShapeType.backgroundPainter)) {
            return 2;
        }
        return 0;
    }

    private Point getTopTabBgPoint(int n, int n2, int n3, int n4, int n5) {
        if (n == 1) {
            return new Point(n2, n3);
        }
        if (n == 3) {
            return new Point(n2, n3 + n5);
        }
        if (n == 2) {
            return new Point(n2, n3);
        }
        return new Point(n2 + n4, n3);
    }

    private Point getBottomTabBgPoint(int n, int n2, int n3, int n4, int n5) {
        if (n == 1) {
            return new Point(n2, n3 + n5 - 4);
        }
        if (n == 3) {
            return new Point(n2, n3 + 4);
        }
        if (n == 2) {
            return new Point(n2 + n4 - 4, n3);
        }
        return new Point(n2 + 4, n3);
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        int n3 = this.getTabAreaLength(n);
        Insets insets = this.tabPane.getInsets();
        if (n == 1 || n == 3) {
            ++insets.right;
        } else {
            ++insets.bottom;
        }
        Rectangle rectangle = n2 != -1 ? this.getTabBounds(this.tabPane, n2) : null;
        Shape shape = this.createBackgroundShape(n, n3, insets, rectangle);
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            GeneralPath generalPath = new GeneralPath(0);
            generalPath.append(new Rectangle2D.Double(0.0, 0.0, this.tabPane.getWidth(), this.tabPane.getHeight()), false);
            generalPath.append(shape, false);
            LafUtils.drawShade(graphics2D, shape, StyleConstants.shadeColor, this.shadeWidth, generalPath, this.round > 0);
            if (this.backgroundPainterAt.containsKey(n2)) {
                Shape shape2 = LafUtils.intersectClip(graphics2D, shape);
                this.backgroundPainterAt.get(n2).paint(graphics2D, shape.getBounds(), this.tabPane);
                LafUtils.restoreClip(graphics2D, shape2);
            } else {
                Color color = n2 != -1 ? this.tabPane.getBackgroundAt(n2) : null;
                graphics2D.setPaint(color != null ? color : this.tabPane.getBackground());
                graphics2D.fill(shape);
            }
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.draw(shape);
            LafUtils.drawCustomWebFocus(graphics2D, null, StyleConstants.focusType, shape, null, this.tabPane.isFocusOwner());
        } else {
            if (this.backgroundPainterAt.containsKey(n2)) {
                this.backgroundPainterAt.get(n2).paint(graphics2D, shape.getBounds(), this.tabPane);
            } else {
                Color color = n2 != -1 ? this.tabPane.getBackgroundAt(n2) : null;
                graphics2D.setPaint(color != null ? color : this.tabPane.getBackground());
                graphics2D.fill(shape);
            }
            graphics2D.setPaint(Color.GRAY);
            if (n == 1) {
                if (rectangle != null) {
                    if (insets.left < rectangle.x) {
                        graphics2D.drawLine(insets.left, insets.top + n3, rectangle.x, insets.top + n3);
                    }
                    if (rectangle.x + rectangle.width < this.tabPane.getWidth() - insets.right) {
                        graphics2D.drawLine(rectangle.x + rectangle.width, insets.top + n3, this.tabPane.getWidth() - insets.right, insets.top + n3);
                    }
                } else {
                    graphics2D.drawLine(insets.left, insets.top + n3, this.tabPane.getWidth() - insets.right, insets.top + n3);
                }
            } else if (n == 3 || n == 2 || n == 4) {
                // empty if block
            }
        }
        LafUtils.restoreAntialias(graphics2D, object);
    }

    private int getTabAreaLength(int n) {
        return n == 1 || n == 3 ? this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - 1 : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - 1;
    }

    private Shape createBackgroundShape(int n, int n2, Insets insets, Rectangle rectangle) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            if (rectangle != null) {
                GeneralPath generalPath = new GeneralPath(0);
                if (n == 1) {
                    int n3 = insets.top + n2;
                    generalPath.moveTo(rectangle.x, n3);
                    if (rectangle.x > insets.left + this.round && this.round > 0) {
                        generalPath.lineTo(insets.left + this.round, n3);
                        generalPath.quadTo(insets.left, n3, insets.left, n3 + this.round);
                    } else {
                        generalPath.lineTo(insets.left, n3);
                    }
                    if (this.round > 0) {
                        generalPath.lineTo(insets.left, this.tabPane.getHeight() - insets.bottom - this.round);
                        generalPath.quadTo(insets.left, this.tabPane.getHeight() - insets.bottom, insets.left + this.round, this.tabPane.getHeight() - insets.bottom);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right - this.round, this.tabPane.getHeight() - insets.bottom);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom, this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom - this.round);
                    } else {
                        generalPath.lineTo(insets.left, this.tabPane.getHeight() - insets.bottom);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom);
                    }
                    if (rectangle.x + rectangle.width < this.tabPane.getWidth() - insets.right - this.round && this.round > 0) {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, n3 + this.round);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, n3, this.tabPane.getWidth() - insets.right - this.round, n3);
                    } else {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, n3);
                    }
                    generalPath.lineTo(rectangle.x + rectangle.width, n3);
                } else if (n == 3) {
                    int n4 = this.tabPane.getHeight() - insets.bottom - n2;
                    generalPath.moveTo(rectangle.x, n4);
                    if (rectangle.x > insets.left + this.round && this.round > 0) {
                        generalPath.lineTo(insets.left + this.round, n4);
                        generalPath.quadTo(insets.left, n4, insets.left, n4 - this.round);
                    } else {
                        generalPath.lineTo(insets.left, n4);
                    }
                    if (this.round > 0) {
                        generalPath.lineTo(insets.left, insets.top + this.round);
                        generalPath.quadTo(insets.left, insets.top, insets.left + this.round, insets.top);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right - this.round, insets.top);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, insets.top, this.tabPane.getWidth() - insets.right, insets.top + this.round);
                    } else {
                        generalPath.lineTo(insets.left, insets.top);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, insets.top);
                    }
                    if (rectangle.x + rectangle.width < this.tabPane.getWidth() - insets.right - this.round && this.round > 0) {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, n4 - this.round);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, n4, this.tabPane.getWidth() - insets.right - this.round, n4);
                    } else {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, n4);
                    }
                    generalPath.lineTo(rectangle.x + rectangle.width, n4);
                } else if (n == 2) {
                    int n5 = insets.left + n2;
                    generalPath.moveTo(n5, rectangle.y);
                    if (rectangle.y > insets.top + this.round && this.round > 0) {
                        generalPath.lineTo(n5, insets.top + this.round);
                        generalPath.quadTo(n5, insets.top, n5 + this.round, insets.top);
                    } else {
                        generalPath.lineTo(n5, insets.top);
                    }
                    if (this.round > 0) {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right - this.round, insets.top);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, insets.top, this.tabPane.getWidth() - insets.right, insets.top + this.round);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom - this.round);
                        generalPath.quadTo(this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom, this.tabPane.getWidth() - insets.right - this.round, this.tabPane.getHeight() - insets.bottom);
                    } else {
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, insets.top);
                        generalPath.lineTo(this.tabPane.getWidth() - insets.right, this.tabPane.getHeight() - insets.bottom);
                    }
                    if (rectangle.y + rectangle.height < this.tabPane.getHeight() - insets.bottom - this.round && this.round > 0) {
                        generalPath.lineTo(n5 + this.round, this.tabPane.getHeight() - insets.bottom);
                        generalPath.quadTo(n5, this.tabPane.getHeight() - insets.bottom, n5, this.tabPane.getHeight() - insets.bottom - this.round);
                    } else {
                        generalPath.lineTo(n5, this.tabPane.getHeight() - insets.bottom);
                    }
                    generalPath.lineTo(n5, rectangle.y + rectangle.height);
                } else {
                    int n6 = this.tabPane.getWidth() - insets.right - n2;
                    generalPath.moveTo(n6, rectangle.y);
                    if (rectangle.y > insets.top + this.round && this.round > 0) {
                        generalPath.lineTo(n6, insets.top + this.round);
                        generalPath.quadTo(n6, insets.top, n6 - this.round, insets.top);
                    } else {
                        generalPath.lineTo(n6, insets.top);
                    }
                    if (this.round > 0) {
                        generalPath.lineTo(insets.left + this.round, insets.top);
                        generalPath.quadTo(insets.left, insets.top, insets.left, insets.top + this.round);
                        generalPath.lineTo(insets.left, this.tabPane.getHeight() - insets.bottom - this.round);
                        generalPath.quadTo(insets.left, this.tabPane.getHeight() - insets.bottom, insets.left + this.round, this.tabPane.getHeight() - insets.bottom);
                    } else {
                        generalPath.lineTo(insets.left, insets.top);
                        generalPath.lineTo(insets.left, this.tabPane.getHeight() - insets.bottom);
                    }
                    if (rectangle.y + rectangle.height < this.tabPane.getHeight() - insets.bottom - this.round && this.round > 0) {
                        generalPath.lineTo(n6 - this.round, this.tabPane.getHeight() - insets.bottom);
                        generalPath.quadTo(n6, this.tabPane.getHeight() - insets.bottom, n6, this.tabPane.getHeight() - insets.bottom - this.round);
                    } else {
                        generalPath.lineTo(n6, this.tabPane.getHeight() - insets.bottom);
                    }
                    generalPath.lineTo(n6, rectangle.y + rectangle.height);
                }
                return generalPath;
            }
            boolean bl = n == 1;
            boolean bl2 = n == 3;
            boolean bl3 = n == 2;
            boolean bl4 = n == 4;
            return new RoundRectangle2D.Double(insets.left + (bl3 ? n2 : 0), insets.top + (bl ? n2 : 0), this.tabPane.getWidth() - insets.left - insets.right - (bl3 || bl4 ? n2 : 0), this.tabPane.getHeight() - insets.top - insets.bottom - (bl || bl2 ? n2 : 0), this.round * 2, this.round * 2);
        }
        int n7 = insets.left + (n == 2 ? n2 : 0);
        int n8 = insets.top + (n == 1 ? n2 : 0);
        int n9 = this.tabPane.getWidth() - insets.left - insets.right - (n == 2 || n == 4 ? n2 : 0);
        int n10 = this.tabPane.getHeight() - insets.top - insets.bottom - (n == 1 || n == 3 ? n2 : 0);
        return new Rectangle(n7, n8, n9 + 1, n10);
    }

    public Shape getContentClip() {
        RoundRectangle2D.Double double_ = null;
        int n = this.tabPane.getTabPlacement();
        int n2 = this.getTabAreaLength(n);
        Insets insets = this.tabPane.getInsets();
        if (n == 1) {
            double_ = new RoundRectangle2D.Double(insets.left, insets.top + n2, this.tabPane.getWidth() - insets.left - insets.right, this.tabPane.getHeight() - insets.top - n2 - insets.bottom, this.round * 2, this.round * 2);
        } else if (n == 3) {
            double_ = new RoundRectangle2D.Double(insets.left, insets.top, this.tabPane.getWidth() - insets.left - insets.right, this.tabPane.getHeight() - insets.top - n2 - insets.bottom, this.round * 2, this.round * 2);
        } else if (n == 2) {
            double_ = new RoundRectangle2D.Double(insets.left + n2, insets.top, this.tabPane.getWidth() - insets.left - n2 - insets.right, this.tabPane.getHeight() - insets.top - insets.bottom, this.round * 2, this.round * 2);
        } else if (n == 4) {
            double_ = new RoundRectangle2D.Double(insets.left, insets.top, this.tabPane.getWidth() - insets.left - n2 - insets.right, this.tabPane.getHeight() - insets.top - insets.bottom, this.round * 2, this.round * 2);
        }
        return double_;
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, SwingUtils.size(jComponent), jComponent);
        }
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent);
        super.paint(graphics, jComponent);
        SwingUtils.restoreTextAntialias(graphics, map);
    }

    private static enum TabShapeType {
        shade,
        background,
        backgroundPainter,
        border;

    }
}

