/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.laf.StyleConstants;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FocusManager {
    private static boolean initialized = false;
    private static List<FocusTracker> trackedList = new ArrayList<FocusTracker>();
    private static Map<Component, Boolean> focusCache = new HashMap<Component, Boolean>();
    private static List<GlobalFocusListener> globalFocusListeners = new ArrayList<GlobalFocusListener>();
    private static Component oldFocusOwner;
    private static Component focusOwner;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof FocusEvent && globalFocusListeners.size() > 0) {
                        FocusEvent focusEvent = (FocusEvent)aWTEvent;
                        if (focusEvent.getID() == 1005 && focusEvent.getOppositeComponent() == null) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getComponent(), null);
                        } else if (focusEvent.getID() == 1004) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getOppositeComponent(), focusEvent.getComponent());
                        }
                    }
                }
            }, 4L);
            FocusManager.registerGlobalFocusListener(new GlobalFocusListener(){

                @Override
                public void focusChanged(Component component, Component component2) {
                    oldFocusOwner = component;
                    focusOwner = component2;
                    if (StyleConstants.DEBUG) {
                        Iterator<Object> iterator = component != null ? component.getClass().getName() : null;
                        Object object = component2 != null ? component2.getClass().getName() : null;
                        System.out.println("Focus changed: " + iterator + " --> " + (String)object);
                    }
                    for (Object object : CollectionUtils.copy(trackedList)) {
                        boolean bl;
                        if (!object.isTrackingEnabled()) continue;
                        Component component3 = object.getTrackedComponent();
                        boolean bl2 = object.isUniteWithChilds() ? SwingUtils.isEqualOrChild(component3, component2) : (bl = component3 == component2);
                        if (object.isListenGlobalChange()) {
                            object.focusChanged(bl);
                        } else if (FocusManager.getCachedFocusOwnerState(component3) != bl) {
                            object.focusChanged(bl);
                        }
                        focusCache.put(component3, bl);
                    }
                }
            });
        }
    }

    private static Boolean getCachedFocusOwnerState(Component component) {
        return focusCache.containsKey(component) ? focusCache.get(component) : false;
    }

    public static Component getFocusOwner() {
        return focusOwner;
    }

    public static Component getOldFocusOwner() {
        return oldFocusOwner;
    }

    public static void registerGlobalFocusListener(GlobalFocusListener globalFocusListener) {
        globalFocusListeners.add(globalFocusListener);
    }

    public static void unregisterGlobalFocusListener(GlobalFocusListener globalFocusListener) {
        globalFocusListeners.remove(globalFocusListener);
    }

    private static void fireGlobalFocusChanged(Component component, Component component2) {
        for (GlobalFocusListener globalFocusListener : CollectionUtils.copy(globalFocusListeners)) {
            globalFocusListener.focusChanged(component, component2);
        }
    }

    public static void registerFocusTracker(FocusTracker focusTracker) {
        trackedList.add(focusTracker);
    }

    public static void unregisterFocusTracker(FocusTracker focusTracker) {
        trackedList.remove(focusTracker);
    }
}

