/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.Color;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class SwingLazyValue
implements UIDefaults.LazyValue {
    private String className;
    private String methodName;
    private Object[] args;

    public SwingLazyValue(String string) {
        this(string, (String)null);
    }

    public SwingLazyValue(String string, String string2) {
        this(string, string2, null);
    }

    public SwingLazyValue(String string, Object[] objectArray) {
        this(string, null, objectArray);
    }

    public SwingLazyValue(String string, String string2, Object[] objectArray) {
        this.className = string;
        this.methodName = string2;
        if (objectArray != null) {
            this.args = (Object[])objectArray.clone();
        }
    }

    @Override
    public Object createValue(UIDefaults uIDefaults) {
        try {
            Class<?> clazz = Class.forName(this.className, true, null);
            if (this.methodName != null) {
                Class[] classArray = this.getClassArray(this.args);
                Method method = clazz.getMethod(this.methodName, classArray);
                this.makeAccessible(method);
                return method.invoke(clazz, this.args);
            }
            Class[] classArray = this.getClassArray(this.args);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.makeAccessible(constructor);
            return constructor.newInstance(this.args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void makeAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    private Class[] getClassArray(Object[] objectArray) {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i] instanceof Integer ? Integer.TYPE : (objectArray[i] instanceof Boolean ? Boolean.TYPE : (objectArray[i] instanceof ColorUIResource ? Color.class : objectArray[i].getClass()));
            }
        }
        return classArray;
    }
}

