/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NativeStackCallInfo {
    private static final Pattern SOURCE_NAME_PATTERN = Pattern.compile("^(.+):(\\d+)$");
    private String mLibrary;
    private String mMethod;
    private String mSourceFile;
    private int mLineNumber = -1;

    public NativeStackCallInfo(String lib, String method, String sourceFile) {
        this.mLibrary = lib;
        this.mMethod = method;
        Matcher m = SOURCE_NAME_PATTERN.matcher(sourceFile);
        if (m.matches()) {
            this.mSourceFile = m.group(1);
            try {
                this.mLineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.mSourceFile = sourceFile;
        }
    }

    public String getLibraryName() {
        return this.mLibrary;
    }

    public String getMethodName() {
        return this.mMethod;
    }

    public String getSourceFile() {
        return this.mSourceFile;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }
}

