/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import com.miui.home.launcher.upsidescene.data.FreeStyle;
import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import com.miui.theme.tool.freestyle.FreeStylePanel;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FreeStyleTree
extends JTree {
    private FreeStyle mFreeStyle;
    private DefaultMutableTreeNode mRoot;
    private Sprite mNextSelectSprite = null;

    public FreeStyleTree() {
        this.getSelectionModel().setSelectionMode(1);
    }

    public void setFreeStyle(FreeStyle freeStyle) {
        this.mFreeStyle = freeStyle;
        this.refresh();
    }

    public void refresh() {
        Object lastSelectObject = null;
        DefaultMutableTreeNode lastSelectNode = null;
        if (this.getLastSelectedPathComponent() != null) {
            lastSelectObject = ((DefaultMutableTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        }
        if (this.mNextSelectSprite != null) {
            lastSelectObject = this.mNextSelectSprite;
            this.mNextSelectSprite = null;
        }
        this.mRoot = new DefaultMutableTreeNode(this.mFreeStyle);
        if (this.mFreeStyle.equals(lastSelectObject)) {
            lastSelectNode = this.mRoot;
        }
        ((DefaultTreeModel)this.getModel()).setRoot(this.mRoot);
        int i = 0;
        while (i < FreeStylePanel.screenTypes.length) {
            Screen screen = this.mFreeStyle.getSpecifyScreen(FreeStylePanel.screenTypes[i]);
            DefaultMutableTreeNode screenNode = new DefaultMutableTreeNode(screen);
            screenNode.getPath();
            this.mRoot.add(screenNode);
            if (screen.equals(lastSelectObject)) {
                lastSelectNode = screenNode;
            }
            int j = 0;
            while (j < screen.getSprites().size()) {
                Sprite sprite = screen.getSprites().get(j);
                DefaultMutableTreeNode spriteNode = new DefaultMutableTreeNode(sprite);
                screenNode.add(spriteNode);
                if (sprite.equals(lastSelectObject)) {
                    lastSelectNode = spriteNode;
                }
                ++j;
            }
            ++i;
        }
        this.expansionAll();
        if (lastSelectNode != null) {
            this.setSelectionPath(new TreePath(lastSelectNode.getPath()));
        }
    }

    public void expansionAll() {
        if (this.getModel().getRoot() != null) {
            this.expansionAll(new TreePath(this.getModel().getRoot()), true);
        }
    }

    private void expansionAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expansionAll(path, expand);
            }
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    public void setNextSelectSprite(Sprite sprite) {
        this.mNextSelectSprite = sprite;
    }
}

