/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.init;

import com.miui.theme.tool.init.ColorFile;
import com.miui.theme.tool.init.ThemeInitHelperManager;
import com.miui.theme.tool.init.ThemeInitUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class InitData {
    public static final String THEME_INIT = "ThemeInit";
    public static final String PREVIEW = "Preview";
    public static final String PATH = "Path";
    public static final String EXTRA = "extra";
    public static final double EXTRA_ALPHA = 0.3;
    public static final String COLOR = "Color";
    public static final String SHOW_COLOR = "showColor";
    public static final String THEME_VALUES = "ThemeValues";
    public static final String NANE = "name";
    public static final String VALUE = "value";
    public static final String SRC = "src";
    public static String CHARSET = "utf-8";
    private File mFile;
    public HashMap<String, String> mPreview = new HashMap();
    public HashMap<String, ColorFile> mColorFileMap = new HashMap();

    public InitData() {
        this.mFile = new File(String.valueOf(ThemeInitHelperManager.getDataInitFolder()) + File.separator + "data.xml");
    }

    public void save() {
        Element themeInit = new Element(THEME_INIT);
        Element preview = new Element(PREVIEW);
        themeInit.addContent((Content)preview);
        for (String key : this.mPreview.keySet()) {
            Element path = new Element(PATH);
            preview.addContent((Content)path);
            path.setAttribute(NANE, key);
            path.setAttribute(SRC, this.mPreview.get(key));
        }
        for (String key : this.mColorFileMap.keySet()) {
            ColorFile colorFileMap = this.mColorFileMap.get(key);
            Element color = new Element(COLOR);
            themeInit.addContent((Content)color);
            color.setAttribute(VALUE, colorFileMap.mColor);
            color.setAttribute(NANE, colorFileMap.mName);
            color.setAttribute(SHOW_COLOR, colorFileMap.mShowColor);
            for (String path : colorFileMap.mPath) {
                Element p = new Element(PATH);
                color.addContent((Content)p);
                p.setAttribute(SRC, path);
                if (!colorFileMap.mPathExtraMap.containsKey(path)) continue;
                p.setAttribute(EXTRA, colorFileMap.mPathExtraMap.get(path));
            }
            for (String value : colorFileMap.mThemeValues) {
                Element v = new Element(VALUE);
                color.addContent((Content)v);
                v.setAttribute(VALUE, value);
            }
        }
        XMLOutputter outputter = new XMLOutputter();
        try {
            if (!this.mFile.getParentFile().exists()) {
                this.mFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.mFile);
            Format format = Format.getPrettyFormat();
            format.setEncoding(CHARSET);
            format.setIndent("    ");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
            outputter.setFormat(format);
            outputter.output(new Document(themeInit), (Writer)osw);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void parse() {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build(this.mFile);
            Element themeInit = document.getRootElement();
            for (Element ele : themeInit.getChildren()) {
                if (ele.getName().equals(PREVIEW)) {
                    for (Element path : ele.getChildren()) {
                        this.mPreview.put(path.getAttributeValue(NANE), ThemeInitUtil.assurePath(path.getAttributeValue(SRC)));
                    }
                }
                if (!ele.getName().equals(COLOR)) continue;
                ColorFile cf = new ColorFile();
                cf.mColor = ele.getAttributeValue(VALUE);
                cf.mName = ele.getAttributeValue(NANE);
                cf.mShowColor = ele.getAttributeValue(SHOW_COLOR);
                for (Element e : ele.getChildren()) {
                    if (e.getName().equals(PATH)) {
                        String path = ThemeInitUtil.assurePath(e.getAttributeValue(SRC));
                        cf.mPath.add(path);
                        if (e.getAttribute(EXTRA) != null) {
                            cf.mPathExtraMap.put(path, e.getAttributeValue(EXTRA));
                        }
                    }
                    if (!e.getName().equals(THEME_VALUES)) continue;
                    cf.mThemeValues.add(e.getAttributeValue(VALUE));
                }
                this.mColorFileMap.put(cf.mColor, cf);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

